/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.thecopperierage.item.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.frozenblock.thecopperierage.TCAConstants;
import net.frozenblock.thecopperierage.config.TCAConfig;
import net.frozenblock.thecopperierage.tag.TCAItemTags;
import net.minecraft.class_12123;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9886;
import org.jetbrains.annotations.NotNull;

public final class OxidizableItemHelper {
    private static final Map<class_1792, Pair<class_9285, class_9285>> OXIDIZABLE_ATTRIBUTES = new Object2ObjectLinkedOpenHashMap();
    private static final Map<class_1792, Pair<class_12123, class_12123>> OXIDIZABLE_KINETIC_WEAPONS = new Object2ObjectLinkedOpenHashMap();
    private static final float COPPER_MINING_SPEED = class_9886.field_61350.comp_2932();
    private static final float IRON_MINING_SPEED = class_9886.field_52587.comp_2932();
    public static final float EXPOSED_THRESHOLD = 0.45f;
    public static final float WEATHERED_THRESHOLD = 0.65f;
    public static final float OXIDIZED_THRESHOLD = 0.85f;

    public static void bootstrap() {
        OxidizableItemHelper.addOxidizableAttributesItem(class_1802.field_61338, class_1802.field_8371);
        OxidizableItemHelper.addOxidizableAttributesItem(class_1802.field_61339, class_1802.field_8699);
        OxidizableItemHelper.addOxidizableAttributesItem(class_1802.field_61340, class_1802.field_8403);
        OxidizableItemHelper.addOxidizableAttributesItem(class_1802.field_61341, class_1802.field_8475);
        OxidizableItemHelper.addOxidizableAttributesItem(class_1802.field_61342, class_1802.field_8609);
        OxidizableItemHelper.addOxidizableAttributesItem(class_1802.field_63386, class_1802.field_63387);
        OxidizableItemHelper.addOxidizableKineticWeaponItem(class_1802.field_63386, class_1802.field_63387);
    }

    public static void addOxidizableAttributesItem(@NotNull class_1792 copper, @NotNull class_1792 iron) {
        class_9323 copperComponents = copper.method_57347();
        class_9323 ironComponents = iron.method_57347();
        class_9285 copperAttributes = (class_9285)copperComponents.method_58694(class_9334.field_49636);
        class_9285 ironAttributes = (class_9285)ironComponents.method_58694(class_9334.field_49636);
        if (copperAttributes == null || ironAttributes == null) {
            return;
        }
        OXIDIZABLE_ATTRIBUTES.put(copper, (Pair<class_9285, class_9285>)Pair.of((Object)copperAttributes, (Object)ironAttributes));
    }

    public static void addOxidizableKineticWeaponItem(@NotNull class_1792 copper, @NotNull class_1792 iron) {
        class_9323 copperComponents = copper.method_57347();
        class_9323 ironComponents = iron.method_57347();
        class_12123 copperWeapon = (class_12123)copperComponents.method_58694(class_9334.field_63632);
        class_12123 ironWeapon = (class_12123)ironComponents.method_58694(class_9334.field_63632);
        if (copperWeapon == null || ironWeapon == null) {
            return;
        }
        OXIDIZABLE_KINETIC_WEAPONS.put(copper, (Pair<class_12123, class_12123>)Pair.of((Object)copperWeapon, (Object)ironWeapon));
    }

    public static float getOxidizeProgress(@NotNull class_1799 stack) {
        return OxidizableItemHelper.getOxidizeProgress(stack, OptionalInt.empty());
    }

    public static float getOxidizeProgress(@NotNull class_1799 stack, @NotNull OptionalInt optionalInt) {
        float maxDamage;
        if (!TCAConfig.OXIDIZABLE_COPPER_EQUIPMENT) {
            return 0.0f;
        }
        float damage = optionalInt.orElse(stack.method_7919());
        float damageProgress = class_3532.method_15363((float)(damage / (maxDamage = (float)stack.method_7936())), (float)0.0f, (float)1.0f);
        if (damageProgress >= 0.85f) {
            return 1.0f;
        }
        if (damageProgress >= 0.65f) {
            return 0.65f;
        }
        if (damageProgress >= 0.45f) {
            return 0.35f;
        }
        return 0.0f;
    }

    public static <T> T getValueForOxidization(class_1799 stack, T unaffected, T exposed, T weathered, T oxidized) {
        float oxidizeProgress = OxidizableItemHelper.getOxidizeProgress(stack);
        if (oxidizeProgress == 0.35f) {
            return exposed;
        }
        if (oxidizeProgress == 0.65f) {
            return weathered;
        }
        if (oxidizeProgress == 1.0f) {
            return oxidized;
        }
        return unaffected;
    }

    public static void onDamageUpdated(@NotNull class_1799 stack, int damageValue) {
        class_1792 item = stack.method_7909();
        OxidizableItemHelper.updateMiningSpeed(stack, item, damageValue);
        OxidizableItemHelper.updateAttributes(stack, item, damageValue);
        OxidizableItemHelper.updateKineticWeapon(stack, item, damageValue);
    }

    private static void updateMiningSpeed(class_1799 stack, class_1792 item, int damageValue) {
        if (!OXIDIZABLE_ATTRIBUTES.containsKey(item) || stack.method_31573(class_3489.field_42611)) {
            return;
        }
        class_9424 stackTool = (class_9424)stack.method_58694(class_9334.field_50077);
        if (stackTool == null) {
            return;
        }
        float oxidizeProgress = OxidizableItemHelper.getOxidizeProgress(stack, OptionalInt.of(damageValue));
        float newSpeed = class_3532.method_16439((float)oxidizeProgress, (float)COPPER_MINING_SPEED, (float)IRON_MINING_SPEED);
        boolean isEqual = true;
        ArrayList<class_9424.class_9425> ruleList = new ArrayList<class_9424.class_9425>();
        for (class_9424.class_9425 rule : stackTool.comp_2498()) {
            float ruleSpeed;
            if (rule.comp_2502().isPresent() && (ruleSpeed = ((Float)rule.comp_2502().get()).floatValue()) >= COPPER_MINING_SPEED && ruleSpeed <= IRON_MINING_SPEED) {
                if (ruleSpeed != newSpeed) {
                    isEqual = false;
                }
                ruleList.add(new class_9424.class_9425(rule.comp_2501(), Optional.of(Float.valueOf(newSpeed)), rule.comp_2503()));
                continue;
            }
            ruleList.add(rule);
        }
        if (isEqual) {
            return;
        }
        TCAConstants.log("Copper Item Mining Speed Updated!", TCAConstants.UNSTABLE_LOGGING);
        class_9424 finalTool = new class_9424(List.copyOf(ruleList), stackTool.comp_2499(), stackTool.comp_2500(), stackTool.comp_3480());
        stack.method_57379(class_9334.field_50077, (Object)finalTool);
    }

    private static void updateAttributes(class_1799 stack, class_1792 item, int damageValue) {
        Pair<class_9285, class_9285> attributePair = OXIDIZABLE_ATTRIBUTES.get(item);
        if (attributePair == null) {
            return;
        }
        class_9285 stackAttributes = (class_9285)stack.method_58694(class_9334.field_49636);
        if (stackAttributes == null) {
            return;
        }
        class_9285 copperAttributes = (class_9285)attributePair.getFirst();
        class_9285 ironAttributes = (class_9285)attributePair.getSecond();
        float oxidizeProgress = OxidizableItemHelper.getOxidizeProgress(stack, OptionalInt.of(damageValue));
        AtomicBoolean isEqual = new AtomicBoolean(true);
        ArrayList<class_9285.class_9287> entryList = new ArrayList<class_9285.class_9287>();
        for (class_9285.class_9287 entry : stackAttributes.comp_2393()) {
            if (entry.comp_2395() == class_5134.field_23721 && entry.comp_2396().method_60718(class_1792.field_8006)) {
                Optional<class_9285.class_9287> lerpedAttackDamage = OxidizableItemHelper.getLerpedAttributeEntry(copperAttributes, ironAttributes, (class_6880<class_1320>)class_5134.field_23721, class_1792.field_8006, oxidizeProgress);
                lerpedAttackDamage.ifPresentOrElse(attackDamageEntry -> {
                    if (!attackDamageEntry.equals((Object)entry)) {
                        isEqual.set(false);
                    }
                    entryList.add((class_9285.class_9287)attackDamageEntry);
                }, () -> entryList.add(entry));
                continue;
            }
            if (entry.comp_2395() == class_5134.field_23723 && entry.comp_2396().method_60718(class_1792.field_8001) && !stack.method_31573(TCAItemTags.OXIDIZING_DOES_NOT_SCALE_ATTACK_SPEED)) {
                Optional<class_9285.class_9287> lerpedAttackSpeed = OxidizableItemHelper.getLerpedAttributeEntry(copperAttributes, ironAttributes, (class_6880<class_1320>)class_5134.field_23723, class_1792.field_8001, oxidizeProgress);
                lerpedAttackSpeed.ifPresentOrElse(attackSpeedEntry -> {
                    if (!attackSpeedEntry.equals((Object)entry)) {
                        isEqual.set(false);
                    }
                    entryList.add((class_9285.class_9287)attackSpeedEntry);
                }, () -> entryList.add(entry));
                continue;
            }
            entryList.add(entry);
        }
        if (isEqual.get()) {
            return;
        }
        TCAConstants.log("Copper Item Attributes Updated!", TCAConstants.UNSTABLE_LOGGING);
        class_9285 finalAttributeModifiers = new class_9285((List)ImmutableList.copyOf(entryList));
        stack.method_57379(class_9334.field_49636, (Object)finalAttributeModifiers);
    }

    private static Optional<class_9285.class_9287> getLerpedAttributeEntry(@NotNull class_9285 copper, @NotNull class_9285 iron, class_6880<class_1320> attribute, class_2960 attributeID, float oxidizeProgress) {
        Predicate<class_9285.class_9287> matchingEntry = entry -> entry.method_60767(attribute, attributeID);
        Optional<class_9285.class_9287> optionalCopper = copper.comp_2393().stream().filter(matchingEntry).findFirst();
        Optional<class_9285.class_9287> optionalIron = iron.comp_2393().stream().filter(matchingEntry).findFirst();
        if (optionalCopper.isEmpty() || optionalIron.isEmpty()) {
            return Optional.empty();
        }
        class_9285.class_9287 copperEntry = optionalCopper.get();
        double amount = class_3532.method_16436((double)oxidizeProgress, (double)copperEntry.comp_2396().comp_2449(), (double)optionalIron.get().comp_2396().comp_2449());
        return Optional.of(new class_9285.class_9287(attribute, new class_1322(attributeID, amount, class_1322.class_1323.field_6328), copperEntry.comp_2397(), copperEntry.comp_4036()));
    }

    private static void updateKineticWeapon(class_1799 stack, class_1792 item, int damageValue) {
        Optional<class_12123.class_12124> newDamageConditions;
        Optional<class_12123.class_12124> newKnockbackConditions;
        Optional<class_12123.class_12124> newDismountCondition;
        float newDamageMultiplier;
        Pair<class_12123, class_12123> kineticWeaponPair = OXIDIZABLE_KINETIC_WEAPONS.get(item);
        if (kineticWeaponPair == null) {
            return;
        }
        class_12123 stackKineticWeapon = (class_12123)stack.method_58694(class_9334.field_63632);
        if (stackKineticWeapon == null) {
            return;
        }
        class_12123 copperKineticWeapon = (class_12123)kineticWeaponPair.getFirst();
        class_12123 ironKineticWeapon = (class_12123)kineticWeaponPair.getSecond();
        float oxidizeProgress = OxidizableItemHelper.getOxidizeProgress(stack, OptionalInt.of(damageValue));
        boolean isEqual = true;
        float stackDamageMultiplier = stackKineticWeapon.comp_4962();
        if (stackDamageMultiplier != (newDamageMultiplier = class_3532.method_16439((float)oxidizeProgress, (float)copperKineticWeapon.comp_4962(), (float)ironKineticWeapon.comp_4962()))) {
            isEqual = false;
        }
        if ((newDismountCondition = OxidizableItemHelper.getLerpedCondition(stackKineticWeapon.comp_4958(), copperKineticWeapon.comp_4958(), ironKineticWeapon.comp_4958(), oxidizeProgress)).isPresent()) {
            isEqual = false;
        }
        if ((newKnockbackConditions = OxidizableItemHelper.getLerpedCondition(stackKineticWeapon.comp_4959(), copperKineticWeapon.comp_4959(), ironKineticWeapon.comp_4959(), oxidizeProgress)).isPresent()) {
            isEqual = false;
        }
        if ((newDamageConditions = OxidizableItemHelper.getLerpedCondition(stackKineticWeapon.comp_4960(), copperKineticWeapon.comp_4960(), ironKineticWeapon.comp_4960(), oxidizeProgress)).isPresent()) {
            isEqual = false;
        }
        if (isEqual) {
            return;
        }
        class_12123 finalKineticWeapon = new class_12123(copperKineticWeapon.comp_4954(), copperKineticWeapon.comp_4955(), copperKineticWeapon.comp_4956(), copperKineticWeapon.comp_5145(), copperKineticWeapon.comp_4957(), Optional.ofNullable(newDismountCondition.orElse(stackKineticWeapon.comp_4958().orElse(null))), Optional.ofNullable(newKnockbackConditions.orElse(stackKineticWeapon.comp_4959().orElse(null))), Optional.ofNullable(newDamageConditions.orElse(stackKineticWeapon.comp_4960().orElse(null))), copperKineticWeapon.comp_4961(), newDamageMultiplier, copperKineticWeapon.comp_4963(), copperKineticWeapon.comp_4964());
        TCAConstants.log("Copper Kinetic Weapon Updated!", TCAConstants.UNSTABLE_LOGGING);
        stack.method_57379(class_9334.field_63632, (Object)finalKineticWeapon);
    }

    private static Optional<class_12123.class_12124> getLerpedCondition(@NotNull Optional<class_12123.class_12124> stackConditionOptional, Optional<class_12123.class_12124> copperConditionOptional, Optional<class_12123.class_12124> ironConditionOptional, float oxidizeProgress) {
        if (stackConditionOptional.isPresent() && copperConditionOptional.isPresent() && ironConditionOptional.isPresent()) {
            class_12123.class_12124 stackCondition = stackConditionOptional.get();
            class_12123.class_12124 copperCondition = copperConditionOptional.get();
            class_12123.class_12124 ironCondition = ironConditionOptional.get();
            float newMinSpeed = class_3532.method_16439((float)oxidizeProgress, (float)copperCondition.comp_4966(), (float)ironCondition.comp_4966());
            float newMinRelativeSpeed = class_3532.method_16439((float)oxidizeProgress, (float)copperCondition.comp_4967(), (float)ironCondition.comp_4967());
            if (newMinSpeed == stackCondition.comp_4966() && newMinRelativeSpeed == stackCondition.comp_4967()) {
                return Optional.empty();
            }
            return Optional.of(new class_12123.class_12124(stackCondition.comp_4965(), newMinSpeed, newMinRelativeSpeed));
        }
        return Optional.empty();
    }
}

