/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.thecopperierage.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.thecopperierage.networking.packet.TCAChimeInfluencePacket;
import net.frozenblock.thecopperierage.registry.TCABlockEntityTypes;
import net.frozenblock.thecopperierage.registry.TCASounds;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_8514;
import org.jetbrains.annotations.NotNull;

public class ChimeBlockEntity
extends class_2586 {
    private static final float MAX_BLOCKS_PER_SECOND = 22.0f;
    private static final float MAX_BLOCKS_PER_SECOND_IN_TICKS = 1.1f;
    private static final float BLOCKS_PER_SECOND_TO_VIBRATION = 1.4666667f;
    private final List<AbstractInfluence> influences;
    public final float animationOffset;
    protected class_243 prevInfluence = class_243.field_1353;
    protected class_243 influence = class_243.field_1353;
    public int age;
    public float prevAccumulatedStrength;
    public float accumulatedStrength;

    public ChimeBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        super(TCABlockEntityTypes.CHIME, pos, state);
        this.animationOffset = (float)pos.method_10263() * 6.0f + (float)pos.method_10264() * 6.0f + (float)pos.method_10260() * 6.0f;
        this.influences = new ArrayList<AbstractInfluence>();
        this.influences.add(new WindInfluence());
    }

    public static void tick(class_1937 level, class_2338 pos, @NotNull class_2680 state, @NotNull ChimeBlockEntity chime) {
        chime.prevInfluence = chime.influence;
        chime.influences.forEach(influence -> influence.tick(level, pos));
        chime.influences.removeIf(AbstractInfluence::shouldRemove);
        chime.influence = chime.getAverageInfluence();
        chime.prevAccumulatedStrength = chime.accumulatedStrength;
        chime.accumulatedStrength += (float)chime.influence.method_1033() * 0.5f;
        ++chime.age;
    }

    public void addInfluence(@NotNull class_1937 level, class_2338 pos, class_2680 state, class_243 influence, double scalePerTick, boolean playsSound, boolean sendPacket) {
        this.influences.add(new VectorBasedInfluence(influence, scalePerTick));
        if (sendPacket && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            TCAChimeInfluencePacket.sendToAll(serverLevel, pos, influence, scalePerTick, null);
        }
        if (level.method_8608() || !playsSound) {
            return;
        }
        float influenceSpeed = Math.clamp((float)this.getAverageInfluence().method_1033(), 0.02f, 1.2f);
        float volume = class_3532.method_16439((float)influenceSpeed, (float)0.1f, (float)0.6f);
        float pitch = class_3532.method_16439((float)influenceSpeed, (float)0.75f, (float)1.2f);
        level.method_8396(null, pos, TCASounds.BLOCK_CHIME_DISTURB, class_3419.field_15245, volume, pitch);
        level.method_55764(this.getResonanceEventByFrequency((int)(Math.min(influenceSpeed, 1.0f) * 15.0f)), pos, class_5712.class_7397.method_43287((class_2680)state));
    }

    public boolean addEntityInfluence(@NotNull class_1937 level, class_2338 pos, class_2680 state, class_1297 entity, class_243 influence, double scalePerTick, boolean cancelIfSoundCannotPlay, boolean sendPacket) {
        List<AbstractInfluence> entityInfluences = this.influences.stream().filter(abstractInfluence -> {
            EntityInfluence entityInfluence;
            return abstractInfluence instanceof EntityInfluence && (entityInfluence = (EntityInfluence)abstractInfluence).isSoundBearing() && entityInfluence.getTicksSinceStart() <= 30;
        }).toList();
        boolean canPlaySound = entityInfluences.isEmpty();
        if (cancelIfSoundCannotPlay && !canPlaySound) {
            return false;
        }
        this.influences.add(new EntityInfluence(entity, influence, scalePerTick, canPlaySound));
        if (canPlaySound) {
            float influenceSpeed = Math.clamp((float)this.getAverageInfluence().method_1033(), 0.01f, 1.2f);
            float volume = class_3532.method_16439((float)influenceSpeed, (float)0.02f, (float)0.6f);
            float pitch = class_3532.method_16439((float)influenceSpeed, (float)0.75f, (float)1.2f);
            level.method_8396(entity, pos, TCASounds.BLOCK_CHIME_DISTURB, class_3419.field_15245, volume, pitch);
            float speedInBlocksPerSecond = Math.min(influenceSpeed, 1.1f) * 20.0f;
            float vibrationStrength = speedInBlocksPerSecond / 1.4666667f;
            level.method_55764(this.getResonanceEventByFrequency(vibrationStrength), pos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)state));
        }
        if (sendPacket && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            TCAChimeInfluencePacket.sendToAll(serverLevel, pos, influence, scalePerTick, entity);
        }
        return canPlaySound;
    }

    @NotNull
    private class_5321<class_5712> getResonanceEventByFrequency(float frequency) {
        return class_8514.method_51386((int)Math.clamp((long)((int)frequency), 1, 15));
    }

    public void addClientInfluence(@NotNull class_1937 level, class_243 influence, double scaleEachTick, Optional<Integer> entityID) {
        if (!level.method_8608()) {
            return;
        }
        class_1297 entity = entityID.map(arg_0 -> ((class_1937)level).method_8469(arg_0)).orElse(null);
        if (entity != null) {
            this.influences.add(new EntityInfluence(entity, influence, scaleEachTick, false));
        } else {
            this.influences.add(new VectorBasedInfluence(influence, scaleEachTick));
        }
    }

    public class_243 getAverageInfluence() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double sumOfWeights = 0.0;
        for (AbstractInfluence influence : this.influences) {
            class_243 movement = influence.getInfluence();
            double weight = movement.method_1033();
            sumOfWeights += weight;
            x += weight * movement.field_1352;
            y += weight * movement.field_1351;
            z += weight * movement.field_1350;
        }
        if (sumOfWeights <= 0.0) {
            return class_243.field_1353;
        }
        double finalX = x / sumOfWeights;
        double finalY = y / sumOfWeights;
        double finalZ = z / sumOfWeights;
        return new class_243(finalX, finalY, finalZ);
    }

    public class_243 getInfluence(float partialTick) {
        return class_3532.method_61342((double)partialTick, (class_243)this.prevInfluence, (class_243)this.influence);
    }

    public static class WindInfluence
    extends AbstractInfluence {
        private class_243 wind = class_243.field_1353;
        private boolean isFirstTick = true;

        @Override
        public void tick(class_1937 level, class_2338 pos) {
            class_243 targetWind = this.getWind(level, pos);
            this.wind = this.wind.method_1019(targetWind.method_1020(this.wind).method_1021(this.isFirstTick ? 0.9 : 0.025));
            this.isFirstTick = false;
        }

        @Override
        public boolean shouldRemove() {
            return false;
        }

        private class_243 getWind(@NotNull class_1937 level, class_2338 pos) {
            if (level.method_8608()) {
                return ClientWindManager.getWindMovement((class_1937)level, (class_243)pos.method_46558(), (double)1.0, (double)1.0, (double)2.0);
            }
            if (!(level instanceof class_3218)) {
                return class_243.field_1353;
            }
            class_3218 serverLevel = (class_3218)level;
            return WindManager.getOrCreateWindManager((class_3218)serverLevel).getWindMovement(pos.method_46558(), 1.0, 1.0, 2.0);
        }

        @Override
        public class_243 getInfluence() {
            return this.wind;
        }
    }

    public static class VectorBasedInfluence
    extends AbstractInfluence {
        private class_243 influence;
        private final double scalePerTick;

        public VectorBasedInfluence(class_243 influence, double scalePerTick) {
            this.influence = influence;
            this.scalePerTick = scalePerTick;
        }

        @Override
        public void tick(class_1937 level, class_2338 pos) {
            this.influence = this.influence.method_1021(this.scalePerTick);
            if (this.influence.method_1033() < 0.02) {
                this.influence = class_243.field_1353;
            }
        }

        @Override
        public boolean shouldRemove() {
            return this.influence.method_1033() <= 0.0;
        }

        @Override
        public class_243 getInfluence() {
            return this.influence;
        }
    }

    public static class EntityInfluence
    extends VectorBasedInfluence {
        private final class_1297 entity;
        private final boolean soundBearing;
        private int ticksSinceStart;

        public EntityInfluence(class_1297 entity, class_243 influence, double scalePerTick, boolean soundBearing) {
            super(influence, scalePerTick);
            this.entity = entity;
            this.soundBearing = soundBearing;
        }

        @Override
        public void tick(class_1937 level, class_2338 pos) {
            ++this.ticksSinceStart;
            super.tick(level, pos);
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        public boolean isSoundBearing() {
            return this.soundBearing;
        }

        public int getTicksSinceStart() {
            return this.ticksSinceStart;
        }
    }

    public static abstract class AbstractInfluence {
        public abstract class_243 getInfluence();

        public abstract void tick(class_1937 var1, class_2338 var2);

        public abstract boolean shouldRemove();
    }
}

