/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.thecopperierage.block.gearbox;

import net.frozenblock.thecopperierage.block.GearboxBlock;
import net.frozenblock.thecopperierage.registry.TCASounds;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_9902;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;

public class GearboxBlockEvaluator {
    public void updatePowerStrength(class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        int newPower = this.calculateTargetStrength(level, pos, state);
        int oldPower = (Integer)state.method_11654((class_2769)GearboxBlock.POWER);
        if (oldPower != newPower) {
            if (level.method_8320(pos) == state) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)GearboxBlock.POWER, (Comparable)Integer.valueOf(newPower)), 2);
                if (oldPower == 0 && newPower % 2 != 0) {
                    level.method_8396(null, pos, TCASounds.BLOCK_GEARBOX_ON, class_3419.field_15245, 0.45f, 0.15f + (float)newPower / 25.0f + level.method_8409().method_43057() * 0.1f);
                } else if (newPower == 0) {
                    level.method_8396(null, pos, TCASounds.BLOCK_GEARBOX_OFF, class_3419.field_15245, 0.25f, 0.5f + level.method_8409().method_43057() * 0.2f);
                }
            }
            this.updateNeighboringBlocks(level, pos, state);
        }
    }

    public void updateNeighboringBlocks(class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)GearboxBlock.field_10927);
        class_2350 behind = facing.method_10153();
        class_9904 orientation = class_9902.method_61826((class_1937)level, (class_2350)behind, null);
        level.method_8508(pos.method_10093(behind), state.method_26204(), facing, orientation);
        level.method_8508(pos, state.method_26204(), facing, orientation);
    }

    protected boolean hasBlockSignal(class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof GearboxBlock)) {
            return false;
        }
        GearboxBlock gearboxBlock = (GearboxBlock)class_22482;
        return gearboxBlock.hasBlockSignal(level, pos, state);
    }

    protected int getGearboxPower(class_2338 pos, @NotNull class_2680 state, class_2350 facing) {
        if (!(state.method_26204() instanceof GearboxBlock)) {
            return 0;
        }
        return state.method_11654((class_2769)GearboxBlock.field_10927) == facing ? (Integer)state.method_11654((class_2769)GearboxBlock.POWER) : 0;
    }

    protected int getIncomingGearboxPower(class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof GearboxBlock)) {
            return 0;
        }
        GearboxBlock gearboxBlock = (GearboxBlock)class_22482;
        int power = 0;
        class_2350 facing = (class_2350)state.method_11654((class_2769)GearboxBlock.field_10927);
        for (class_2350 direction : gearboxBlock.getInputDirections(facing)) {
            class_2338 offsetPos = pos.method_10093(direction);
            class_2680 offsetState = level.method_8320(offsetPos);
            power = Math.max(power, this.getGearboxPower(offsetPos, offsetState, facing));
        }
        return Math.max(0, power - 1);
    }

    private int calculateTargetStrength(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.hasBlockSignal(level, pos, state)) {
            return 15;
        }
        return this.getIncomingGearboxPower(level, pos, state);
    }
}

