/*
 * Decompiled with CFR 0.152.
 */
package subtick;

import carpet.utils.Messenger;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.class_1919;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Triple;
import subtick.IQueues;
import subtick.TickHandler;
import subtick.TickPhase;
import subtick.network.ServerNetworkHandler;
import subtick.queues.BlockEventQueue;
import subtick.queues.TickingQueue;
import subtick.util.Translations;

public class Queues
implements IQueues {
    public static final DynamicCommandExceptionType INVALID_QUEUE_EXCEPTION = new DynamicCommandExceptionType(key -> new LiteralMessage("Invalid queue '" + String.valueOf(key) + "'"));
    private final TickHandler tickHandler;
    private TickingQueue queue;
    private TickingQueue prev_queue;
    private int count;
    private class_2338 pos;
    private int range;
    private class_2168 actor;
    private class_3218 level;
    public boolean scheduled;
    private boolean stepping;
    private boolean should_end;

    public Queues(TickHandler tickHandler) {
        this.tickHandler = tickHandler;
    }

    public void printDebugInfo(class_2168 c) {
        Messenger.m((class_2168)c, (Object[])new Object[]{"w queue: " + String.valueOf(this.queue)});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w prev_queue: " + String.valueOf(this.prev_queue)});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w count: " + this.count});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w pos: " + String.valueOf(this.pos)});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w range: " + this.range});
    }

    private void step(TickingQueue newQueue, class_2168 c, int newCount, class_2338 newPos, int newRange) throws CommandSyntaxException {
        this.queue = newQueue;
        this.actor = c;
        this.count = newCount;
        this.pos = newPos;
        this.range = newRange;
        this.scheduled = true;
    }

    @Override
    public void schedule(class_2168 c, TickingQueue newQueue, String modeKey, int count, class_2338 pos, int range, boolean force) throws CommandSyntaxException {
        this.level = c.method_9225();
        newQueue.setMode(modeKey);
        TickPhase phase = new TickPhase(this.level, newQueue.getPhase());
        if (force ? this.tickHandler.canStep(0, phase) : this.tickHandler.canStep(c, 0, phase)) {
            this.step(newQueue, c, count, pos, range);
            this.tickHandler.step(c, 0, phase);
        } else if (force && this.tickHandler.canStep(c, 1, phase)) {
            this.step(newQueue, c, count, pos, range);
            this.tickHandler.step(c, 1, phase);
        }
    }

    @Override
    public void scheduleEnd() {
        this.should_end = true;
    }

    @Override
    public void execute() {
        if (!this.scheduled) {
            return;
        }
        if (!this.stepping) {
            this.queue.start(this.level);
            this.stepping = true;
        }
        try {
            Triple<Integer, Integer, Boolean> triple = this.queue.step(this.count, this.pos, this.range);
            this.queue.sendQueueStep(this.actor, (Integer)triple.getLeft());
            this.sendFeedback((Integer)triple.getMiddle(), (Boolean)triple.getRight());
        }
        catch (Exception e) {
            Translations.m(this.actor, "queueCommand.err.crash", this.queue);
        }
        this.prev_queue = this.queue;
        this.scheduled = false;
    }

    @Override
    public void end() {
        if (!this.should_end) {
            return;
        }
        this.should_end = false;
        if (!this.stepping) {
            return;
        }
        this.prev_queue.step(1, class_2338.field_10980, -2);
        this.prev_queue.end();
        this.prev_queue.exhausted = false;
        this.tickHandler.advancePhase(this.level);
        ServerNetworkHandler.sendTickStep(this.level, 0, this.tickHandler.targetPhase());
        this.stepping = false;
    }

    @Override
    public void onScheduleBlockEvent(class_3218 level, class_1919 be) {
        TickingQueue tickingQueue;
        if (this.stepping && (tickingQueue = this.queue) instanceof BlockEventQueue) {
            BlockEventQueue beq = (BlockEventQueue)tickingQueue;
            beq.updateQueue(level, be);
        }
    }

    private void sendFeedback(int steps, boolean exhausted) {
        if (steps == 0) {
            Translations.m(this.actor, "queueCommand.err.exhausted", this.queue);
        } else if (steps == 1) {
            if (exhausted) {
                Translations.m(this.actor, "queueCommand.success.single.exhausted", this.queue, steps);
            } else {
                Translations.m(this.actor, "queueCommand.success.single", this.queue, steps);
            }
        } else if (exhausted) {
            Translations.m(this.actor, "queueCommand.success.multiple.exhausted", this.queue, steps);
        } else {
            Translations.m(this.actor, "queueCommand.success.multiple", this.queue, steps);
        }
    }
}

