/*
 * Decompiled with CFR 0.152.
 */
package subtick;

import carpet.utils.Messenger;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import subtick.ITickHandler;
import subtick.Queues;
import subtick.TickPhase;
import subtick.network.ServerNetworkHandler;
import subtick.util.Translations;

public class TickHandler
implements ITickHandler {
    private final Queues queues = new Queues(this);
    private State state = State.UNFROZEN;
    private class_2168 actor;
    private int remainingTicks;
    private TickPhase targetPhase = new TickPhase(0, 0);
    private TickPhase currentPhase = new TickPhase(0, 0);

    @Override
    public boolean frozen() {
        return this.state == State.FROZEN;
    }

    @Override
    public TickPhase currentPhase() {
        return this.currentPhase;
    }

    @Override
    public TickPhase targetPhase() {
        return this.targetPhase;
    }

    @Override
    public Queues queues() {
        return this.queues;
    }

    public int printDebugInfo(class_2168 c) {
        Messenger.m((class_2168)c, (Object[])new Object[]{"w remainingTicks: " + this.remainingTicks});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w targetPhase: " + String.valueOf(this.targetPhase)});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w currentPhase: " + String.valueOf(this.currentPhase)});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w state: " + this.state.name()});
        Messenger.m((class_2168)c, (Object[])new Object[]{"w Queue:"});
        this.queues.printDebugInfo(c);
        return 1;
    }

    public void reset() {
        this.actor = null;
        this.remainingTicks = 0;
        this.targetPhase = new TickPhase(0, 0);
        this.currentPhase = new TickPhase(0, 0);
        this.state = State.UNFROZEN;
    }

    @Override
    public int when(class_2168 c) {
        Translations.m(c, switch (this.state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "tickCommand.when.frozen";
            case 0 -> "tickCommand.when.unfrozen";
            case 3 -> "tickCommand.when.freezing";
            case 2 -> "tickCommand.when.unfreezing";
            case 4 -> "tickCommand.when.stepping";
        }, this.currentPhase);
        return 1;
    }

    @Override
    public boolean shouldTick(class_3218 level, int tickPhase) {
        TickPhase phase = new TickPhase(level, tickPhase);
        return switch (this.state.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                this.currentPhase = phase;
                yield true;
            }
            case 3 -> {
                if (!phase.equals(this.targetPhase)) {
                    yield true;
                }
                this.state = State.FROZEN;
                this.currentPhase = phase;
                yield false;
            }
            case 1 -> {
                this.queues.end();
                yield false;
            }
            case 2 -> {
                this.queues.end();
                if (!phase.equals(this.currentPhase)) {
                    yield false;
                }
                this.state = State.UNFROZEN;
                yield true;
            }
            case 4 -> {
                this.queues.end();
                if (!phase.equals(this.currentPhase)) {
                    yield false;
                }
                if (this.remainingTicks == 0 && phase.dim() == this.targetPhase.dim()) {
                    if (phase.phase() == this.targetPhase.phase()) {
                        this.state = State.FROZEN;
                        this.queues.execute();
                        yield false;
                    }
                    if (phase.phase() > this.targetPhase.phase()) {
                        this.currentPhase = new TickPhase(phase.dim(), TickPhase.ENTITY);
                        Translations.m(this.actor, "tickCommand.step.err.unloaded", phase);
                        yield false;
                    }
                }
                if (phase.isLast()) {
                    --this.remainingTicks;
                }
                this.advancePhase(level);
                yield true;
            }
        };
    }

    public void advancePhase(class_3218 level) {
        this.currentPhase = this.currentPhase.next(level);
    }

    @Override
    public int freeze(class_2168 c, int phase) {
        TickPhase tickPhase;
        if (this.state != State.UNFROZEN) {
            Translations.m(c, "tickCommand.freeze.err");
            return 0;
        }
        this.state = State.FREEZING;
        this.targetPhase = tickPhase = new TickPhase(c.method_9225(), phase);
        ServerNetworkHandler.sendFrozen(c.method_9225(), tickPhase);
        Translations.m(c, "tickCommand.freeze.success", tickPhase);
        return 1;
    }

    @Override
    public int unfreeze(class_2168 c) {
        switch (this.state.ordinal()) {
            case 1: {
                this.state = State.UNFREEZING;
                this.queues.scheduleEnd();
                ServerNetworkHandler.sendUnfrozen(c.method_9225());
                Translations.m(c, "tickCommand.unfreeze.success");
                return 1;
            }
            case 3: {
                this.state = State.UNFROZEN;
                ServerNetworkHandler.sendUnfrozen(c.method_9225());
                Translations.m(c, "tickCommand.unfreeze.success");
                return 1;
            }
            case 4: {
                this.state = State.UNFREEZING;
                ServerNetworkHandler.sendUnfrozen(c.method_9225());
                Translations.m(c, "tickCommand.unfreeze.success");
                return 1;
            }
        }
        Translations.m(c, "tickCommand.unfreeze.err");
        return 0;
    }

    @Override
    public int toggleFreeze(class_2168 c, int phase) {
        switch (this.state.ordinal()) {
            case 0: {
                TickPhase tickPhase;
                this.state = State.FREEZING;
                this.targetPhase = tickPhase = new TickPhase(c.method_9225(), phase);
                ServerNetworkHandler.sendFrozen(c.method_9225(), tickPhase);
                Translations.m(c, "tickCommand.freeze.success", tickPhase);
                return 1;
            }
            case 2: {
                Translations.m(c, "tickCommand.freeze.err.unfreezing");
                return 0;
            }
            case 1: {
                this.state = State.UNFREEZING;
                this.queues.scheduleEnd();
                ServerNetworkHandler.sendUnfrozen(c.method_9225());
                Translations.m(c, "tickCommand.unfreeze.success");
                return 1;
            }
            case 3: {
                this.state = State.UNFROZEN;
                ServerNetworkHandler.sendUnfrozen(c.method_9225());
                Translations.m(c, "tickCommand.unfreeze.success");
                return 1;
            }
            case 4: {
                this.state = State.UNFREEZING;
                ServerNetworkHandler.sendUnfrozen(c.method_9225());
                Translations.m(c, "tickCommand.unfreeze.success");
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int step(class_2168 c, int ticks, int phase) {
        TickPhase tickPhase = new TickPhase(c.method_9225(), phase);
        if (!this.canStep(c, ticks, tickPhase)) {
            return 0;
        }
        if (ticks == 1) {
            Translations.m(c, "tickCommand.step.success.single", tickPhase, 1);
        } else {
            Translations.m(c, "tickCommand.step.success.multiple", tickPhase, ticks);
        }
        this.actor = c;
        this.state = State.STEPPING;
        this.remainingTicks = ticks;
        this.targetPhase = tickPhase;
        if (ticks != 0 || !tickPhase.equals(this.currentPhase)) {
            this.queues.scheduleEnd();
            ServerNetworkHandler.sendTickStep(c.method_9225(), ticks, tickPhase);
        }
        return 1;
    }

    @Override
    public int phaseStep(class_2168 c, int count) {
        int currentPhaseInt = this.currentPhase.phase();
        int phase = currentPhaseInt + count;
        int ticks = phase / 11;
        return this.step(c, phase < currentPhaseInt ? ticks + 1 : ticks, phase % 11);
    }

    @Override
    public int stepToPhase(class_2168 c, int phase, boolean force) {
        return phase < this.currentPhase.phase() && force ? this.step(c, 1, phase) : this.step(c, 0, phase);
    }

    public int step(class_2168 c, int ticks, TickPhase phase) {
        this.state = State.STEPPING;
        this.remainingTicks = ticks;
        this.targetPhase = phase;
        if (ticks != 0 || !phase.equals(this.currentPhase)) {
            this.queues.scheduleEnd();
            ServerNetworkHandler.sendTickStep(c.method_9225(), ticks, phase);
        }
        return 1;
    }

    @Override
    public boolean canStep(class_2168 c, int count, TickPhase phase) {
        if (this.state == State.STEPPING) {
            Translations.m(c, "tickCommand.step.err.stepping");
            return false;
        }
        if (this.state != State.FROZEN) {
            Translations.m(c, "tickCommand.step.err.notfrozen");
            return false;
        }
        if (count == 0 && phase.isPriorTo(this.currentPhase)) {
            Translations.m(c, "tickCommand.step.err.backwards");
            return false;
        }
        if (this.queues.scheduled) {
            Translations.m(c, "tickCommand.step.err.qstepping");
            return false;
        }
        return true;
    }

    @Override
    public boolean canStep(int count, TickPhase phase) {
        if (this.state != State.FROZEN) {
            return false;
        }
        if (count == 0 && phase.isPriorTo(this.currentPhase)) {
            return false;
        }
        return !this.queues.scheduled;
    }

    private static enum State {
        UNFROZEN,
        FROZEN,
        UNFREEZING,
        FREEZING,
        STEPPING;

    }
}

