/*
 * Decompiled with CFR 0.152.
 */
package subtick;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import subtick.util.Translations;

public record TickPhase(int dim, int phase) {
    public static final DynamicCommandExceptionType INVALID_TICK_PHASE_EXCEPTION = new DynamicCommandExceptionType(key -> new LiteralMessage("Invalid tick phase '" + String.valueOf(key) + "'"));
    public static TickPhase INVALID = new TickPhase(-1, -1);
    private static final List<String> dims = new ArrayList<String>();
    private static final List<String> commandKeys = List.of("worldBorder", "weather", "time", "blockTick", "fluidTick", "raid", "chunk", "blockEvent", "entity", "blockEntity", "entityManagement");
    public static final String[] commandSuggestions = commandKeys.toArray(new String[0]);
    public static final int WORLD_BORDER = commandKeys.indexOf("worldBorder");
    public static final int WEATHER = commandKeys.indexOf("weather");
    public static final int TIME = commandKeys.indexOf("time");
    public static final int BLOCK_TICK = commandKeys.indexOf("blockTick");
    public static final int FLUID_TICK = commandKeys.indexOf("fluidTick");
    public static final int RAID = commandKeys.indexOf("raid");
    public static final int CHUNK = commandKeys.indexOf("chunk");
    public static final int BLOCK_EVENT = commandKeys.indexOf("blockEvent");
    public static final int ENTITY = commandKeys.indexOf("entity");
    public static final int BLOCK_ENTITY = commandKeys.indexOf("blockEntity");
    public static final int ENTITY_MANAGEMENT = commandKeys.indexOf("entityManagement");
    private static final int lastPhase = 10;
    public static final int totalPhases = 11;

    public TickPhase(class_3218 level, int phase) {
        this(dims.indexOf(level.method_27983().method_29177().method_12832()), phase);
    }

    public TickPhase(class_2487 tag) {
        this(tag.method_10550("dim"), tag.method_10550("phase"));
    }

    public static void reset() {
        dims.clear();
    }

    public static List<String> getDimensions() {
        return dims;
    }

    public TickPhase next(class_3218 level) {
        if (this.phase == 10) {
            return new TickPhase(this.dim + 1 == dims.size() ? 0 : this.dim + 1, 0);
        }
        if (this.phase == BLOCK_EVENT && this.dimensionUnloaded(level)) {
            return new TickPhase(this.dim, this.phase + 3);
        }
        return new TickPhase(this.dim, this.phase == 10 ? 0 : this.phase + 1);
    }

    public TickPhase next(int i) {
        return new TickPhase(this.dim, (this.phase + i) % 11);
    }

    public boolean isLast() {
        return this.phase == 10 && this.dim == dims.size() - 1;
    }

    public boolean isPriorTo(TickPhase phase2) {
        return this.dim < phase2.dim || this.phase < phase2.phase;
    }

    public String getPath() {
        return dims.get(this.dim);
    }

    public String getPhaseName() {
        return Translations.tr("subtick.tickPhase." + commandKeys.get(this.phase));
    }

    public static String getPhaseName(int phase) {
        return Translations.tr("subtick.tickPhase." + commandKeys.get(phase));
    }

    public static int byCommandKey(String key) throws CommandSyntaxException {
        int phase = commandKeys.indexOf(key);
        if (phase == -1) {
            throw INVALID_TICK_PHASE_EXCEPTION.create((Object)key);
        }
        return phase;
    }

    public static void addDimension(class_3218 level) {
        dims.add(level.method_27983().method_29177().method_12832());
    }

    private boolean dimensionUnloaded(class_3218 level) {
        return level.method_18456().isEmpty() && level.method_17984().isEmpty() && level.field_13948 >= 300;
    }
}

