/*
 * Decompiled with CFR 0.152.
 */
package subtick.client;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.util.Color4f;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.apache.commons.lang3.tuple.Pair;
import subtick.QueueElement;
import subtick.TickPhase;
import subtick.client.ClientTickHandler;
import subtick.client.Configs;
import subtick.util.Translations;

public class HudRenderer {
    private static final class_310 mc = class_310.method_1551();
    private static final class_327 font = HudRenderer.mc.field_1772;
    private static Color4f STEPPED_BG;
    private static int STEPPED_TEXT;
    private static Color4f STEPPING_BG;
    private static int STEPPING_TEXT;
    private static Color4f TO_STEP_BG;
    private static int TO_STEP_TEXT;
    private static Color4f NEW_BG;
    private static int NEW_TEXT;

    private static Pair<Integer, Integer> trimQueue(int max, int maxHighlights) {
        List<QueueElement> queue = ClientTickHandler.queue;
        if (queue.size() <= max) {
            return Pair.of((Object)0, (Object)queue.size());
        }
        int size = ClientTickHandler.queueIndex2 - ClientTickHandler.queueIndex1 + 1;
        if (size > maxHighlights) {
            int start = Math.min(queue.size() - max, ClientTickHandler.queueIndex2 - maxHighlights);
            return Pair.of((Object)start, (Object)(start + max));
        }
        int start = Math.min(queue.size() - max, ClientTickHandler.queueIndex1);
        return Pair.of((Object)start, (Object)(start + max));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(class_4587 poseStack) {
        Class<ClientTickHandler> clazz = ClientTickHandler.class;
        synchronized (ClientTickHandler.class) {
            if (!ClientTickHandler.frozen || !Configs.SHOW_HUD.getBooleanValue()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            STEPPED_BG = Configs.STEPPED_BG.getColor();
            STEPPED_TEXT = Configs.STEPPED_TEXT.getColor().intValue;
            STEPPING_BG = Configs.STEPPING_BG.getColor();
            STEPPING_TEXT = Configs.STEPPING_TEXT.getColor().intValue;
            TO_STEP_BG = Configs.TO_STEP_BG.getColor();
            TO_STEP_TEXT = Configs.TO_STEP_TEXT.getColor().intValue;
            NEW_BG = Configs.NEW_BG.getColor();
            NEW_TEXT = Configs.NEW_TEXT.getColor().intValue;
            TickPhase tickPhase = ClientTickHandler.tickPhase;
            Align align = (Align)Configs.HUD_ALIGNMENT.getOptionListValue();
            int xOff = Configs.HUD_OFFSET_X.getIntegerValue();
            int yOff = Configs.HUD_OFFSET_Y.getIntegerValue();
            int wPhase = 0;
            int wDim = 0;
            for (int phase = 0; phase < 11; ++phase) {
                wPhase = Math.max(wPhase, font.method_1727(TickPhase.getPhaseName(phase)));
            }
            for (String dim : ClientTickHandler.dimensions) {
                wDim = Math.max(wDim, font.method_1727(dim));
            }
            int wDimPhase = (wDim += 2) + (wPhase += 2) + 10;
            Objects.requireNonNull(font);
            int h = 9 + 1;
            if (ClientTickHandler.queue.isEmpty()) {
                HudRenderer.renderHudA(poseStack, tickPhase, align.getX(wDimPhase + 10) + xOff, align.getY(h * 11) + yOff, wDim, wPhase, h);
            } else {
                boolean depth;
                class_2561[] queue = new class_2561[Math.min(ClientTickHandler.queue.size(), Configs.MAX_QUEUE_SIZE.getIntegerValue())];
                Pair<Integer, Integer> indices = HudRenderer.trimQueue(Configs.MAX_QUEUE_SIZE.getIntegerValue(), Configs.MAX_HIGHLIGHT_SIZE.getIntegerValue());
                int wQueue = 0;
                int i = (Integer)indices.getLeft();
                int j = 0;
                boolean bl = depth = tickPhase.phase() == TickPhase.BLOCK_TICK || tickPhase.phase() == TickPhase.BLOCK_EVENT;
                while (i < (Integer)indices.getRight()) {
                    QueueElement element = ClientTickHandler.queue.get(i++);
                    int n = j++;
                    class_2561 class_25612 = HudRenderer.text(element, i, depth);
                    queue[n] = class_25612;
                    class_2561 s = class_25612;
                    wQueue = Math.max(wQueue, font.method_27525((class_5348)s));
                }
                int wAll = wDimPhase + (wQueue += 2) + 10;
                HudRenderer.renderHudB(poseStack, queue, tickPhase, ClientTickHandler.queueIndex1 - (Integer)indices.getLeft(), ClientTickHandler.queueIndex2 - (Integer)indices.getLeft(), queue.length - ClientTickHandler.newQueueElementCount, align.getX(wAll + 10) + xOff, align.getY(h * Math.max(11, (Integer)indices.getRight() - (Integer)indices.getLeft())) + yOff, wDim, wPhase, wQueue, h);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String color(ConfigColor color) {
        return "#" + color.getStringValue().substring(3);
    }

    private static class_2561 text(QueueElement element, int i, boolean depth) {
        return depth ? class_2561.class_2562.method_10873((String)String.format("[\"#%d (\", {\"color\":\"%s\",\"text\":\"%d\"}, \"): %s\"]", i, HudRenderer.color(i <= ClientTickHandler.queueIndex1 ? Configs.STEPPED_DEPTH : (i <= ClientTickHandler.queueIndex2 ? Configs.STEPPING_DEPTH : (i >= ClientTickHandler.queue.size() - ClientTickHandler.newQueueElementCount ? Configs.NEW_DEPTH : Configs.TO_STEP_DEPTH))), element.depth(), element.label())) : class_2561.method_43470((String)String.format("#%d: %s", i, element.label()));
    }

    public static void renderHudA(class_4587 poseStack, TickPhase phase, int x, int y, int wDim, int wPhase, int h) {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        HudRenderer.drawTableB(buffer, x, y, h, wDim, ClientTickHandler.dimensions.size(), phase.dim());
        HudRenderer.drawTableA(buffer, x + wDim + 10, y, h, wPhase, 11, phase.phase());
        tesselator.method_1350();
        x += 2;
        int y1 = y + 2;
        int i = 0;
        while (i < ClientTickHandler.dimensions.size()) {
            font.method_1729(poseStack, ClientTickHandler.dimensions.get(i), (float)x, (float)y1, i < phase.dim() ? STEPPED_TEXT : TO_STEP_TEXT);
            ++i;
            y1 += h;
        }
        x += wDim + 10;
        y1 = y + 2;
        i = 0;
        while (i < 11) {
            font.method_1729(poseStack, TickPhase.getPhaseName(i), (float)x, (float)y1, i < phase.phase() ? STEPPED_TEXT : TO_STEP_TEXT);
            ++i;
            y1 += h;
        }
    }

    public static void renderHudB(class_4587 poseStack, class_2561[] queue, TickPhase phase, int iqueue1, int iqueue2, int iqueue3, int x, int y, int wDim, int wPhase, int wQueue, int h) {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        HudRenderer.drawTableB(buffer, x, y, h, wDim, ClientTickHandler.dimensions.size(), phase.dim());
        HudRenderer.drawTableB(buffer, x + wDim + 10, y, h, wPhase, 11, phase.phase());
        HudRenderer.drawTableC(buffer, x + wDim + wPhase + 20, y, h, wQueue, queue.length, iqueue1, iqueue2, iqueue3);
        int sx = x + wDim + 10 + wPhase + 1;
        int sy = y + phase.phase() * h + 1;
        HudRenderer.drawQuad(buffer, sx, sy, sx, sy + h - 1, sx + 9, y + queue.length * h, sx + 9, y, Configs.POSITION.getColor());
        tesselator.method_1350();
        x += 2;
        int y1 = y + 2;
        int i = 0;
        while (i < ClientTickHandler.dimensions.size()) {
            font.method_1729(poseStack, ClientTickHandler.dimensions.get(i), (float)x, (float)y1, i < phase.dim() ? STEPPED_TEXT : TO_STEP_TEXT);
            ++i;
            y1 += h;
        }
        x += wDim + 10;
        y1 = y + 2;
        i = 0;
        while (i < 11) {
            font.method_1729(poseStack, TickPhase.getPhaseName(i), (float)x, (float)y1, i < phase.phase() ? STEPPED_TEXT : TO_STEP_TEXT);
            ++i;
            y1 += h;
        }
        x += wPhase + 10;
        y1 = y + 2;
        i = 0;
        while (i < queue.length) {
            font.method_30883(poseStack, queue[i], (float)x, (float)y1, i < iqueue1 ? STEPPED_TEXT : (i < iqueue2 ? STEPPING_TEXT : (i >= iqueue3 ? NEW_TEXT : TO_STEP_TEXT)));
            ++i;
            y1 += h;
        }
    }

    private static void drawTableA(class_287 buffer, int x, int y, int h, int w, int count, int index) {
        int Y = y + count * h + 1;
        int X = x + w;
        HudRenderer.drawRect(buffer, x, y, x + 1, Y, Configs.SEPARATOR.getColor());
        HudRenderer.drawRect(buffer, X, y, X + 1, Y, Configs.SEPARATOR.getColor());
        ++x;
        --w;
        --h;
        for (int i = 0; i < count; ++i) {
            if (i == index) {
                HudRenderer.drawQuad(buffer, X, y, X, y + 1, X + 5, y + 3, X + 5, y - 3, Configs.POSITION.getColor());
                HudRenderer.drawRect(buffer, x, y++, X, y, Configs.POSITION.getColor());
            } else {
                HudRenderer.drawRect(buffer, x, y++, X, y, Configs.SEPARATOR.getColor());
            }
            HudRenderer.drawRect(buffer, x, y, X, y += h, i < index ? STEPPED_BG : TO_STEP_BG);
        }
        HudRenderer.drawRect(buffer, x, y, X, y + 1, Configs.SEPARATOR.getColor());
    }

    private static void drawTableB(class_287 buffer, int x, int y, int h, int w, int count, int index) {
        int Y = y + count * h + 1;
        int X = x + w;
        HudRenderer.drawRect(buffer, x, y, x + 1, Y, Configs.SEPARATOR.getColor());
        HudRenderer.drawRect(buffer, X, y, X + 1, Y, Configs.SEPARATOR.getColor());
        ++x;
        --w;
        --h;
        for (int i = 0; i < count; ++i) {
            HudRenderer.drawRect(buffer, x, y++, X, y, Configs.SEPARATOR.getColor());
            HudRenderer.drawRect(buffer, x, y, X, y += h, i < index ? STEPPED_BG : (i == index ? Configs.POSITION.getColor() : TO_STEP_BG));
        }
        HudRenderer.drawRect(buffer, x, y, X, y + 1, Configs.SEPARATOR.getColor());
    }

    private static void drawTableC(class_287 buffer, int x, int y, int h, int w, int count, int index1, int index2, int index3) {
        int Y = y + count * h + 1;
        int X = x + w;
        HudRenderer.drawRect(buffer, x, y, x + 1, Y, Configs.SEPARATOR.getColor());
        HudRenderer.drawRect(buffer, X, y, X + 1, Y, Configs.SEPARATOR.getColor());
        ++x;
        --w;
        --h;
        for (int i = 0; i < count; ++i) {
            if (i == index2) {
                HudRenderer.drawQuad(buffer, X, y, X, y + 1, X + 5, y + 3, X + 5, y - 3, Configs.POSITION.getColor());
                HudRenderer.drawRect(buffer, x, y++, X, y, Configs.POSITION.getColor());
                HudRenderer.drawRect(buffer, x, y, X, y += h, TO_STEP_BG);
                continue;
            }
            HudRenderer.drawRect(buffer, x, y++, X, y, Configs.SEPARATOR.getColor());
            HudRenderer.drawRect(buffer, x, y, X, y += h, i < index1 ? STEPPED_BG : (i < index2 ? STEPPING_BG : (i >= index3 ? NEW_BG : TO_STEP_BG)));
        }
        HudRenderer.drawRect(buffer, x, y, X, y + 1, Configs.SEPARATOR.getColor());
    }

    private static void drawRect(class_287 buffer, int x, int y, int X, int Y, Color4f color) {
        buffer.method_22912((double)x, (double)y, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912((double)x, (double)Y, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912((double)X, (double)Y, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912((double)X, (double)y, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    private static void drawQuad(class_287 buffer, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, Color4f color) {
        buffer.method_22912((double)x1, (double)y1, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912((double)x2, (double)y2, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912((double)x3, (double)y3, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912((double)x4, (double)y4, 0.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    public static enum Align implements IConfigOptionListEntry
    {
        TOP_LEFT(0, 0, "top_left"),
        TOP(1, 0, "top"),
        TOP_RIGHT(2, 0, "top_right"),
        LEFT(0, 1, "left"),
        CENTER(1, 1, "center"),
        RIGHT(2, 1, "right"),
        BOTTOM_LEFT(0, 2, "bottom_left"),
        BOTTOM(1, 2, "bottom"),
        BOTTOM_RIGHT(2, 2, "bottom_right");

        private final int x;
        private final int y;
        private final String translationKey;
        private static final Map<String, Align> byString;

        private Align(int x, int y, String key) {
            this.x = x;
            this.y = y;
            this.translationKey = key;
        }

        public int getX(int w) {
            return this.x * ((mc.method_22683().method_4486() - w) / 2);
        }

        public int getY(int h) {
            return this.y * ((mc.method_22683().method_4502() - h) / 2);
        }

        public String getDisplayName() {
            return Translations.tr("subtick.client.align." + this.translationKey);
        }

        public String getStringValue() {
            return this.translationKey;
        }

        public Align fromString(String name) {
            return byString.get(name);
        }

        public Align cycle(boolean forwards) {
            int id = this.ordinal();
            if (forwards) {
                return Align.values()[++id == Align.values().length ? 0 : id];
            }
            return Align.values()[--id == -1 ? Align.values().length - 1 : id];
        }

        static {
            byString = Map.of("top_left", TOP_LEFT, "top", TOP, "top_right", TOP_RIGHT, "left", LEFT, "center", CENTER, "right", RIGHT, "bottom_left", BOTTOM_LEFT, "bottom", BOTTOM, "bottom_right", BOTTOM_RIGHT);
        }
    }
}

