/*
 * Decompiled with CFR 0.152.
 */
package subtick.client;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.util.Color4f;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Quaternionf;

public class LevelRenderer {
    private static final class_310 mc = class_310.method_1551();
    private static final class_327 font = LevelRenderer.mc.field_1772;
    private static final HashSet<Line> lines = new HashSet();
    private static final HashSet<Quad> quads = new HashSet();
    private static final HashSet<Text> texts = new HashSet();

    public static synchronized void render(class_4587 poseStack) {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        class_4184 camera = LevelRenderer.mc.field_1773.method_19418();
        class_243 cpos = camera.method_19326();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        for (Line line : lines) {
            line.render(buffer, cpos.field_1352, cpos.field_1351, cpos.field_1350);
        }
        tesselator.method_1350();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        for (Quad quad : quads) {
            quad.render(buffer, cpos.field_1352, cpos.field_1351, cpos.field_1350);
        }
        tesselator.method_1350();
        class_4587 ps = RenderSystem.getModelViewStack();
        Quaternionf rot = camera.method_23767();
        for (Text text : texts) {
            text.render(buffer, ps, rot, cpos.field_1352, cpos.field_1351, cpos.field_1350);
        }
    }

    public static synchronized void clear() {
        lines.clear();
        quads.clear();
        texts.clear();
    }

    public static void addCuboid(int x, int y, int z, Color4f color) {
        LevelRenderer.addCuboidFaces(x, y, z, x + 1, y + 1, z + 1, color);
        LevelRenderer.addCuboidEdges(x, y, z, x + 1, y + 1, z + 1, color);
    }

    public static void addCuboidFaces(int x, int y, int z, Color4f color) {
        LevelRenderer.addCuboidFaces(x, y, z, x + 1, y + 1, z + 1, color);
    }

    public static void addCuboidEdges(int x, int y, int z, Color4f color) {
        LevelRenderer.addCuboidEdges(x, y, z, x + 1, y + 1, z + 1, color);
    }

    public static synchronized void addCuboidFaces(double x, double y, double z, double X, double Y, double Z, Color4f color) {
        QuadCuboid o = new QuadCuboid(x, y, z, X, Y, Z, color);
        if (!quads.add(o)) {
            quads.remove(o);
            quads.add(o);
        }
    }

    public static synchronized void addCuboidEdges(double x, double y, double z, double X, double Y, double Z, Color4f color) {
        LineCuboid o = new LineCuboid(x, y, z, X, Y, Z, color);
        if (!lines.add(o)) {
            lines.remove(o);
            lines.add(o);
        }
    }

    public static synchronized void addText(String text, int x, int y, int z, Color4f color) {
        TextBasic o = new TextBasic(text, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, color);
        if (!texts.add(o)) {
            texts.remove(o);
            texts.add(o);
        }
    }

    public static synchronized void addLabel(int index, int depth, int x, int y, int z, Color4f color1, Color4f color2) {
        DepthLabel o = new DepthLabel(String.valueOf(index), String.valueOf(depth), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, color1.intValue, color2.intValue);
        if (!texts.add(o)) {
            texts.remove(o);
            texts.add(o);
        }
    }

    private static interface Line {
        public void render(class_287 var1, double var2, double var4, double var6);
    }

    private static interface Quad {
        public void render(class_287 var1, double var2, double var4, double var6);
    }

    private static interface Text {
        public void render(class_287 var1, class_4587 var2, Quaternionf var3, double var4, double var6, double var8);
    }

    private record QuadCuboid(double x, double y, double z, double X, double Y, double Z, Color4f color) implements Quad
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object b) {
            if (!(b instanceof QuadCuboid)) return false;
            QuadCuboid o = (QuadCuboid)b;
            if (o.x != this.x) return false;
            if (o.y != this.y) return false;
            if (o.z != this.z) return false;
            if (o.X != this.X) return false;
            if (o.Y != this.Y) return false;
            if (o.Z != this.Z) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z, this.X, this.Y, this.Z);
        }

        @Override
        public void render(class_287 buffer, double cx, double cy, double cz) {
            double x = this.x - cx;
            double y = this.y - cy;
            double z = this.z - cz;
            double X = this.X - cx;
            double Y = this.Y - cy;
            double Z = this.Z - cz;
            buffer.method_22912(x, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
        }
    }

    private record LineCuboid(double x, double y, double z, double X, double Y, double Z, Color4f color) implements Line
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object b) {
            if (!(b instanceof LineCuboid)) return false;
            LineCuboid o = (LineCuboid)b;
            if (o.x != this.x) return false;
            if (o.y != this.y) return false;
            if (o.z != this.z) return false;
            if (o.X != this.X) return false;
            if (o.Y != this.Y) return false;
            if (o.Z != this.Z) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z, this.X, this.Y, this.Z);
        }

        @Override
        public void render(class_287 buffer, double cx, double cy, double cz) {
            double x = this.x - cx;
            double y = this.y - cy;
            double z = this.z - cz;
            double X = this.X - cx;
            double Y = this.Y - cy;
            double Z = this.Z - cz;
            buffer.method_22912(x, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(X, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, Y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
            buffer.method_22912(x, y, Z).method_22915(this.color.r, this.color.g, this.color.b, this.color.a).method_1344();
        }
    }

    private record TextBasic(String text, double x, double y, double z, Color4f color) implements Text
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object b) {
            if (!(b instanceof TextBasic)) return false;
            TextBasic o = (TextBasic)b;
            if (o.x != this.x) return false;
            if (o.y != this.y) return false;
            if (o.z != this.z) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }

        @Override
        public void render(class_287 buffer, class_4587 poseStack, Quaternionf rotation, double cx, double cy, double cz) {
            poseStack.method_22903();
            poseStack.method_22904(this.x - cx, this.y - cy, this.z - cz);
            poseStack.method_22907(rotation);
            poseStack.method_22905(-0.07f, -0.07f, 0.07f);
            RenderSystem.applyModelViewMatrix();
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)buffer);
            float f = (float)(-font.method_1727(this.text)) / 2.0f;
            Objects.requireNonNull(font);
            font.method_27521(this.text, f, (float)(-9) * 0.5f, this.color.intValue, false, class_4590.method_22931().method_22936(), (class_4597)immediate, class_327.class_6415.field_33994, 0, 0);
            immediate.method_22993();
            poseStack.method_22909();
        }
    }

    private record DepthLabel(String index, String depth, double x, double y, double z, int color1, int color2) implements Text
    {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object b) {
            if (!(b instanceof DepthLabel)) return false;
            DepthLabel o = (DepthLabel)b;
            if (o.x != this.x) return false;
            if (o.y != this.y) return false;
            if (o.z != this.z) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }

        @Override
        public void render(class_287 buffer, class_4587 poseStack, Quaternionf rotation, double cx, double cy, double cz) {
            poseStack.method_22903();
            poseStack.method_22904(this.x - cx, this.y - cy, this.z - cz);
            poseStack.method_22907(rotation);
            poseStack.method_22905(-0.07f, -0.07f, 0.08f);
            RenderSystem.applyModelViewMatrix();
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)buffer);
            float f = (float)(-font.method_1727(this.index)) / 2.0f;
            Objects.requireNonNull(font);
            font.method_27521(this.index, f, (float)(-9) * 0.5f, this.color1, false, class_4590.method_22931().method_22936(), (class_4597)immediate, class_327.class_6415.field_33994, 0, 0);
            immediate.method_22993();
            poseStack.method_46416((float)font.method_1727(this.index) / 2.0f, 0.0f, 0.0f);
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            RenderSystem.applyModelViewMatrix();
            immediate = class_4597.method_22991((class_287)buffer);
            float f2 = (float)(-font.method_1727(this.depth)) / 2.0f;
            Objects.requireNonNull(font);
            font.method_27521(this.depth, f2, (float)(9 + 1), this.color2, false, class_4590.method_22931().method_22936(), (class_4597)immediate, class_327.class_6415.field_33994, 0, 0);
            immediate.method_22993();
            poseStack.method_22909();
        }
    }
}

