/*
 * Decompiled with CFR 0.152.
 */
package subtick.network;

import carpet.CarpetSettings;
import carpet.network.CarpetClient;
import carpet.network.ClientNetworkHandler;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import subtick.QueueElement;
import subtick.TickPhase;
import subtick.mixins.carpet.ServerNetworkHandlerAccessor;
import subtick.util.Translations;

public class ServerNetworkHandler {
    private static boolean tryClient(class_3218 level, class_2487 tag) {
        if (level.field_13959.method_3816()) {
            return false;
        }
        class_2540 packetBuf = new class_2540(Unpooled.buffer());
        packetBuf.method_10804(1);
        packetBuf.method_10794(tag);
        class_310 minecraft = class_310.method_1551();
        ClientNetworkHandler.handleData((class_2540)packetBuf, (class_746)minecraft.field_1724);
        return true;
    }

    public static void sendNbt(class_3222 player, class_2487 tag, class_2168 actor) {
        class_3218 level = player.method_14220();
        if (ServerNetworkHandler.tryClient(level, tag)) {
            return;
        }
        class_2540 packetBuf = new class_2540(Unpooled.buffer());
        packetBuf.method_10804(1);
        packetBuf.method_10794(tag);
        try {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, packetBuf));
        }
        catch (IllegalArgumentException e) {
            Translations.m(actor, "queueCommand.err.packetSize");
        }
    }

    public static void sendNbt(class_3222 player, class_2487 tag) {
        class_3218 level = player.method_14220();
        if (ServerNetworkHandler.tryClient(level, tag)) {
            return;
        }
        class_2540 packetBuf = new class_2540(Unpooled.buffer());
        packetBuf.method_10804(1);
        packetBuf.method_10794(tag);
        try {
            player.field_13987.method_14364((class_2596)new class_2658(CarpetClient.CARPET_CHANNEL, packetBuf));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void sendNbt(class_3218 level, class_2487 tag, class_2168 actor) {
        if (ServerNetworkHandler.tryClient(level, tag)) {
            return;
        }
        for (class_3222 player : ServerNetworkHandlerAccessor.getRemoteCarpetPlayers().keySet()) {
            if (player.method_14220() != level) continue;
            ServerNetworkHandler.sendNbt(player, tag, actor);
        }
    }

    public static void sendNbt(class_3218 level, class_2487 tag) {
        if (ServerNetworkHandler.tryClient(level, tag)) {
            return;
        }
        for (class_3222 player : ServerNetworkHandlerAccessor.getRemoteCarpetPlayers().keySet()) {
            if (player.method_14220() != level) continue;
            ServerNetworkHandler.sendNbt(player, tag);
        }
    }

    public static void sendFrozen(class_3218 level, TickPhase tickPhase) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        class_2487 tag = new class_2487();
        class_2487 tickingState = new class_2487();
        tickingState.method_10556("is_paused", true);
        tickingState.method_10556("deepFreeze", true);
        tickingState.method_10569("phase", tickPhase.phase());
        tickingState.method_10569("dim", tickPhase.dim());
        class_2499 listTag = new class_2499();
        for (String dim : TickPhase.getDimensions()) {
            class_2487 element = new class_2487();
            element.method_10582("d", dim);
            listTag.add((Object)element);
        }
        tickingState.method_10566("dims", (class_2520)listTag);
        tag.method_10566("TickingState", (class_2520)tickingState);
        ServerNetworkHandler.sendNbt(level, tag);
    }

    public static void sendFrozen(class_3222 player, boolean frozen, TickPhase tickPhase) {
        if (CarpetSettings.superSecretSetting || !ServerNetworkHandlerAccessor.getRemoteCarpetPlayers().containsKey(player)) {
            return;
        }
        class_2487 tag = new class_2487();
        class_2487 tickingState = new class_2487();
        if (frozen) {
            tickingState.method_10556("is_paused", true);
            tickingState.method_10556("deepFreeze", true);
            tickingState.method_10569("phase", tickPhase.phase());
            tickingState.method_10569("dim", tickPhase.dim());
        } else {
            tickingState.method_10556("is_paused", false);
            tickingState.method_10556("deepFreeze", false);
            tickingState.method_10569("phase", -1);
            tickingState.method_10569("dim", -1);
        }
        class_2499 listTag = new class_2499();
        for (String dim : TickPhase.getDimensions()) {
            class_2487 element = new class_2487();
            element.method_10582("d", dim);
            listTag.add((Object)element);
        }
        tickingState.method_10566("dims", (class_2520)listTag);
        tag.method_10566("TickingState", (class_2520)tickingState);
        ServerNetworkHandler.sendNbt(player, tag);
    }

    public static void sendUnfrozen(class_3218 level) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        class_2487 tag = new class_2487();
        class_2487 tickingState = new class_2487();
        tickingState.method_10556("is_paused", false);
        tickingState.method_10556("deepFreeze", false);
        tickingState.method_10569("phase", -1);
        tickingState.method_10569("dim", -1);
        tag.method_10566("TickingState", (class_2520)tickingState);
        ServerNetworkHandler.sendNbt(level, tag);
    }

    public static void sendTickStep(class_3218 level, int ticks, TickPhase tickPhase) {
        class_2487 tag;
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        if (ticks != 0) {
            tag = new class_2487();
            tag.method_10569("TickPlayerActiveTimeout", ticks + 2);
            ServerNetworkHandler.sendNbt(level, tag);
        }
        tag = new class_2487();
        class_2487 phaseTag = new class_2487();
        phaseTag.method_10569("dim", tickPhase.dim());
        phaseTag.method_10569("phase", tickPhase.phase());
        tag.method_10566("TickPhase", (class_2520)phaseTag);
        ServerNetworkHandler.sendNbt(level, tag);
    }

    public static void sendQueueStep(ObjectLinkedOpenHashSet<QueueElement> queue, ArrayList<QueueElement> spentQueue, int newQueueElementsCount, int steps, class_3218 level, class_2168 actor) {
        class_2487 elementTag;
        if (CarpetSettings.superSecretSetting || queue.isEmpty() && spentQueue.isEmpty()) {
            return;
        }
        class_2487 tag = new class_2487();
        class_2487 queueTag = new class_2487();
        class_2499 list = new class_2499();
        for (QueueElement element : spentQueue) {
            elementTag = new class_2487();
            elementTag.method_10582("s", element.label());
            elementTag.method_10569("x", element.x());
            elementTag.method_10569("y", element.y());
            elementTag.method_10569("z", element.z());
            elementTag.method_10569("d", element.depth());
            list.add((Object)elementTag);
        }
        for (QueueElement element : queue) {
            elementTag = new class_2487();
            elementTag.method_10582("s", element.label());
            elementTag.method_10569("x", element.x());
            elementTag.method_10569("y", element.y());
            elementTag.method_10569("z", element.z());
            elementTag.method_10569("d", element.depth());
            list.add((Object)elementTag);
        }
        queueTag.method_10566("queue", (class_2520)list);
        queueTag.method_10569("steps", steps);
        queueTag.method_10569("newElements", newQueueElementsCount);
        tag.method_10566("QueueStep", (class_2520)queueTag);
        ServerNetworkHandler.sendNbt(level, tag, actor);
    }

    public static void sendQueue(ObjectLinkedOpenHashSet<QueueElement> queue, ArrayList<QueueElement> spentQueue, class_3218 level) {
        class_2487 elementTag;
        if (CarpetSettings.superSecretSetting || queue.isEmpty()) {
            return;
        }
        class_2487 tag = new class_2487();
        class_2499 list = new class_2499();
        for (QueueElement element : spentQueue) {
            elementTag = new class_2487();
            elementTag.method_10582("s", element.label());
            elementTag.method_10569("x", element.x());
            elementTag.method_10569("y", element.y());
            elementTag.method_10569("z", element.z());
            elementTag.method_10569("d", element.depth());
            list.add((Object)elementTag);
        }
        for (QueueElement element : queue) {
            elementTag = new class_2487();
            elementTag.method_10582("s", element.label());
            elementTag.method_10569("x", element.x());
            elementTag.method_10569("y", element.y());
            elementTag.method_10569("z", element.z());
            elementTag.method_10569("d", element.depth());
            list.add((Object)elementTag);
        }
        tag.method_10566("Queue", (class_2520)list);
        ServerNetworkHandler.sendNbt(level, tag);
    }
}

