/*
 * Decompiled with CFR 0.152.
 */
package subtick.queues;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_1919;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2623;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Triple;
import subtick.QueueElement;
import subtick.TickPhase;
import subtick.TickingMode;
import subtick.network.ServerNetworkHandler;
import subtick.queues.TickingQueue;

public class BlockEventQueue
extends TickingQueue {
    private static final TickingMode INDEX = new TickingMode("Block Event", "Block Events");
    private static final TickingMode DEPTH = new TickingMode("Block Event Depth", "Block Event Depths");
    private int depth;
    private int remainingSteps;

    public BlockEventQueue() {
        super(Map.of("index", INDEX, "depth", DEPTH), INDEX, TickPhase.BLOCK_EVENT, "blockEvent");
    }

    public void updateQueue(class_3218 level, class_1919 be) {
        if (this.queue.add((Object)new QueueElement(be, this.depth))) {
            ++this.newQueueElementsCount;
            ServerNetworkHandler.sendQueue((ObjectLinkedOpenHashSet<QueueElement>)this.queue, this.spentQueue, level);
        }
        this.exhausted = false;
    }

    @Override
    public void start(class_3218 level) {
        this.level = level;
        level.field_35565.clear();
        this.queue.clear();
        this.spentQueue.clear();
        for (class_1919 be : level.field_13950) {
            this.queue.add((Object)new QueueElement(be, 0));
        }
        this.depth = 0;
        this.remainingSteps = 0;
    }

    @Override
    public Triple<Integer, Integer, Boolean> step(int count, class_2338 pos, int range) {
        int executed_steps = 0;
        int success_steps = 0;
        while (success_steps < count && !this.level.field_13950.isEmpty()) {
            if (this.remainingSteps < 1) {
                ++this.depth;
                this.remainingSteps = this.level.field_13950.size();
            }
            int size = this.currentMode == INDEX ? 1 : this.remainingSteps;
            this.remainingSteps -= size;
            boolean stepped = false;
            for (int i = 0; i < size; ++i) {
                class_1919 blockEvent = (class_1919)this.level.field_13950.removeFirst();
                if (!this.queue.isEmpty()) {
                    this.spentQueue.add((QueueElement)this.queue.removeFirst());
                }
                if (this.level.method_39425(class_1923.method_37232((class_2338)blockEvent.comp_60()))) {
                    if (!this.level.method_14174(blockEvent)) {
                        this.spentQueue.remove(this.spentQueue.size() - 1);
                        continue;
                    }
                    this.level.field_13959.method_3760().method_14605(null, (double)blockEvent.comp_60().method_10263(), (double)blockEvent.comp_60().method_10264(), (double)blockEvent.comp_60().method_10260(), 64.0, this.level.method_27983(), (class_2596)new class_2623(blockEvent.comp_60(), blockEvent.comp_61(), blockEvent.comp_62(), blockEvent.comp_63()));
                    if (BlockEventQueue.rangeCheck(blockEvent.comp_60(), pos, range)) {
                        stepped = true;
                    }
                    ++executed_steps;
                } else {
                    this.queue.remove((Object)new QueueElement(blockEvent, this.depth - 1));
                }
                this.level.field_35565.add(blockEvent);
            }
            if (!stepped) continue;
            ++success_steps;
        }
        this.exhausted = this.level.field_13950.size() == 0;
        return Triple.of((Object)executed_steps, (Object)success_steps, (Object)this.exhausted);
    }

    @Override
    public void end() {
        this.level.field_13950.addAll((Collection)this.level.field_35565);
    }

    @Override
    public boolean cantStep() {
        return this.level.field_13950.isEmpty();
    }
}

