/*
 * Decompiled with CFR 0.152.
 */
package subtick.queues;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_6757;
import net.minecraft.class_6760;
import org.apache.commons.lang3.tuple.Triple;
import subtick.QueueElement;
import subtick.TickPhase;
import subtick.TickingMode;
import subtick.queues.TickingQueue;

public class ScheduledTickQueue<T>
extends TickingQueue {
    private final TickingMode INDEX;
    private final TickingMode PRIORITY;
    private class_6757<T> levelTicks;
    private BiConsumer<class_2338, T> biConsumer;

    public static ScheduledTickQueue<class_2248> block() {
        return new ScheduledTickQueue<class_2248>(new TickingMode("Block Tick", "Block Ticks"), new TickingMode("Block Tick Priority", "Block Tick Priorities"), TickPhase.BLOCK_TICK, "blockTick");
    }

    public static ScheduledTickQueue<class_3611> fluid() {
        return new ScheduledTickQueue<class_3611>(new TickingMode("Fluid Tick", "Fluid Ticks"), TickPhase.FLUID_TICK, "fluidTick");
    }

    public ScheduledTickQueue(TickingMode INDEX, TickingMode PRIORITY, int phase, String commandKey) {
        super(Map.of("index", INDEX, "priority", PRIORITY), INDEX, phase, commandKey);
        this.INDEX = INDEX;
        this.PRIORITY = PRIORITY;
    }

    public ScheduledTickQueue(TickingMode INDEX, int phase, String commandKey) {
        super(new HashMap<String, TickingMode>(), INDEX, phase, commandKey);
        this.INDEX = INDEX;
        this.PRIORITY = null;
    }

    @Override
    public void start(class_3218 level) {
        this.level = level;
        class_6757 class_67572 = this.levelTicks = this.phase == TickPhase.BLOCK_TICK ? level.field_13949 : level.field_13951;
        this.biConsumer = this.phase == TickPhase.BLOCK_TICK ? (arg_0, arg_1) -> ((class_3218)level).method_14189(arg_0, arg_1) : (arg_0, arg_1) -> ((class_3218)level).method_14171(arg_0, arg_1);
        this.levelTicks.method_39376(level.method_8510(), 65536, (class_3695)this.levelTicks.field_35533.get());
        this.queue.clear();
        for (class_6760 scheduledTick : this.levelTicks.field_35537) {
            this.queue.add((Object)new QueueElement(scheduledTick));
        }
    }

    @Override
    public Triple<Integer, Integer, Boolean> step(int count, class_2338 pos, int range) {
        int executed_steps = 0;
        int success_steps = 0;
        while (success_steps < count && !this.levelTicks.field_35537.isEmpty()) {
            class_6760 tick = (class_6760)this.levelTicks.field_35537.poll();
            if (!this.levelTicks.field_35539.isEmpty()) {
                this.levelTicks.field_35539.remove(tick);
            }
            this.levelTicks.field_35538.add(tick);
            this.biConsumer.accept(tick.comp_253(), (class_2338)tick.comp_252());
            if (this.currentMode == this.INDEX) {
                if (ScheduledTickQueue.rangeCheck(tick.comp_253(), pos, range)) {
                    ++success_steps;
                }
            } else {
                class_6760 nextTick = (class_6760)this.levelTicks.field_35537.peek();
                if (nextTick == null || nextTick.comp_255() != tick.comp_255()) {
                    ++success_steps;
                }
            }
            ++executed_steps;
        }
        this.exhausted = this.levelTicks.field_35537.isEmpty();
        return Triple.of((Object)executed_steps, (Object)success_steps, (Object)this.exhausted);
    }

    @Override
    public void end() {
        this.levelTicks.method_39394();
    }
}

