/*
 * Decompiled with CFR 0.152.
 */
package subtick.queues;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Triple;
import subtick.QueueElement;
import subtick.TickingMode;
import subtick.network.ServerNetworkHandler;
import subtick.queues.BlockEntityQueue;
import subtick.queues.BlockEventQueue;
import subtick.queues.EntityQueue;
import subtick.queues.ScheduledTickQueue;

public abstract class TickingQueue {
    public static final DynamicCommandExceptionType INVALID_MODE_EXCEPTION = new DynamicCommandExceptionType(key -> new LiteralMessage("Invalid mode '" + String.valueOf(key) + "'"));
    public static final DynamicCommandExceptionType INVALID_QUEUE_EXCEPTION = new DynamicCommandExceptionType(key -> new LiteralMessage("Invalid queue '" + String.valueOf(key) + "'"));
    protected final ObjectLinkedOpenHashSet<QueueElement> queue = new ObjectLinkedOpenHashSet();
    protected final ArrayList<QueueElement> spentQueue = new ArrayList();
    protected int newQueueElementsCount = 0;
    public boolean exhausted;
    protected final int phase;
    protected final String commandKey;
    protected final Map<String, TickingMode> modes;
    protected final TickingMode defaultMode;
    protected TickingMode currentMode;
    protected class_3218 level;
    public static final TickingQueue BLOCK_TICK = ScheduledTickQueue.block();
    public static final TickingQueue FLUID_TICK = ScheduledTickQueue.fluid();
    public static final TickingQueue BLOCK_EVENT = new BlockEventQueue();
    public static final TickingQueue ENTITY = new EntityQueue();
    public static final TickingQueue BLOCK_ENTITY = new BlockEntityQueue();
    private static final ImmutableMap<String, TickingQueue> BY_COMMAND_KEY = ImmutableMap.of((Object)"blockTick", (Object)BLOCK_TICK, (Object)"fluidTick", (Object)FLUID_TICK, (Object)"blockEvent", (Object)BLOCK_EVENT, (Object)"entity", (Object)ENTITY, (Object)"blockEntity", (Object)BLOCK_ENTITY);
    public static String[] commandKeys = new String[]{TickingQueue.BLOCK_TICK.commandKey, TickingQueue.FLUID_TICK.commandKey, TickingQueue.BLOCK_EVENT.commandKey, TickingQueue.ENTITY.commandKey, TickingQueue.BLOCK_ENTITY.commandKey};

    public TickingQueue(int phase, String commandKey, String nameSingle, String nameMultiple) {
        this(new HashMap<String, TickingMode>(), new TickingMode(nameSingle, nameMultiple), phase, commandKey);
    }

    public TickingQueue(Map<String, TickingMode> modes, TickingMode defaultMode, int phase, String commandKey) {
        this.modes = modes;
        this.defaultMode = defaultMode;
        this.phase = phase;
        this.commandKey = commandKey;
    }

    public static TickingQueue byCommandKey(String commandKey) throws CommandSyntaxException {
        TickingQueue queue = (TickingQueue)BY_COMMAND_KEY.get((Object)commandKey);
        if (queue == null) {
            throw INVALID_QUEUE_EXCEPTION.create((Object)commandKey);
        }
        return queue;
    }

    public Set<String> getModes() {
        return this.modes.keySet();
    }

    public void setMode(String key) throws CommandSyntaxException {
        TickingMode newMode;
        TickingMode tickingMode = newMode = key.equals("") ? this.defaultMode : this.modes.get(key);
        if (newMode == null) {
            throw INVALID_MODE_EXCEPTION.create((Object)key);
        }
        this.currentMode = newMode;
    }

    public int getPhase() {
        return this.phase;
    }

    @Deprecated
    public String getName(int count) {
        return this.currentMode.getName(count);
    }

    public String getName() {
        return this.currentMode.getName();
    }

    public String getNamePlural() {
        return this.currentMode.getNamePlural();
    }

    protected static boolean rangeCheck(class_2338 a, class_2338 b, long range) {
        long z;
        long y;
        if (range == -2L) {
            return false;
        }
        if (range == -1L) {
            return true;
        }
        long x = a.method_10263() - b.method_10263();
        return x * x + (y = (long)(a.method_10264() - b.method_10264())) * y + (z = (long)(a.method_10260() - b.method_10260())) * z <= range * range;
    }

    public void sendQueueStep(class_2168 actor, int count) {
        ServerNetworkHandler.sendQueueStep(this.queue, this.spentQueue, this.newQueueElementsCount, count, actor.method_9225(), actor);
        this.newQueueElementsCount = 0;
    }

    public boolean cantStep() {
        return this.exhausted;
    }

    public void start(class_3218 level) {
        this.level = level;
    }

    public abstract Triple<Integer, Integer, Boolean> step(int var1, class_2338 var2, int var3);

    public void end() {
    }
}

