/*
 * Decompiled with CFR 0.152.
 */
package subtick.util;

import carpet.utils.Messenger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_2168;
import org.apache.commons.io.IOUtils;
import subtick.Settings;
import subtick.TickPhase;
import subtick.queues.TickingQueue;

public class Translations {
    public static Map<String, String> getTranslationFromResourcePath(String lang) {
        String jsonData;
        InputStream langFile = Translations.class.getClassLoader().getResourceAsStream("assets/subtick/lang/%s.json".formatted(lang));
        if (langFile == null) {
            return Collections.emptyMap();
        }
        try {
            jsonData = IOUtils.toString((InputStream)langFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        Gson gson = new GsonBuilder().setLenient().create();
        return (Map)gson.fromJson(jsonData, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static String tr(String key) {
        return carpet.utils.Translations.tr((String)key);
    }

    public static String[] tr(String key, TickPhase phase, Integer n) {
        String t = (key.contains(".err") ? Settings.subtickErrorFormat : Settings.subtickTextFormat) + " ";
        Object tr = t + Translations.tr(key);
        t = "\u0000" + t;
        if (phase != null) {
            tr = ((String)tr).replace("{dim}", "\u0000" + Translations.dim(phase) + t).replace("{phase}", "\u0000" + Translations.phase(phase) + t);
        }
        if (n != null) {
            tr = ((String)tr).replace("{n}", "\u0000" + Translations.n(n) + t);
        }
        return ((String)tr).split("\u0000");
    }

    public static String[] tr(String key, TickPhase phase) {
        String t = (key.contains(".err") ? Settings.subtickErrorFormat : Settings.subtickTextFormat) + " ";
        Object tr = t + Translations.tr(key);
        t = "\u0000" + t;
        if (phase != null) {
            tr = ((String)tr).replace("{dim}", "\u0000" + Translations.dim(phase) + t).replace("{phase}", "\u0000" + Translations.phase(phase) + t);
        }
        return ((String)tr).split("\u0000");
    }

    public static String[] tr(String key, TickingQueue queue, Integer n) {
        Object t = Translations.t(key.contains(".err"));
        Object tr = (String)t + Translations.tr(key);
        t = "\u0000" + (String)t;
        if (queue != null) {
            tr = ((String)tr).replace("{queue}", "\u0000" + Translations.queue(queue) + (String)t);
            tr = ((String)tr).replace("{queues}", "\u0000" + Translations.queues(queue) + (String)t);
        }
        if (n != null) {
            tr = ((String)tr).replace("{n}", "\u0000" + Translations.n(n) + (String)t);
        }
        return ((String)tr).split("\u0000");
    }

    public static void m(class_2168 source, String key) {
        Messenger.m((class_2168)source, (Object[])new Object[]{Translations.t(key.contains(".err")) + Translations.tr("subtick.feedback." + key)});
    }

    public static void m(class_2168 source, String key, TickPhase phase) {
        Messenger.m((class_2168)source, (Object[])Translations.tr("subtick.feedback." + key, phase));
    }

    public static void m(class_2168 source, String key, TickPhase phase, int n) {
        Messenger.m((class_2168)source, (Object[])Translations.tr("subtick.feedback." + key, phase, (Integer)n));
    }

    public static void m(class_2168 source, String key, TickingQueue queue) {
        Messenger.m((class_2168)source, (Object[])Translations.tr("subtick.feedback." + key, queue, null));
    }

    public static void m(class_2168 source, String key, TickingQueue queue, int n) {
        Messenger.m((class_2168)source, (Object[])Translations.tr("subtick.feedback." + key, queue, (Integer)n));
    }

    public static String t(boolean err) {
        return err ? Settings.subtickErrorFormat + " " : Settings.subtickTextFormat + " ";
    }

    public static String n(int x) {
        return Settings.subtickNumberFormat + " " + x;
    }

    public static String queue(TickingQueue queue) {
        return Settings.subtickPhaseFormat + " " + queue.getName();
    }

    public static String queues(TickingQueue queue) {
        return Settings.subtickPhaseFormat + " " + queue.getNamePlural();
    }

    public static String phase(TickPhase phase) {
        return Settings.subtickPhaseFormat + " " + phase.getPhaseName();
    }

    public static String dim(TickPhase phase) {
        String path = phase.getPath();
        return Settings.subtickDimensionFormat + " " + path.substring(0, 1).toUpperCase() + path.substring(1) + "\u0000^" + Settings.subtickDimensionFormat + " " + path;
    }
}

