/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.bungee;

import com.protectcord.bungee.api.ProtectCordAPI;
import com.protectcord.bungee.bstats.bungeecord.Metrics;
import com.protectcord.bungee.command.ProtectCordCommand;
import com.protectcord.bungee.config.ConfigManager;
import com.protectcord.bungee.listener.PlayerConnectionListener;
import com.protectcord.bungee.update.UpdateChecker;
import com.protectcord.bungee.warn.WarnManager;
import com.protectcord.bungee.webhook.WebhookManager;
import com.protectcord.bungee.whitelist.WhitelistManager;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;

public class ProtectCordPlugin
extends Plugin {
    private static ProtectCordPlugin instance;
    private ConfigManager configManager;
    private ProtectCordAPI api;
    private WhitelistManager whitelistManager;
    private WebhookManager webhookManager;
    private WarnManager warnManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.getLogger().info("==========================================");
        this.getLogger().info("ProtectCord v1.0.8 by ProtectCord");
        this.getLogger().info("Platform: BungeeCord | MC: 1.8.8 - 1.21+");
        this.getLogger().info("https://protectcord.com");
        this.getLogger().info("==========================================");
        String apiKey = this.configManager.getApiKey();
        if (apiKey == null || apiKey.isEmpty() || apiKey.equals("YOUR_API_KEY_HERE")) {
            this.getLogger().severe("========================================");
            this.getLogger().severe("API KEY NOT CONFIGURED!");
            this.getLogger().severe("Please follow these steps:");
            this.getLogger().severe("1. Go to https://protectcord.com");
            this.getLogger().severe("2. Navigate to Dashboard > API Keys");
            this.getLogger().severe("3. Generate a new API key");
            this.getLogger().severe("4. Add the key to config.yml");
            this.getLogger().severe("5. Restart the proxy");
            this.getLogger().severe("========================================");
            return;
        }
        this.api = new ProtectCordAPI(apiKey, this.configManager.getConnectTimeout(), this.configManager.getReadTimeout());
        this.whitelistManager = new WhitelistManager(this);
        this.webhookManager = new WebhookManager(this);
        this.warnManager = new WarnManager(this.getDataFolder());
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerConnectionListener(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ProtectCordCommand(this));
        int pluginId = 24623;
        Metrics metrics = new Metrics(this, pluginId);
        this.getLogger().info("ProtectCord has been enabled successfully!");
        UpdateChecker updateChecker = new UpdateChecker(this);
        updateChecker.checkForUpdates().thenAccept(updateInfo -> {
            if (updateInfo != null) {
                updateChecker.notifyUpdate((UpdateChecker.UpdateInfo)updateInfo);
            }
        });
        this.getProxy().getScheduler().schedule((Plugin)this, () -> updateChecker.checkForUpdates().thenAccept(updateInfo -> {
            if (updateInfo != null) {
                updateChecker.notifyUpdate((UpdateChecker.UpdateInfo)updateInfo);
            }
        }), 1L, 1L, TimeUnit.HOURS);
    }

    public void onDisable() {
        if (this.api != null) {
            this.api.shutdown();
        }
        this.getLogger().info("ProtectCord has been disabled.");
    }

    public static ProtectCordPlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ProtectCordAPI getAPI() {
        return this.api;
    }

    public WhitelistManager getWhitelistManager() {
        return this.whitelistManager;
    }

    public WebhookManager getWebhookManager() {
        return this.webhookManager;
    }

    public WarnManager getWarnManager() {
        return this.warnManager;
    }
}

