/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.bungee.listener;

import com.protectcord.bungee.ProtectCordPlugin;
import com.protectcord.bungee.api.IPCheckResult;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class PlayerConnectionListener
implements Listener {
    private final ProtectCordPlugin plugin;

    public PlayerConnectionListener(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=64)
    public void onPreLogin(PreLoginEvent event) {
        String playerName = event.getConnection().getName();
        String uuid = event.getConnection().getUniqueId().toString();
        InetSocketAddress address = event.getConnection().getAddress();
        InetAddress inetAddress = address.getAddress();
        String ipAddress = inetAddress.getHostAddress();
        if (this.plugin.getWarnManager().isBanned(event.getConnection().getUniqueId())) {
            List<String> banReasons = this.plugin.getWarnManager().getBanReasons(event.getConnection().getUniqueId());
            String banMessage = ChatColor.DARK_RED + "" + ChatColor.BOLD + "[PERMANENTLY BANNED]\n\n" + ChatColor.RED + "You are permanently banned from this server.\n\n" + ChatColor.GRAY + "Reasons:\n" + banReasons.stream().map(r -> ChatColor.GRAY + "- " + ChatColor.WHITE + r).collect(Collectors.joining("\n")) + "\n\n" + ChatColor.GRAY + "Appeal at: " + ChatColor.GREEN + "https://protectcord.com";
            event.setCancelled(true);
            event.setCancelReason(TextComponent.fromLegacyText((String)banMessage));
            this.plugin.getLogger().warning("Blocked banned player " + playerName + " (" + uuid + ") from connecting");
            return;
        }
        if (this.plugin.getWarnManager().isIPBanned(ipAddress)) {
            List<String> banReasons = this.plugin.getWarnManager().getIPBanReasons(ipAddress);
            String banMessage = ChatColor.DARK_RED + "" + ChatColor.BOLD + "[IP BANNED]\n\n" + ChatColor.RED + "Your IP address is banned from this server.\n\n" + ChatColor.GRAY + "Reasons:\n" + banReasons.stream().map(r -> ChatColor.GRAY + "- " + ChatColor.WHITE + r).collect(Collectors.joining("\n")) + "\n\n" + ChatColor.GRAY + "Appeal at: " + ChatColor.GREEN + "https://protectcord.com";
            event.setCancelled(true);
            event.setCancelReason(TextComponent.fromLegacyText((String)banMessage));
            this.plugin.getLogger().warning("Blocked IP banned connection from " + playerName + " (" + ipAddress + ")");
            return;
        }
        if (!this.plugin.getConfigManager().isCheckEnabled()) {
            return;
        }
        if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
            this.plugin.getLogger().info("Player " + playerName + " bypassed IP check (local/private IP: " + ipAddress + ")");
            return;
        }
        if (this.plugin.getWhitelistManager().isWhitelisted(playerName, event.getConnection().getUniqueId(), ipAddress)) {
            this.plugin.getLogger().info("Player " + playerName + " bypassed IP check (whitelisted)");
            this.plugin.getWebhookManager().sendWhitelistedWebhook(playerName, uuid, ipAddress);
            return;
        }
        event.registerIntent((Plugin)this.plugin);
        ((CompletableFuture)this.plugin.getAPI().checkIP(ipAddress).thenAccept(result -> {
            try {
                if (result == null) {
                    this.plugin.getLogger().warning("Failed to check IP for " + playerName + " (" + ipAddress + ")");
                    this.plugin.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, "API returned null result");
                    return;
                }
                boolean shouldBlock = false;
                String reason = "";
                if (this.plugin.getConfigManager().isGeoBlockingEnabled()) {
                    String countryCode = result.getCountryCode();
                    String mode = this.plugin.getConfigManager().getGeoBlockingMode();
                    List<String> countries = this.plugin.getConfigManager().getGeoBlockingCountries();
                    if (mode.equalsIgnoreCase("blacklist") && countries.contains(countryCode)) {
                        shouldBlock = true;
                        reason = "Country blocked (" + result.getCountry() + ")";
                    } else if (mode.equalsIgnoreCase("whitelist") && !countries.contains(countryCode)) {
                        shouldBlock = true;
                        reason = "Country not whitelisted (" + result.getCountry() + ")";
                    }
                }
                if (!shouldBlock && result.isBogon() && this.plugin.getConfigManager().shouldBlockBogon()) {
                    shouldBlock = true;
                    reason = "Bogon IP address";
                } else if (!shouldBlock && result.isTor() && this.plugin.getConfigManager().shouldBlockTor()) {
                    shouldBlock = true;
                    reason = "Tor exit node detected";
                } else if (!shouldBlock && result.isVPN() && this.plugin.getConfigManager().shouldBlockVPN()) {
                    shouldBlock = true;
                    reason = "VPN detected";
                } else if (!shouldBlock && result.isProxy() && this.plugin.getConfigManager().shouldBlockProxy()) {
                    shouldBlock = true;
                    reason = "Proxy detected";
                } else if (!shouldBlock && result.isDatacenter() && this.plugin.getConfigManager().shouldBlockDatacenter()) {
                    shouldBlock = true;
                    reason = "Datacenter IP";
                }
                if (!shouldBlock && this.plugin.getConfigManager().isRiskLevelBlockingEnabled()) {
                    String blockedRiskLevel = this.plugin.getConfigManager().getBlockedRiskLevel();
                    if (blockedRiskLevel.equals("HIGH") && (result.getRiskLevel().equals("HIGH") || result.getRiskLevel().equals("CRITICAL"))) {
                        shouldBlock = true;
                        reason = "High risk IP (" + result.getRiskLevel() + ")";
                    } else if (blockedRiskLevel.equals("MEDIUM") && !result.getRiskLevel().equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                        shouldBlock = true;
                        reason = "Medium+ risk IP (" + result.getRiskLevel() + ")";
                    } else if (blockedRiskLevel.equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                        shouldBlock = true;
                        reason = "Risk detected (" + result.getRiskLevel() + ")";
                    }
                }
                if (shouldBlock) {
                    String kickMessage = this.plugin.getConfigManager().getMessage("connection-denied").replace("{reason}", reason).replace("{risk}", result.getRiskLevel());
                    event.setCancelled(true);
                    event.setCancelReason(TextComponent.fromLegacyText((String)kickMessage));
                    this.plugin.getLogger().warning("Blocked " + playerName + " (" + ipAddress + ") - " + reason);
                    this.plugin.getWebhookManager().sendDeniedWebhook(playerName, uuid, ipAddress, (IPCheckResult)result);
                } else {
                    this.plugin.getLogger().info("Allowed " + playerName + " (" + ipAddress + ") - Risk: " + result.getRiskLevel());
                    this.plugin.getWarnManager().logPlayerIP(event.getConnection().getUniqueId(), ipAddress);
                    this.plugin.getWebhookManager().sendAcceptedWebhook(playerName, uuid, ipAddress, (IPCheckResult)result);
                }
            }
            finally {
                event.completeIntent((Plugin)this.plugin);
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().severe("Error checking IP for " + playerName + ": " + throwable.getMessage());
            this.plugin.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, throwable.getMessage());
            event.completeIntent((Plugin)this.plugin);
            return null;
        });
    }
}

