/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.bungee.warn;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class WarnManager {
    private final File dataFolder;
    private File warningsFile;
    private Configuration warningsConfig;

    public WarnManager(File dataFolder) {
        this.dataFolder = dataFolder;
        this.loadWarnings();
    }

    private void loadWarnings() {
        this.warningsFile = new File(this.dataFolder, "warnings.yml");
        if (!this.warningsFile.exists()) {
            try {
                this.dataFolder.mkdirs();
                this.warningsFile.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Could not create warnings.yml: " + e.getMessage());
            }
        }
        try {
            this.warningsConfig = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.warningsFile);
            if (this.warningsConfig.get("players") == null) {
                this.warningsConfig.set("players", new HashMap());
                this.saveWarnings();
            }
        }
        catch (IOException e) {
            System.err.println("Could not load warnings.yml: " + e.getMessage());
            this.warningsConfig = new Configuration();
        }
    }

    public void saveWarnings() {
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.warningsConfig, this.warningsFile);
        }
        catch (IOException e) {
            System.err.println("Could not save warnings.yml: " + e.getMessage());
        }
    }

    public void reloadWarnings() {
        this.loadWarnings();
    }

    public void addWarning(UUID playerUUID, String reason, String issuer) {
        String path = "players." + playerUUID.toString();
        List<Map<String, Object>> warnings = this.getWarningsList(playerUUID);
        HashMap<String, Object> warning = new HashMap<String, Object>();
        warning.put("timestamp", System.currentTimeMillis());
        warning.put("reason", reason);
        warning.put("issuer", issuer);
        warnings.add(warning);
        this.warningsConfig.set(path + ".warnings", warnings);
        this.saveWarnings();
    }

    public List<Map<String, Object>> getWarningsList(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".warnings";
        Object warningsObj = this.warningsConfig.get(path);
        if (warningsObj instanceof List) {
            return (List)warningsObj;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public int getWarningCount(UUID playerUUID) {
        return this.getWarningsList(playerUUID).size();
    }

    public boolean isBanned(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.banned";
        Object banned = this.warningsConfig.get(path);
        return banned instanceof Boolean && (Boolean)banned != false;
    }

    public void banPlayer(UUID playerUUID, List<String> reasons) {
        String path = "players." + playerUUID.toString() + ".ban";
        this.warningsConfig.set(path + ".banned", (Object)true);
        this.warningsConfig.set(path + ".timestamp", (Object)System.currentTimeMillis());
        this.warningsConfig.set(path + ".reasons", reasons);
        List<String> playerIPs = this.getPlayerIPs(playerUUID);
        for (String ip : playerIPs) {
            this.banIP(ip, playerUUID.toString(), reasons);
        }
        this.saveWarnings();
    }

    public void unbanPlayer(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban";
        this.warningsConfig.set(path + ".banned", (Object)false);
        this.saveWarnings();
    }

    public List<String> getBanReasons(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.reasons";
        Object reasons = this.warningsConfig.get(path);
        if (reasons instanceof List) {
            return (List)reasons;
        }
        return new ArrayList<String>();
    }

    public void clearWarnings(UUID playerUUID) {
        String path = "players." + playerUUID.toString();
        this.warningsConfig.set(path, null);
        this.saveWarnings();
    }

    public Map<String, Object> getPlayerData(UUID playerUUID) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("warnings", this.getWarningsList(playerUUID));
        data.put("warningCount", this.getWarningCount(playerUUID));
        data.put("banned", this.isBanned(playerUUID));
        data.put("banReasons", this.getBanReasons(playerUUID));
        return data;
    }

    public void logPlayerIP(UUID playerUUID, String ipAddress) {
        String path = "players." + playerUUID.toString() + ".ip-history";
        Object historyObj = this.warningsConfig.get(path);
        ArrayList<String> ipHistory = historyObj instanceof List ? new ArrayList((List)historyObj) : new ArrayList<String>();
        if (!ipHistory.contains(ipAddress)) {
            ipHistory.add(ipAddress);
            this.warningsConfig.set(path, ipHistory);
            this.saveWarnings();
        }
    }

    public List<String> getPlayerIPs(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ip-history";
        Object historyObj = this.warningsConfig.get(path);
        if (historyObj instanceof List) {
            return new ArrayList<String>((List)historyObj);
        }
        return new ArrayList<String>();
    }

    public void banIP(String ipAddress, String associatedUUID, List<String> reasons) {
        String path = "banned-ips." + ipAddress.replace(".", "_");
        this.warningsConfig.set(path + ".banned", (Object)true);
        this.warningsConfig.set(path + ".timestamp", (Object)System.currentTimeMillis());
        this.warningsConfig.set(path + ".associated-uuid", (Object)associatedUUID);
        this.warningsConfig.set(path + ".reasons", reasons);
        this.saveWarnings();
    }

    public boolean isIPBanned(String ipAddress) {
        String path = "banned-ips." + ipAddress.replace(".", "_") + ".banned";
        Object banned = this.warningsConfig.get(path);
        return banned instanceof Boolean && (Boolean)banned != false;
    }

    public List<String> getIPBanReasons(String ipAddress) {
        String path = "banned-ips." + ipAddress.replace(".", "_") + ".reasons";
        Object reasons = this.warningsConfig.get(path);
        if (reasons instanceof List) {
            return new ArrayList<String>((List)reasons);
        }
        return new ArrayList<String>();
    }

    public void unbanIP(String ipAddress) {
        String path = "banned-ips." + ipAddress.replace(".", "_") + ".banned";
        this.warningsConfig.set(path, (Object)false);
        this.saveWarnings();
    }

    public void unbanPlayerAndIPs(UUID playerUUID) {
        this.unbanPlayer(playerUUID);
        List<String> playerIPs = this.getPlayerIPs(playerUUID);
        for (String ip : playerIPs) {
            this.unbanIP(ip);
        }
        this.saveWarnings();
    }
}

