/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.velocity.whitelist;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import com.protectcord.velocity.ProtectCordPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class WhitelistManager {
    private final ProtectCordPlugin plugin;
    private File whitelistFile;
    private Toml whitelistConfig;
    private Map<String, Object> whitelistData;

    public WhitelistManager(ProtectCordPlugin plugin) {
        this.plugin = plugin;
        this.loadWhitelist();
    }

    private void loadWhitelist() {
        this.whitelistFile = new File(this.plugin.getDataDirectory().toFile(), "whitelist.toml");
        if (!this.whitelistFile.exists()) {
            try {
                this.whitelistFile.createNewFile();
                this.whitelistData = new HashMap<String, Object>();
                this.whitelistData.put("whitelisted-players", new ArrayList());
                this.whitelistData.put("whitelisted-uuids", new ArrayList());
                this.whitelistData.put("whitelisted-ips", new ArrayList());
                this.saveWhitelist();
            }
            catch (IOException e) {
                this.plugin.getLogger().error("Could not create whitelist.toml: " + e.getMessage());
            }
        }
        try {
            this.whitelistConfig = new Toml().read(this.whitelistFile);
            this.whitelistData = new HashMap<String, Object>();
            this.whitelistData.put("whitelisted-players", this.whitelistConfig.getList("whitelisted-players", new ArrayList()));
            this.whitelistData.put("whitelisted-uuids", this.whitelistConfig.getList("whitelisted-uuids", new ArrayList()));
            this.whitelistData.put("whitelisted-ips", this.whitelistConfig.getList("whitelisted-ips", new ArrayList()));
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Could not load whitelist.toml: " + e.getMessage());
            this.whitelistData = new HashMap<String, Object>();
            this.whitelistData.put("whitelisted-players", new ArrayList());
            this.whitelistData.put("whitelisted-uuids", new ArrayList());
            this.whitelistData.put("whitelisted-ips", new ArrayList());
        }
    }

    private void saveWhitelist() {
        try {
            TomlWriter writer = new TomlWriter();
            writer.write(this.whitelistData, this.whitelistFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().error("Could not save whitelist.toml: " + e.getMessage());
        }
    }

    public void reloadWhitelist() {
        this.loadWhitelist();
    }

    public boolean isWhitelisted(String playerName, UUID uuid, String ipAddress) {
        List whitelistedPlayers = (List)this.whitelistData.get("whitelisted-players");
        List whitelistedUUIDs = (List)this.whitelistData.get("whitelisted-uuids");
        List whitelistedIPs = (List)this.whitelistData.get("whitelisted-ips");
        return whitelistedPlayers.contains(playerName.toLowerCase()) || whitelistedUUIDs.contains(uuid.toString()) || whitelistedIPs.contains(ipAddress);
    }

    public void addPlayer(String playerName) {
        List whitelistedPlayers = (List)this.whitelistData.get("whitelisted-players");
        if (!whitelistedPlayers.contains(playerName.toLowerCase())) {
            whitelistedPlayers.add(playerName.toLowerCase());
            this.saveWhitelist();
        }
    }

    public void removePlayer(String playerName) {
        List whitelistedPlayers = (List)this.whitelistData.get("whitelisted-players");
        whitelistedPlayers.remove(playerName.toLowerCase());
        this.saveWhitelist();
    }

    public void addUUID(UUID uuid) {
        List whitelistedUUIDs = (List)this.whitelistData.get("whitelisted-uuids");
        if (!whitelistedUUIDs.contains(uuid.toString())) {
            whitelistedUUIDs.add(uuid.toString());
            this.saveWhitelist();
        }
    }

    public void removeUUID(UUID uuid) {
        List whitelistedUUIDs = (List)this.whitelistData.get("whitelisted-uuids");
        whitelistedUUIDs.remove(uuid.toString());
        this.saveWhitelist();
    }

    public void addIP(String ipAddress) {
        List whitelistedIPs = (List)this.whitelistData.get("whitelisted-ips");
        if (!whitelistedIPs.contains(ipAddress)) {
            whitelistedIPs.add(ipAddress);
            this.saveWhitelist();
        }
    }

    public void removeIP(String ipAddress) {
        List whitelistedIPs = (List)this.whitelistData.get("whitelisted-ips");
        whitelistedIPs.remove(ipAddress);
        this.saveWhitelist();
    }

    public List<String> getWhitelistedPlayers() {
        return (List)this.whitelistData.get("whitelisted-players");
    }

    public List<String> getWhitelistedUUIDs() {
        return (List)this.whitelistData.get("whitelisted-uuids");
    }

    public List<String> getWhitelistedIPs() {
        return (List)this.whitelistData.get("whitelisted-ips");
    }
}

