/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.velocity.command;

import com.protectcord.velocity.ProtectCordPlugin;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ProtectCordCommand
implements SimpleCommand {
    private final ProtectCordPlugin plugin;

    public ProtectCordCommand(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (!sender.hasPermission("protectcord.admin")) {
            sender.sendMessage((Component)Component.text((String)"You don't have permission to use this command.", (TextColor)NamedTextColor.RED));
            return;
        }
        if (args.length == 0) {
            this.sendHelp(invocation);
            return;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getWhitelistManager().reloadWhitelist();
                sender.sendMessage((Component)Component.text((String)"ProtectCord configuration reloaded!", (TextColor)NamedTextColor.GREEN));
                break;
            }
            case "whitelist": {
                if (args.length < 3) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /protectcord whitelist <add|remove> <player|uuid|ip> <value>", (TextColor)NamedTextColor.RED));
                    return;
                }
                this.handleWhitelist(invocation, args);
                break;
            }
            case "list": {
                this.handleList(invocation);
                break;
            }
            case "check": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /protectcord check <player|ip>", (TextColor)NamedTextColor.RED));
                    return;
                }
                this.handleCheck(invocation, args[1]);
                break;
            }
            case "stats": {
                this.handleStats(invocation);
                break;
            }
            case "version": {
                this.handleVersion(invocation);
                break;
            }
            case "kick": {
                if (args.length < 2) {
                    sender.sendMessage((Component)Component.text((String)"Usage: /protectcord kick <player>", (TextColor)NamedTextColor.RED));
                    return;
                }
                this.handleKick(invocation, args[1]);
                break;
            }
            default: {
                this.sendHelp(invocation);
            }
        }
    }

    private void handleWhitelist(SimpleCommand.Invocation invocation, String[] args) {
        CommandSource sender = invocation.source();
        String action = args[1].toLowerCase();
        String type = args[2].toLowerCase();
        if (args.length < 4) {
            sender.sendMessage((Component)Component.text((String)"Please specify a value.", (TextColor)NamedTextColor.RED));
            return;
        }
        String value = args[3];
        block6 : switch (action) {
            case "add": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().addPlayer(value);
                        sender.sendMessage((Component)Component.text((String)("Added player " + value + " to whitelist."), (TextColor)NamedTextColor.GREEN));
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().addUUID(uuid);
                            sender.sendMessage((Component)Component.text((String)("Added UUID " + value + " to whitelist."), (TextColor)NamedTextColor.GREEN));
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage((Component)Component.text((String)"Invalid UUID format.", (TextColor)NamedTextColor.RED));
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().addIP(value);
                        sender.sendMessage((Component)Component.text((String)("Added IP " + value + " to whitelist."), (TextColor)NamedTextColor.GREEN));
                        break block6;
                    }
                }
                sender.sendMessage((Component)Component.text((String)"Invalid type. Use: player, uuid, or ip", (TextColor)NamedTextColor.RED));
                break;
            }
            case "remove": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().removePlayer(value);
                        sender.sendMessage((Component)Component.text((String)("Removed player " + value + " from whitelist."), (TextColor)NamedTextColor.GREEN));
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().removeUUID(uuid);
                            sender.sendMessage((Component)Component.text((String)("Removed UUID " + value + " from whitelist."), (TextColor)NamedTextColor.GREEN));
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage((Component)Component.text((String)"Invalid UUID format.", (TextColor)NamedTextColor.RED));
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().removeIP(value);
                        sender.sendMessage((Component)Component.text((String)("Removed IP " + value + " from whitelist."), (TextColor)NamedTextColor.GREEN));
                        break block6;
                    }
                }
                sender.sendMessage((Component)Component.text((String)"Invalid type. Use: player, uuid, or ip", (TextColor)NamedTextColor.RED));
                break;
            }
            default: {
                sender.sendMessage((Component)Component.text((String)"Invalid action. Use: add or remove", (TextColor)NamedTextColor.RED));
            }
        }
    }

    private void handleList(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        sender.sendMessage((Component)Component.text((String)"=== ProtectCord Whitelist ===", (TextColor)NamedTextColor.GOLD));
        List<String> players = this.plugin.getWhitelistManager().getWhitelistedPlayers();
        sender.sendMessage((Component)Component.text((String)("Whitelisted Players (" + players.size() + "):"), (TextColor)NamedTextColor.YELLOW));
        if (players.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)"  None", (TextColor)NamedTextColor.GRAY));
        } else {
            for (String string : players) {
                sender.sendMessage((Component)Component.text((String)("  - " + string), (TextColor)NamedTextColor.WHITE));
            }
        }
        List<String> uuids = this.plugin.getWhitelistManager().getWhitelistedUUIDs();
        sender.sendMessage((Component)Component.text((String)("Whitelisted UUIDs (" + uuids.size() + "):"), (TextColor)NamedTextColor.YELLOW));
        if (uuids.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)"  None", (TextColor)NamedTextColor.GRAY));
        } else {
            for (String uuid : uuids) {
                sender.sendMessage((Component)Component.text((String)("  - " + uuid), (TextColor)NamedTextColor.WHITE));
            }
        }
        List<String> list = this.plugin.getWhitelistManager().getWhitelistedIPs();
        sender.sendMessage((Component)Component.text((String)("Whitelisted IPs (" + list.size() + "):"), (TextColor)NamedTextColor.YELLOW));
        if (list.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)"  None", (TextColor)NamedTextColor.GRAY));
        } else {
            for (String ip : list) {
                sender.sendMessage((Component)Component.text((String)("  - " + ip), (TextColor)NamedTextColor.WHITE));
            }
        }
    }

    private void handleCheck(SimpleCommand.Invocation invocation, String target) {
        String ipToCheck;
        CommandSource sender = invocation.source();
        Player player = this.plugin.getServer().getPlayer(target).orElse(null);
        if (player != null) {
            ipToCheck = player.getRemoteAddress().getAddress().getHostAddress();
            sender.sendMessage((Component)Component.text((String)("Checking IP for player " + player.getUsername() + "..."), (TextColor)NamedTextColor.YELLOW));
        } else {
            ipToCheck = target;
            sender.sendMessage((Component)Component.text((String)("Checking IP " + target + "..."), (TextColor)NamedTextColor.YELLOW));
        }
        this.plugin.getAPI().checkIP(ipToCheck).thenAccept(result -> {
            if (result == null) {
                sender.sendMessage((Component)Component.text((String)"Failed to check IP. API error.", (TextColor)NamedTextColor.RED));
                return;
            }
            sender.sendMessage((Component)Component.text((String)"=== IP Check Results ===", (TextColor)NamedTextColor.GOLD));
            sender.sendMessage((Component)Component.text((String)("IP Address: " + result.getIpAddress()), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("Risk Level: " + result.getRiskLevel()), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("Country: " + result.getCountry()), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("City: " + result.getCity()), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("Company: " + result.getCompany()), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("VPN: " + (result.isVPN() ? "Yes" : "No")), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("Proxy: " + (result.isProxy() ? "Yes" : "No")), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("Datacenter: " + (result.isDatacenter() ? "Yes" : "No")), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("Bogon: " + (result.isBogon() ? "Yes" : "No")), (TextColor)NamedTextColor.YELLOW));
            sender.sendMessage((Component)Component.text((String)("Mobile: " + (result.isMobile() ? "Yes" : "No")), (TextColor)NamedTextColor.YELLOW));
        });
    }

    private void handleStats(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        sender.sendMessage((Component)Component.text((String)"Loading API statistics...", (TextColor)NamedTextColor.YELLOW));
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats == null) {
                sender.sendMessage((Component)Component.text((String)"Failed to fetch API statistics.", (TextColor)NamedTextColor.RED));
                return;
            }
            sender.sendMessage((Component)Component.text((String)"=== API Statistics (Global) ===", (TextColor)NamedTextColor.GOLD));
            sender.sendMessage((Component)Component.text((String)("Plan: " + (String)stats.get("plan")), (TextColor)NamedTextColor.YELLOW));
            if (stats.get("rate_limit") != null && !((String)stats.get("rate_limit")).isEmpty()) {
                sender.sendMessage((Component)Component.text((String)("Rate Limit: " + (String)stats.get("rate_limit") + " req/min"), (TextColor)NamedTextColor.YELLOW));
            }
            if (stats.containsKey("today_total_requests")) {
                sender.sendMessage((Component)Component.text((String)""));
                sender.sendMessage((Component)Component.text((String)"=== Today's Usage ===", (TextColor)NamedTextColor.GOLD));
                sender.sendMessage((Component)Component.text((String)("Total Requests: " + (String)stats.get("today_total_requests")), (TextColor)NamedTextColor.YELLOW));
                sender.sendMessage((Component)Component.text((String)("Cached Hits: " + (String)stats.get("today_cached_hits")), (TextColor)NamedTextColor.YELLOW));
            }
            if (stats.containsKey("total_requests")) {
                sender.sendMessage((Component)Component.text((String)""));
                sender.sendMessage((Component)Component.text((String)"=== All-Time Usage ===", (TextColor)NamedTextColor.GOLD));
                sender.sendMessage((Component)Component.text((String)("Total Requests: " + (String)stats.get("total_requests")), (TextColor)NamedTextColor.YELLOW));
                sender.sendMessage((Component)Component.text((String)("Total Cached Hits: " + (String)stats.get("total_cached_hits")), (TextColor)NamedTextColor.YELLOW));
            }
            sender.sendMessage((Component)Component.text((String)""));
            sender.sendMessage((Component)Component.text((String)"For personalized stats, visit:", (TextColor)NamedTextColor.GRAY));
            sender.sendMessage((Component)Component.text((String)"https://protectcord.com", (TextColor)NamedTextColor.AQUA));
            sender.sendMessage((Component)Component.text((String)"Go to Dashboard > API Keys", (TextColor)NamedTextColor.GRAY));
        });
    }

    private void handleVersion(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        sender.sendMessage((Component)Component.text((String)"=== ProtectCord Version Info ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage((Component)Component.text((String)("Plugin Version: " + this.plugin.getPluginVersion()), (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"Platform: Velocity", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)("Proxy Version: " + this.plugin.getServer().getVersion().getVersion()), (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)("Proxy Name: " + this.plugin.getServer().getVersion().getName()), (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"Loading API version...", (TextColor)NamedTextColor.YELLOW));
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats != null && stats.containsKey("api_version")) {
                sender.sendMessage((Component)Component.text((String)("API Version: " + (String)stats.get("api_version")), (TextColor)NamedTextColor.YELLOW));
            } else {
                sender.sendMessage((Component)Component.text((String)"API Version: Unavailable", (TextColor)NamedTextColor.RED));
            }
        });
    }

    private void handleKick(SimpleCommand.Invocation invocation, String playerName) {
        CommandSource sender = invocation.source();
        Player player = this.plugin.getServer().getPlayer(playerName).orElse(null);
        if (player == null) {
            sender.sendMessage((Component)Component.text((String)"Player not found or not online.", (TextColor)NamedTextColor.RED));
            return;
        }
        String ipAddress = player.getRemoteAddress().getAddress().getHostAddress();
        sender.sendMessage((Component)Component.text((String)("Kicking " + player.getUsername() + " and checking their IP..."), (TextColor)NamedTextColor.YELLOW));
        ((CompletableFuture)this.plugin.getAPI().checkIP(ipAddress).thenAccept(result -> {
            if (result == null) {
                player.disconnect((Component)Component.text((String)"Kicked by Administrator\nYour connection was manually terminated.", (TextColor)NamedTextColor.RED));
                sender.sendMessage((Component)Component.text((String)("Kicked " + player.getUsername() + " (API check failed)"), (TextColor)NamedTextColor.GREEN));
                return;
            }
            BuildableComponent kickMessage = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Kicked by Administrator", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"\n\n"))).append((Component)Component.text((String)"IP Analysis:\n", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"Risk Level: ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)(result.getRiskLevel() + "\n"), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"Country: ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)(result.getCountry() + "\n"), (TextColor)NamedTextColor.WHITE))).build();
            if (result.isVPN() || result.isProxy() || result.isTor() || result.isDatacenter()) {
                TextComponent.Builder builder = Component.text();
                if (result.isVPN()) {
                    builder.append((Component)Component.text((String)"\u2718 VPN Detected\n", (TextColor)NamedTextColor.RED));
                }
                if (result.isProxy()) {
                    builder.append((Component)Component.text((String)"\u2718 Proxy Detected\n", (TextColor)NamedTextColor.RED));
                }
                if (result.isTor()) {
                    builder.append((Component)Component.text((String)"\u2718 Tor Detected\n", (TextColor)NamedTextColor.RED));
                }
                if (result.isDatacenter()) {
                    builder.append((Component)Component.text((String)"\u2718 Datacenter IP\n", (TextColor)NamedTextColor.RED));
                }
                kickMessage = kickMessage.append((Component)builder.build());
            }
            player.disconnect((Component)kickMessage);
            sender.sendMessage((Component)Component.text((String)("Kicked " + player.getUsername()), (TextColor)NamedTextColor.GREEN));
            sender.sendMessage((Component)Component.text((String)("IP: " + result.getIpAddress()), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage((Component)Component.text((String)("Risk: " + result.getRiskLevel()), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage((Component)Component.text((String)("Country: " + result.getCountry()), (TextColor)NamedTextColor.GRAY));
            sender.sendMessage((Component)Component.text((String)("VPN: " + (result.isVPN() ? "Yes" : "No")), (TextColor)(result.isVPN() ? NamedTextColor.RED : NamedTextColor.GREEN)));
            sender.sendMessage((Component)Component.text((String)("Proxy: " + (result.isProxy() ? "Yes" : "No")), (TextColor)(result.isProxy() ? NamedTextColor.RED : NamedTextColor.GREEN)));
            sender.sendMessage((Component)Component.text((String)("Tor: " + (result.isTor() ? "Yes" : "No")), (TextColor)(result.isTor() ? NamedTextColor.RED : NamedTextColor.GREEN)));
        })).exceptionally(ex -> {
            player.disconnect((Component)Component.text((String)"Kicked by Administrator\nYour connection was manually terminated.", (TextColor)NamedTextColor.RED));
            sender.sendMessage((Component)Component.text((String)("Kicked " + player.getUsername() + " (Error checking IP)"), (TextColor)NamedTextColor.GREEN));
            return null;
        });
    }

    private void sendHelp(SimpleCommand.Invocation invocation) {
        CommandSource sender = invocation.source();
        sender.sendMessage((Component)Component.text((String)"=== ProtectCord Commands ===", (TextColor)NamedTextColor.GOLD));
        sender.sendMessage((Component)Component.text((String)"/protectcord reload - Reload configuration", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"/protectcord whitelist add <player|uuid|ip> <value> - Add to whitelist", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"/protectcord whitelist remove <player|uuid|ip> <value> - Remove from whitelist", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"/protectcord list - List whitelisted entries", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"/protectcord check <player|ip> - Check an IP address", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"/protectcord kick <player> - Kick player with IP analysis", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"/protectcord stats - View API statistics", (TextColor)NamedTextColor.YELLOW));
        sender.sendMessage((Component)Component.text((String)"/protectcord version - View version information", (TextColor)NamedTextColor.YELLOW));
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("protectcord.admin");
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0 || args.length == 1) {
            return Arrays.asList("reload", "whitelist", "list", "check", "kick", "stats", "version").stream().filter(s -> args.length == 0 || s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("add", "remove").stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("player", "uuid", "ip").stream().filter(s -> s.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

