/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.spigot.config;

import com.protectcord.spigot.ProtectCordPlugin;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ProtectCordPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getApiKey() {
        return this.config.getString("api-key", "YOUR_API_KEY_HERE");
    }

    public boolean isCheckEnabled() {
        return this.config.getBoolean("enable-ip-check", true);
    }

    public boolean shouldBlockVPN() {
        return this.config.getBoolean("block-vpn", true);
    }

    public boolean shouldBlockProxy() {
        return this.config.getBoolean("block-proxy", true);
    }

    public boolean shouldBlockDatacenter() {
        return this.config.getBoolean("block-datacenter", false);
    }

    public boolean shouldBlockBogon() {
        return this.config.getBoolean("block-bogon", true);
    }

    public boolean shouldBlockTor() {
        return this.config.getBoolean("block-tor", true);
    }

    public boolean isRiskLevelBlockingEnabled() {
        return this.config.getBoolean("enable-risk-level-blocking", false);
    }

    public String getBlockedRiskLevel() {
        return this.config.getString("blocked-risk-level", "HIGH");
    }

    public boolean isGeoBlockingEnabled() {
        return this.config.getBoolean("geo-blocking.enabled", false);
    }

    public String getGeoBlockingMode() {
        return this.config.getString("geo-blocking.mode", "blacklist");
    }

    public List<String> getGeoBlockingCountries() {
        return this.config.getStringList("geo-blocking.countries");
    }

    public String getMessage(String path) {
        return this.config.getString("messages." + path, "").replace("&", "\u00a7");
    }

    public String getWebhookUrl() {
        return this.config.getString("discord-webhook.url", "");
    }

    public boolean isWebhookEnabled() {
        return this.config.getBoolean("discord-webhook.enabled", false);
    }

    public boolean shouldWebhookOnDenied() {
        return this.config.getBoolean("discord-webhook.events.denied", true);
    }

    public boolean shouldWebhookOnAccepted() {
        return this.config.getBoolean("discord-webhook.events.accepted", false);
    }

    public boolean shouldWebhookOnWhitelisted() {
        return this.config.getBoolean("discord-webhook.events.whitelisted", true);
    }

    public boolean shouldWebhookOnError() {
        return this.config.getBoolean("discord-webhook.events.error", true);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

