/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.spigot.whitelist;

import com.protectcord.spigot.ProtectCordPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class WhitelistManager {
    private final ProtectCordPlugin plugin;
    private File whitelistFile;
    private FileConfiguration whitelistConfig;

    public WhitelistManager(ProtectCordPlugin plugin) {
        this.plugin = plugin;
        this.loadWhitelist();
    }

    private void loadWhitelist() {
        this.whitelistFile = new File(this.plugin.getDataFolder(), "whitelist.yml");
        if (!this.whitelistFile.exists()) {
            try {
                this.whitelistFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create whitelist.yml: " + e.getMessage());
            }
        }
        this.whitelistConfig = YamlConfiguration.loadConfiguration((File)this.whitelistFile);
        if (!this.whitelistConfig.contains("whitelisted-players")) {
            this.whitelistConfig.set("whitelisted-players", new ArrayList());
        }
        if (!this.whitelistConfig.contains("whitelisted-uuids")) {
            this.whitelistConfig.set("whitelisted-uuids", new ArrayList());
        }
        if (!this.whitelistConfig.contains("whitelisted-ips")) {
            this.whitelistConfig.set("whitelisted-ips", new ArrayList());
        }
        this.saveWhitelist();
    }

    public void saveWhitelist() {
        try {
            this.whitelistConfig.save(this.whitelistFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save whitelist.yml: " + e.getMessage());
        }
    }

    public void reloadWhitelist() {
        this.whitelistConfig = YamlConfiguration.loadConfiguration((File)this.whitelistFile);
    }

    public boolean isWhitelisted(String playerName, UUID uuid, String ipAddress) {
        List whitelistedPlayers = this.whitelistConfig.getStringList("whitelisted-players");
        List whitelistedUUIDs = this.whitelistConfig.getStringList("whitelisted-uuids");
        List whitelistedIPs = this.whitelistConfig.getStringList("whitelisted-ips");
        return whitelistedPlayers.contains(playerName.toLowerCase()) || whitelistedUUIDs.contains(uuid.toString()) || whitelistedIPs.contains(ipAddress);
    }

    public void addPlayer(String playerName) {
        List whitelistedPlayers = this.whitelistConfig.getStringList("whitelisted-players");
        if (!whitelistedPlayers.contains(playerName.toLowerCase())) {
            whitelistedPlayers.add(playerName.toLowerCase());
            this.whitelistConfig.set("whitelisted-players", (Object)whitelistedPlayers);
            this.saveWhitelist();
        }
    }

    public void removePlayer(String playerName) {
        List whitelistedPlayers = this.whitelistConfig.getStringList("whitelisted-players");
        whitelistedPlayers.remove(playerName.toLowerCase());
        this.whitelistConfig.set("whitelisted-players", (Object)whitelistedPlayers);
        this.saveWhitelist();
    }

    public void addUUID(UUID uuid) {
        List whitelistedUUIDs = this.whitelistConfig.getStringList("whitelisted-uuids");
        if (!whitelistedUUIDs.contains(uuid.toString())) {
            whitelistedUUIDs.add(uuid.toString());
            this.whitelistConfig.set("whitelisted-uuids", (Object)whitelistedUUIDs);
            this.saveWhitelist();
        }
    }

    public void removeUUID(UUID uuid) {
        List whitelistedUUIDs = this.whitelistConfig.getStringList("whitelisted-uuids");
        whitelistedUUIDs.remove(uuid.toString());
        this.whitelistConfig.set("whitelisted-uuids", (Object)whitelistedUUIDs);
        this.saveWhitelist();
    }

    public void addIP(String ipAddress) {
        List whitelistedIPs = this.whitelistConfig.getStringList("whitelisted-ips");
        if (!whitelistedIPs.contains(ipAddress)) {
            whitelistedIPs.add(ipAddress);
            this.whitelistConfig.set("whitelisted-ips", (Object)whitelistedIPs);
            this.saveWhitelist();
        }
    }

    public void removeIP(String ipAddress) {
        List whitelistedIPs = this.whitelistConfig.getStringList("whitelisted-ips");
        whitelistedIPs.remove(ipAddress);
        this.whitelistConfig.set("whitelisted-ips", (Object)whitelistedIPs);
        this.saveWhitelist();
    }

    public List<String> getWhitelistedPlayers() {
        return this.whitelistConfig.getStringList("whitelisted-players");
    }

    public List<String> getWhitelistedUUIDs() {
        return this.whitelistConfig.getStringList("whitelisted-uuids");
    }

    public List<String> getWhitelistedIPs() {
        return this.whitelistConfig.getStringList("whitelisted-ips");
    }
}

