/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigManager {
    private CommentedFileConfig config;
    private Path configPath = FMLPaths.CONFIGDIR.get().resolve("protectcord.toml");

    public void loadConfig() {
        this.config = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        this.config.load();
        if (!this.config.contains("api-key")) {
            this.config.set("api-key", (Object)"YOUR_API_KEY_HERE");
            this.config.setComment("api-key", "Your ProtectCord API key from https://protectcord.com");
        }
        if (!this.config.contains("enable-ip-check")) {
            this.config.set("enable-ip-check", (Object)true);
        }
        if (!this.config.contains("block-vpn")) {
            this.config.set("block-vpn", (Object)true);
        }
        if (!this.config.contains("block-proxy")) {
            this.config.set("block-proxy", (Object)true);
        }
        if (!this.config.contains("block-datacenter")) {
            this.config.set("block-datacenter", (Object)false);
        }
        if (!this.config.contains("block-bogon")) {
            this.config.set("block-bogon", (Object)true);
        }
        if (!this.config.contains("block-tor")) {
            this.config.set("block-tor", (Object)true);
        }
        if (!this.config.contains("enable-risk-level-blocking")) {
            this.config.set("enable-risk-level-blocking", (Object)false);
        }
        if (!this.config.contains("blocked-risk-level")) {
            this.config.set("blocked-risk-level", (Object)"HIGH");
        }
        if (!this.config.contains("geo-blocking.enabled")) {
            this.config.set("geo-blocking.enabled", (Object)false);
        }
        if (!this.config.contains("geo-blocking.mode")) {
            this.config.set("geo-blocking.mode", (Object)"blacklist");
        }
        if (!this.config.contains("geo-blocking.countries")) {
            this.config.set("geo-blocking.countries", Arrays.asList("CN", "RU"));
        }
        if (!this.config.contains("messages.connection-denied")) {
            this.config.set("messages.connection-denied", (Object)"\u00a7c\u00a7lConnection Denied\n\u00a77Reason: {reason}\n\u00a77Risk Level: {risk}");
        }
        if (!this.config.contains("messages.api-error")) {
            this.config.set("messages.api-error", (Object)"\u00a7c\u00a7lConnection Error\n\u00a77Please try again later.");
        }
        if (!this.config.contains("discord-webhook.enabled")) {
            this.config.set("discord-webhook.enabled", (Object)false);
        }
        if (!this.config.contains("discord-webhook.url")) {
            this.config.set("discord-webhook.url", (Object)"");
        }
        if (!this.config.contains("discord-webhook.events.denied")) {
            this.config.set("discord-webhook.events.denied", (Object)true);
        }
        if (!this.config.contains("discord-webhook.events.accepted")) {
            this.config.set("discord-webhook.events.accepted", (Object)false);
        }
        if (!this.config.contains("discord-webhook.events.whitelisted")) {
            this.config.set("discord-webhook.events.whitelisted", (Object)true);
        }
        if (!this.config.contains("discord-webhook.events.error")) {
            this.config.set("discord-webhook.events.error", (Object)true);
        }
        this.config.save();
    }

    public void reloadConfig() {
        if (this.config != null) {
            this.config.load();
        }
    }

    public String getApiKey() {
        return (String)this.config.get("api-key");
    }

    public boolean isCheckEnabled() {
        return (Boolean)this.config.getOrElse("enable-ip-check", (Object)true);
    }

    public boolean shouldBlockVPN() {
        return (Boolean)this.config.getOrElse("block-vpn", (Object)true);
    }

    public boolean shouldBlockProxy() {
        return (Boolean)this.config.getOrElse("block-proxy", (Object)true);
    }

    public boolean shouldBlockDatacenter() {
        return (Boolean)this.config.getOrElse("block-datacenter", (Object)false);
    }

    public boolean shouldBlockBogon() {
        return (Boolean)this.config.getOrElse("block-bogon", (Object)true);
    }

    public boolean shouldBlockTor() {
        return (Boolean)this.config.getOrElse("block-tor", (Object)true);
    }

    public boolean isRiskLevelBlockingEnabled() {
        return (Boolean)this.config.getOrElse("enable-risk-level-blocking", (Object)false);
    }

    public String getBlockedRiskLevel() {
        return (String)this.config.getOrElse("blocked-risk-level", (Object)"HIGH");
    }

    public boolean isGeoBlockingEnabled() {
        return (Boolean)this.config.getOrElse("geo-blocking.enabled", (Object)false);
    }

    public String getGeoBlockingMode() {
        return (String)this.config.getOrElse("geo-blocking.mode", (Object)"blacklist");
    }

    public List<String> getGeoBlockingCountries() {
        return (List)this.config.getOrElse("geo-blocking.countries", Arrays.asList("CN", "RU"));
    }

    public String getMessage(String path) {
        String message = (String)this.config.getOrElse("messages." + path, (Object)"");
        return message.replace("&", "\u00a7");
    }

    public String getWebhookUrl() {
        return (String)this.config.getOrElse("discord-webhook.url", (Object)"");
    }

    public boolean isWebhookEnabled() {
        return (Boolean)this.config.getOrElse("discord-webhook.enabled", (Object)false);
    }

    public boolean shouldWebhookOnDenied() {
        return (Boolean)this.config.getOrElse("discord-webhook.events.denied", (Object)true);
    }

    public boolean shouldWebhookOnAccepted() {
        return (Boolean)this.config.getOrElse("discord-webhook.events.accepted", (Object)false);
    }

    public boolean shouldWebhookOnWhitelisted() {
        return (Boolean)this.config.getOrElse("discord-webhook.events.whitelisted", (Object)true);
    }

    public boolean shouldWebhookOnError() {
        return (Boolean)this.config.getOrElse("discord-webhook.events.error", (Object)true);
    }
}

