/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.velocity.warn;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class WarnManager {
    private final Path dataDirectory;
    private File warningsFile;
    private Map<String, Object> warningsData;

    public WarnManager(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.loadWarnings();
    }

    private void loadWarnings() {
        this.warningsFile = this.dataDirectory.resolve("warnings.toml").toFile();
        if (!this.warningsFile.exists()) {
            try {
                this.warningsFile.getParentFile().mkdirs();
                this.warningsFile.createNewFile();
                this.warningsData = new HashMap<String, Object>();
                this.warningsData.put("players", new HashMap());
                this.saveWarnings();
            }
            catch (IOException e) {
                System.err.println("Could not create warnings.toml: " + e.getMessage());
                this.warningsData = new HashMap<String, Object>();
                this.warningsData.put("players", new HashMap());
            }
        } else {
            Toml toml = new Toml().read(this.warningsFile);
            this.warningsData = toml.toMap();
            if (!this.warningsData.containsKey("players")) {
                this.warningsData.put("players", new HashMap());
                this.saveWarnings();
            }
        }
    }

    public void saveWarnings() {
        try {
            TomlWriter writer = new TomlWriter();
            writer.write(this.warningsData, this.warningsFile);
        }
        catch (IOException e) {
            System.err.println("Could not save warnings.toml: " + e.getMessage());
        }
    }

    public void reloadWarnings() {
        this.loadWarnings();
    }

    public void addWarning(UUID playerUUID, String reason, String issuer) {
        List warnings;
        Map playerData;
        String uuidStr;
        Map players = (Map)this.warningsData.get("players");
        if (players.containsKey(uuidStr = playerUUID.toString())) {
            playerData = (Map)players.get(uuidStr);
        } else {
            playerData = new HashMap();
            players.put(uuidStr, playerData);
        }
        if (playerData.containsKey("warnings")) {
            warnings = (List)playerData.get("warnings");
        } else {
            warnings = new ArrayList();
            playerData.put("warnings", warnings);
        }
        HashMap<String, Object> warning = new HashMap<String, Object>();
        warning.put("timestamp", System.currentTimeMillis());
        warning.put("reason", reason);
        warning.put("issuer", issuer);
        warnings.add(warning);
        this.saveWarnings();
    }

    public List<Map<String, Object>> getWarningsList(UUID playerUUID) {
        String uuidStr;
        Map players = (Map)this.warningsData.get("players");
        if (!players.containsKey(uuidStr = playerUUID.toString())) {
            return new ArrayList<Map<String, Object>>();
        }
        Map playerData = (Map)players.get(uuidStr);
        if (!playerData.containsKey("warnings")) {
            return new ArrayList<Map<String, Object>>();
        }
        return (List)playerData.get("warnings");
    }

    public int getWarningCount(UUID playerUUID) {
        return this.getWarningsList(playerUUID).size();
    }

    public boolean isBanned(UUID playerUUID) {
        String uuidStr;
        Map players = (Map)this.warningsData.get("players");
        if (!players.containsKey(uuidStr = playerUUID.toString())) {
            return false;
        }
        Map playerData = (Map)players.get(uuidStr);
        if (!playerData.containsKey("ban")) {
            return false;
        }
        Map banData = (Map)playerData.get("ban");
        return banData.containsKey("banned") && (Boolean)banData.get("banned") != false;
    }

    public void banPlayer(UUID playerUUID, List<String> reasons) {
        Map playerData;
        String uuidStr;
        Map players = (Map)this.warningsData.get("players");
        if (players.containsKey(uuidStr = playerUUID.toString())) {
            playerData = (Map)players.get(uuidStr);
        } else {
            playerData = new HashMap();
            players.put(uuidStr, playerData);
        }
        HashMap<String, Object> banData = new HashMap<String, Object>();
        banData.put("banned", true);
        banData.put("timestamp", System.currentTimeMillis());
        banData.put("reasons", reasons);
        playerData.put("ban", banData);
        this.saveWarnings();
    }

    public void unbanPlayer(UUID playerUUID) {
        String uuidStr;
        Map players = (Map)this.warningsData.get("players");
        if (!players.containsKey(uuidStr = playerUUID.toString())) {
            return;
        }
        Map playerData = (Map)players.get(uuidStr);
        if (playerData.containsKey("ban")) {
            Map banData = (Map)playerData.get("ban");
            banData.put("banned", false);
            this.saveWarnings();
        }
    }

    public List<String> getBanReasons(UUID playerUUID) {
        String uuidStr;
        Map players = (Map)this.warningsData.get("players");
        if (!players.containsKey(uuidStr = playerUUID.toString())) {
            return new ArrayList<String>();
        }
        Map playerData = (Map)players.get(uuidStr);
        if (!playerData.containsKey("ban")) {
            return new ArrayList<String>();
        }
        Map banData = (Map)playerData.get("ban");
        if (!banData.containsKey("reasons")) {
            return new ArrayList<String>();
        }
        return (List)banData.get("reasons");
    }

    public void clearWarnings(UUID playerUUID) {
        Map players = (Map)this.warningsData.get("players");
        String uuidStr = playerUUID.toString();
        players.remove(uuidStr);
        this.saveWarnings();
    }

    public Map<String, Object> getPlayerData(UUID playerUUID) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("warnings", this.getWarningsList(playerUUID));
        data.put("warningCount", this.getWarningCount(playerUUID));
        data.put("banned", this.isBanned(playerUUID));
        data.put("banReasons", this.getBanReasons(playerUUID));
        return data;
    }
}

