/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.velocity.config;

import com.moandjiezana.toml.Toml;
import com.protectcord.velocity.ProtectCordPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;

public class ConfigManager {
    private final ProtectCordPlugin plugin;
    private Toml config;
    private File configFile;

    public ConfigManager(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        File dataFolder = this.plugin.getDataDirectory().toFile();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        this.configFile = new File(dataFolder, "config.toml");
        if (!this.configFile.exists()) {
            try (InputStream in = this.getClass().getResourceAsStream("/config.toml");){
                if (in != null) {
                    Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().error("Could not create config.toml: " + e.getMessage());
            }
        }
        try {
            this.config = new Toml().read(this.configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Could not load config.toml: " + e.getMessage());
        }
    }

    public void reloadConfig() {
        try {
            this.config = new Toml().read(this.configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().error("Could not reload config.toml: " + e.getMessage());
        }
    }

    public String getApiKey() {
        return this.config.getString("api-key", "YOUR_API_KEY_HERE");
    }

    public boolean isCheckEnabled() {
        return this.config.getBoolean("enable-ip-check", true);
    }

    public boolean shouldBlockVPN() {
        return this.config.getBoolean("block-vpn", true);
    }

    public boolean shouldBlockProxy() {
        return this.config.getBoolean("block-proxy", true);
    }

    public boolean shouldBlockDatacenter() {
        return this.config.getBoolean("block-datacenter", false);
    }

    public boolean shouldBlockBogon() {
        return this.config.getBoolean("block-bogon", true);
    }

    public boolean shouldBlockTor() {
        return this.config.getBoolean("block-tor", true);
    }

    public boolean isRiskLevelBlockingEnabled() {
        return this.config.getBoolean("enable-risk-level-blocking", false);
    }

    public String getBlockedRiskLevel() {
        return this.config.getString("blocked-risk-level", "HIGH");
    }

    public boolean isGeoBlockingEnabled() {
        return this.config.getBoolean("geo-blocking.enabled", false);
    }

    public String getGeoBlockingMode() {
        return this.config.getString("geo-blocking.mode", "blacklist");
    }

    public List<String> getGeoBlockingCountries() {
        return this.config.getList("geo-blocking.countries", Collections.emptyList());
    }

    public String getMessage(String path) {
        String message = this.config.getString("messages." + path, "");
        return message.replace("&", "\u00a7");
    }

    public String getWebhookUrl() {
        return this.config.getString("discord-webhook.url", "");
    }

    public boolean isWebhookEnabled() {
        return this.config.getBoolean("discord-webhook.enabled", false);
    }

    public boolean shouldWebhookOnDenied() {
        return this.config.getBoolean("discord-webhook.events.denied", true);
    }

    public boolean shouldWebhookOnAccepted() {
        return this.config.getBoolean("discord-webhook.events.accepted", false);
    }

    public boolean shouldWebhookOnWhitelisted() {
        return this.config.getBoolean("discord-webhook.events.whitelisted", true);
    }

    public boolean shouldWebhookOnError() {
        return this.config.getBoolean("discord-webhook.events.error", true);
    }
}

