/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.bungee.webhook;

import com.protectcord.bungee.ProtectCordPlugin;
import com.protectcord.bungee.api.IPCheckResult;
import com.protectcord.bungee.gson.JsonArray;
import com.protectcord.bungee.gson.JsonObject;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

public class WebhookManager {
    private final ProtectCordPlugin plugin;

    public WebhookManager(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    public void sendDeniedWebhook(String playerName, String uuid, String ipAddress, IPCheckResult result) {
        if (!this.plugin.getConfigManager().isWebhookEnabled() || !this.plugin.getConfigManager().shouldWebhookOnDenied()) {
            return;
        }
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "\u274c Connection Denied");
        embed.addProperty("color", 15158332);
        StringBuilder description = new StringBuilder();
        description.append("**Player:** ").append(playerName).append("\n");
        description.append("**UUID:** ").append(uuid).append("\n");
        description.append("**IP Address:** ").append(ipAddress).append("\n");
        description.append("**Risk Level:** ").append(result.getRiskLevel()).append("\n");
        description.append("**Country:** ").append(result.getCountry()).append("\n");
        description.append("**City:** ").append(result.getCity()).append("\n");
        description.append("**VPN:** ").append(result.isVPN() ? "Yes" : "No").append("\n");
        description.append("**Proxy:** ").append(result.isProxy() ? "Yes" : "No").append("\n");
        description.append("**Datacenter:** ").append(result.isDatacenter() ? "Yes" : "No").append("\n");
        embed.addProperty("description", description.toString());
        embed.addProperty("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
        this.sendWebhook(embed);
    }

    public void sendAcceptedWebhook(String playerName, String uuid, String ipAddress, IPCheckResult result) {
        if (!this.plugin.getConfigManager().isWebhookEnabled() || !this.plugin.getConfigManager().shouldWebhookOnAccepted()) {
            return;
        }
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "\u2705 Connection Accepted");
        embed.addProperty("color", 3066993);
        StringBuilder description = new StringBuilder();
        description.append("**Player:** ").append(playerName).append("\n");
        description.append("**UUID:** ").append(uuid).append("\n");
        description.append("**IP Address:** ").append(ipAddress).append("\n");
        description.append("**Risk Level:** ").append(result.getRiskLevel()).append("\n");
        description.append("**Country:** ").append(result.getCountry()).append("\n");
        embed.addProperty("description", description.toString());
        embed.addProperty("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
        this.sendWebhook(embed);
    }

    public void sendWhitelistedWebhook(String playerName, String uuid, String ipAddress) {
        if (!this.plugin.getConfigManager().isWebhookEnabled() || !this.plugin.getConfigManager().shouldWebhookOnWhitelisted()) {
            return;
        }
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "\u26aa Whitelisted Player Joined");
        embed.addProperty("color", 0xFFFF00);
        StringBuilder description = new StringBuilder();
        description.append("**Player:** ").append(playerName).append("\n");
        description.append("**UUID:** ").append(uuid).append("\n");
        description.append("**IP Address:** ").append(ipAddress).append("\n");
        description.append("**Status:** IP check bypassed (whitelisted)");
        embed.addProperty("description", description.toString());
        embed.addProperty("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
        this.sendWebhook(embed);
    }

    public void sendErrorWebhook(String playerName, String uuid, String ipAddress, String error) {
        if (!this.plugin.getConfigManager().isWebhookEnabled() || !this.plugin.getConfigManager().shouldWebhookOnError()) {
            return;
        }
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "\u26a0\ufe0f API Error");
        embed.addProperty("color", 15105570);
        StringBuilder description = new StringBuilder();
        description.append("**Player:** ").append(playerName).append("\n");
        description.append("**UUID:** ").append(uuid).append("\n");
        description.append("**IP Address:** ").append(ipAddress).append("\n");
        description.append("**Error:** ").append(error);
        embed.addProperty("description", description.toString());
        embed.addProperty("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date()));
        this.sendWebhook(embed);
    }

    private void sendWebhook(JsonObject embed) {
        CompletableFuture.runAsync(() -> {
            try {
                String webhookUrl = this.plugin.getConfigManager().getWebhookUrl();
                if (webhookUrl == null || webhookUrl.isEmpty()) {
                    return;
                }
                JsonObject payload = new JsonObject();
                JsonArray embeds = new JsonArray();
                embeds.add(embed);
                payload.add("embeds", embeds);
                URL url = new URL(webhookUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoOutput(true);
                try (OutputStream os = conn.getOutputStream();){
                    byte[] input = payload.toString().getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = conn.getResponseCode();
                if (responseCode < 200 || responseCode >= 300) {
                    this.plugin.getLogger().warning("Discord webhook returned status code: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
            }
        });
    }
}

