/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.bungee.update;

import com.protectcord.bungee.gson.Gson;
import com.protectcord.bungee.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import net.md_5.bungee.api.plugin.Plugin;

public class UpdateChecker {
    private static final String UPDATE_URL = "https://api.protectcord.com/plugin-version";
    private static final String CURRENT_VERSION = "1.0.0";
    private static final String PLATFORM = "bungeecord";
    private final Plugin plugin;
    private final Gson gson;
    private static final Logger logger = Logger.getLogger("ProtectCord");

    public UpdateChecker(Plugin plugin) {
        this.plugin = plugin;
        this.gson = new Gson();
    }

    public CompletableFuture<UpdateInfo> checkForUpdates() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL(UPDATE_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                conn.setRequestProperty("User-Agent", "ProtectCord-BungeeCord/1.0.0");
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    JsonObject json = this.gson.fromJson(response.toString(), JsonObject.class);
                    JsonObject versions = json.getAsJsonObject("versions");
                    String latestVersion = versions.get(PLATFORM).getAsString();
                    String downloadUrl = json.get("download_url").getAsString();
                    String updateMessage = json.get("update_message").getAsString();
                    boolean updateAvailable = !latestVersion.equals(CURRENT_VERSION);
                    return new UpdateInfo(latestVersion, CURRENT_VERSION, updateAvailable, downloadUrl, updateMessage);
                }
            }
            catch (Exception e) {
                logger.warning("Failed to check for updates: " + e.getMessage());
            }
            return null;
        });
    }

    public void notifyUpdate(UpdateInfo updateInfo) {
        if (updateInfo != null && updateInfo.isUpdateAvailable()) {
            logger.info("========================================");
            logger.info("ProtectCord Update Available!");
            logger.info("Current Version: " + updateInfo.getCurrentVersion());
            logger.info("Latest Version: " + updateInfo.getLatestVersion());
            logger.info("Download: " + updateInfo.getDownloadUrl());
            logger.info("========================================");
        }
    }

    public static class UpdateInfo {
        private final String latestVersion;
        private final String currentVersion;
        private final boolean updateAvailable;
        private final String downloadUrl;
        private final String updateMessage;

        public UpdateInfo(String latestVersion, String currentVersion, boolean updateAvailable, String downloadUrl, String updateMessage) {
            this.latestVersion = latestVersion;
            this.currentVersion = currentVersion;
            this.updateAvailable = updateAvailable;
            this.downloadUrl = downloadUrl;
            this.updateMessage = updateMessage;
        }

        public String getLatestVersion() {
            return this.latestVersion;
        }

        public String getCurrentVersion() {
            return this.currentVersion;
        }

        public boolean isUpdateAvailable() {
            return this.updateAvailable;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getUpdateMessage() {
            return this.updateMessage;
        }
    }
}

