/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.folia.command;

import com.protectcord.folia.ProtectCordPlugin;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ProtectCordCommand
implements CommandExecutor,
TabCompleter {
    private final ProtectCordPlugin plugin;

    public ProtectCordCommand(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("protectcord.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getWhitelistManager().reloadWhitelist();
                this.plugin.getWarnManager().reloadWarnings();
                sender.sendMessage("\u00a7aProtectCord configuration reloaded!");
                break;
            }
            case "whitelist": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /protectcord whitelist <add|remove> <player|uuid|ip> <value>");
                    return true;
                }
                this.handleWhitelist(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "check": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /protectcord check <player|ip>");
                    return true;
                }
                this.handleCheck(sender, args[1]);
                break;
            }
            case "stats": {
                this.handleStats(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            case "kick": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /protectcord kick <player>");
                    return true;
                }
                this.handleKick(sender, args[1]);
                break;
            }
            case "warn": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /protectcord warn <player> <reason>");
                    return true;
                }
                this.handleWarn(sender, args);
                break;
            }
            case "warnings": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /protectcord warnings <player>");
                    return true;
                }
                this.handleWarnings(sender, args[1]);
                break;
            }
            case "ban": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /protectcord ban <player> <reason>");
                    return true;
                }
                this.handleBan(sender, args);
                break;
            }
            case "unban": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /protectcord unban <player>");
                    return true;
                }
                this.handleUnban(sender, args[1]);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleWhitelist(CommandSender sender, String[] args) {
        String action = args[1].toLowerCase();
        String type = args[2].toLowerCase();
        if (args.length < 4) {
            sender.sendMessage("\u00a7cPlease specify a value.");
            return;
        }
        String value = args[3];
        block6 : switch (action) {
            case "add": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().addPlayer(value);
                        sender.sendMessage("\u00a7aAdded player \u00a7f" + value + " \u00a7ato whitelist.");
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().addUUID(uuid);
                            sender.sendMessage("\u00a7aAdded UUID \u00a7f" + value + " \u00a7ato whitelist.");
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage("\u00a7cInvalid UUID format.");
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().addIP(value);
                        sender.sendMessage("\u00a7aAdded IP \u00a7f" + value + " \u00a7ato whitelist.");
                        break block6;
                    }
                }
                sender.sendMessage("\u00a7cInvalid type. Use: player, uuid, or ip");
                break;
            }
            case "remove": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().removePlayer(value);
                        sender.sendMessage("\u00a7aRemoved player \u00a7f" + value + " \u00a7afrom whitelist.");
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().removeUUID(uuid);
                            sender.sendMessage("\u00a7aRemoved UUID \u00a7f" + value + " \u00a7afrom whitelist.");
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage("\u00a7cInvalid UUID format.");
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().removeIP(value);
                        sender.sendMessage("\u00a7aRemoved IP \u00a7f" + value + " \u00a7afrom whitelist.");
                        break block6;
                    }
                }
                sender.sendMessage("\u00a7cInvalid type. Use: player, uuid, or ip");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cInvalid action. Use: add or remove");
            }
        }
    }

    private void handleList(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== ProtectCord Whitelist ===");
        List<String> players = this.plugin.getWhitelistManager().getWhitelistedPlayers();
        sender.sendMessage("\u00a7eWhitelisted Players \u00a77(" + players.size() + ")\u00a7e:");
        if (players.isEmpty()) {
            sender.sendMessage("  \u00a77None");
        } else {
            for (String string : players) {
                sender.sendMessage("  \u00a7f- " + string);
            }
        }
        List<String> uuids = this.plugin.getWhitelistManager().getWhitelistedUUIDs();
        sender.sendMessage("\u00a7eWhitelisted UUIDs \u00a77(" + uuids.size() + ")\u00a7e:");
        if (uuids.isEmpty()) {
            sender.sendMessage("  \u00a77None");
        } else {
            for (String uuid : uuids) {
                sender.sendMessage("  \u00a7f- " + uuid);
            }
        }
        List<String> list = this.plugin.getWhitelistManager().getWhitelistedIPs();
        sender.sendMessage("\u00a7eWhitelisted IPs \u00a77(" + list.size() + ")\u00a7e:");
        if (list.isEmpty()) {
            sender.sendMessage("  \u00a77None");
        } else {
            for (String ip : list) {
                sender.sendMessage("  \u00a7f- " + ip);
            }
        }
    }

    private void handleCheck(CommandSender sender, String target) {
        String ipToCheck;
        Player player = Bukkit.getPlayer((String)target);
        if (player != null) {
            ipToCheck = player.getAddress().getAddress().getHostAddress();
            sender.sendMessage("\u00a7eChecking IP for player \u00a7f" + player.getName() + "\u00a7e...");
        } else {
            ipToCheck = target;
            sender.sendMessage("\u00a7eChecking IP \u00a7f" + target + "\u00a7e...");
        }
        this.plugin.getAPI().checkIP(ipToCheck).thenAccept(result -> {
            if (result == null) {
                sender.sendMessage("\u00a7cFailed to check IP. API error.");
                return;
            }
            sender.sendMessage("\u00a76\u00a7l=== IP Check Results ===");
            sender.sendMessage("\u00a7eIP Address: \u00a7f" + result.getIpAddress());
            sender.sendMessage("\u00a7eRisk Level: \u00a7f" + result.getRiskLevel());
            sender.sendMessage("\u00a7eCountry: \u00a7f" + result.getCountry());
            sender.sendMessage("\u00a7eCity: \u00a7f" + result.getCity());
            sender.sendMessage("\u00a7eCompany: \u00a7f" + result.getCompany());
            sender.sendMessage("\u00a7eVPN: \u00a7f" + (result.isVPN() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eProxy: \u00a7f" + (result.isProxy() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eDatacenter: \u00a7f" + (result.isDatacenter() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eBogon: \u00a7f" + (result.isBogon() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eMobile: \u00a7f" + (result.isMobile() ? "Yes" : "No"));
        });
    }

    private void handleStats(CommandSender sender) {
        sender.sendMessage("\u00a7eLoading API statistics...");
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats == null) {
                sender.sendMessage("\u00a7cFailed to fetch API statistics.");
                return;
            }
            sender.sendMessage("\u00a76\u00a7l=== API Statistics (Global) ===");
            sender.sendMessage("\u00a7ePlan: \u00a7f" + (String)stats.get("plan"));
            if (stats.get("rate_limit") != null && !((String)stats.get("rate_limit")).isEmpty()) {
                sender.sendMessage("\u00a7eRate Limit: \u00a7f" + (String)stats.get("rate_limit") + " req/min");
            }
            if (stats.containsKey("today_total_requests")) {
                sender.sendMessage("");
                sender.sendMessage("\u00a76\u00a7l=== Today's Usage ===");
                sender.sendMessage("\u00a7eTotal Requests: \u00a7f" + (String)stats.get("today_total_requests"));
                sender.sendMessage("\u00a7eCached Hits: \u00a7f" + (String)stats.get("today_cached_hits"));
            }
            if (stats.containsKey("total_requests")) {
                sender.sendMessage("");
                sender.sendMessage("\u00a76\u00a7l=== All-Time Usage ===");
                sender.sendMessage("\u00a7eTotal Requests: \u00a7f" + (String)stats.get("total_requests"));
                sender.sendMessage("\u00a7eTotal Cached Hits: \u00a7f" + (String)stats.get("total_cached_hits"));
            }
            sender.sendMessage("");
            sender.sendMessage("\u00a77For personalized stats, visit:");
            sender.sendMessage("\u00a7b\u00a7nhttps://protectcord.com");
            sender.sendMessage("\u00a77Go to Dashboard > API Keys");
        });
    }

    private void handleVersion(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== ProtectCord Version Info ===");
        sender.sendMessage("\u00a7ePlugin Version: \u00a7f" + this.plugin.getDescription().getVersion());
        sender.sendMessage("\u00a7ePlatform: \u00a7fFolia");
        sender.sendMessage("\u00a7eServer Version: \u00a7f" + Bukkit.getVersion());
        sender.sendMessage("\u00a7eMinecraft Version: \u00a7f" + Bukkit.getBukkitVersion());
        sender.sendMessage("\u00a7eLoading API version...");
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats != null && stats.containsKey("api_version")) {
                sender.sendMessage("\u00a7eAPI Version: \u00a7f" + (String)stats.get("api_version"));
            } else {
                sender.sendMessage("\u00a7eAPI Version: \u00a7cUnavailable");
            }
        });
    }

    private void handleKick(CommandSender sender, String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            sender.sendMessage("\u00a7cPlayer not found or not online.");
            return;
        }
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        sender.sendMessage("\u00a7eKicking \u00a7f" + player.getName() + " \u00a7eand checking their IP...");
        ((CompletableFuture)this.plugin.getAPI().checkIP(ipAddress).thenAccept(result -> {
            if (result == null) {
                player.kick((Component)Component.text((String)"\u00a7c\u00a7lKicked by Administrator\n\u00a77Your connection was manually terminated."));
                sender.sendMessage("\u00a7aKicked \u00a7f" + player.getName() + " \u00a77(API check failed)");
                return;
            }
            StringBuilder kickMessage = new StringBuilder();
            kickMessage.append("\u00a7c\u00a7lKicked by Administrator\n\n");
            kickMessage.append("\u00a77IP Analysis:\n");
            kickMessage.append("\u00a7eRisk Level: \u00a7f").append(result.getRiskLevel()).append("\n");
            kickMessage.append("\u00a7eCountry: \u00a7f").append(result.getCountry()).append("\n");
            if (result.isVPN()) {
                kickMessage.append("\u00a7c\u2718 VPN Detected\n");
            }
            if (result.isProxy()) {
                kickMessage.append("\u00a7c\u2718 Proxy Detected\n");
            }
            if (result.isTor()) {
                kickMessage.append("\u00a7c\u2718 Tor Detected\n");
            }
            if (result.isDatacenter()) {
                kickMessage.append("\u00a7c\u2718 Datacenter IP\n");
            }
            player.kick((Component)Component.text((String)kickMessage.toString()));
            sender.sendMessage("\u00a7a\u00a7lKicked \u00a7f" + player.getName());
            sender.sendMessage("\u00a77IP: \u00a7f" + result.getIpAddress());
            sender.sendMessage("\u00a77Risk: \u00a7f" + result.getRiskLevel());
            sender.sendMessage("\u00a77Country: \u00a7f" + result.getCountry());
            sender.sendMessage("\u00a77VPN: \u00a7f" + (result.isVPN() ? "\u00a7cYes" : "\u00a7aNo"));
            sender.sendMessage("\u00a77Proxy: \u00a7f" + (result.isProxy() ? "\u00a7cYes" : "\u00a7aNo"));
            sender.sendMessage("\u00a77Tor: \u00a7f" + (result.isTor() ? "\u00a7cYes" : "\u00a7aNo"));
        })).exceptionally(ex -> {
            player.kick((Component)Component.text((String)"\u00a7c\u00a7lKicked by Administrator\n\u00a77Your connection was manually terminated."));
            sender.sendMessage("\u00a7aKicked \u00a7f" + player.getName() + " \u00a77(Error checking IP)");
            return null;
        });
    }

    private void handleWarn(CommandSender sender, String[] args) {
        String playerName = args[1];
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found or not online.");
            return;
        }
        UUID targetUUID = target.getUniqueId();
        String issuer = sender instanceof Player ? sender.getName() : "Console";
        this.plugin.getWarnManager().addWarning(targetUUID, reason, issuer);
        int warningCount = this.plugin.getWarnManager().getWarningCount(targetUUID);
        sender.sendMessage("\u00a7aWarned \u00a7f" + target.getName() + " \u00a7afor: \u00a7f" + reason);
        sender.sendMessage("\u00a77Warning count: \u00a7f" + warningCount + "/3");
        if (warningCount == 1) {
            target.sendMessage("\u00a7c\u00a7l[WARNING]");
            target.sendMessage("\u00a7eYou have been warned by " + issuer);
            target.sendMessage("\u00a7eReason: \u00a7f" + reason);
            target.sendMessage("\u00a7cPlease behave or further action will be taken.");
            target.sendMessage("\u00a77Warning: 1/3");
        } else if (warningCount == 2) {
            StringBuilder kickMessage = new StringBuilder();
            kickMessage.append("\u00a7c\u00a7l[FINAL WARNING - KICKED]\n\n");
            kickMessage.append("\u00a7eYou have been kicked by ").append(issuer).append("\n");
            kickMessage.append("\u00a7eReason: \u00a7f").append(reason).append("\n\n");
            kickMessage.append("\u00a7c\u00a7lYou have ONE more chance!\n");
            kickMessage.append("\u00a7cOne more warning and you will be \u00a74\u00a7lPERMANENTLY BANNED\u00a7c!\n\n");
            kickMessage.append("\u00a77Warnings: 2/3");
            target.kick((Component)Component.text((String)kickMessage.toString()));
            sender.sendMessage("\u00a7e" + target.getName() + " has been kicked (2nd warning)");
        } else if (warningCount >= 3) {
            List<Map<String, Object>> warnings = this.plugin.getWarnManager().getWarningsList(targetUUID);
            List<String> reasons = warnings.stream().map(w -> (String)w.get("reason")).collect(Collectors.toList());
            this.plugin.getWarnManager().banPlayer(targetUUID, reasons);
            StringBuilder banMessage = new StringBuilder();
            banMessage.append("\u00a74\u00a7l[PERMANENTLY BANNED]\n\n");
            banMessage.append("\u00a7cYou have been banned for receiving 3 warnings.\n\n");
            banMessage.append("\u00a7e\u00a7lYour warnings:\n");
            for (int i = 0; i < warnings.size(); ++i) {
                Map<String, Object> warning = warnings.get(i);
                banMessage.append("\u00a77").append(i + 1).append(". \u00a7f").append(warning.get("reason")).append("\n");
            }
            banMessage.append("\n\u00a77This ban is permanent and cannot be appealed automatically.");
            target.kick((Component)Component.text((String)banMessage.toString()));
            sender.sendMessage("\u00a7c\u00a7l" + target.getName() + " has been BANNED (3rd warning - automatic ban)");
        }
    }

    private void handleWarnings(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found or not online. Note: This command only works for online players.");
            return;
        }
        UUID targetUUID = target.getUniqueId();
        List<Map<String, Object>> warnings = this.plugin.getWarnManager().getWarningsList(targetUUID);
        boolean isBanned = this.plugin.getWarnManager().isBanned(targetUUID);
        sender.sendMessage("\u00a76\u00a7l=== Warnings for " + playerName + " ===");
        sender.sendMessage("\u00a7eTotal Warnings: \u00a7f" + warnings.size());
        sender.sendMessage("\u00a7eBanned: \u00a7f" + (isBanned ? "\u00a7cYes" : "\u00a7aNo"));
        if (warnings.isEmpty()) {
            sender.sendMessage("\u00a77No warnings found.");
        } else {
            sender.sendMessage("");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < warnings.size(); ++i) {
                Map<String, Object> warning = warnings.get(i);
                long timestamp = ((Number)warning.get("timestamp")).longValue();
                String reason = (String)warning.get("reason");
                String issuer = (String)warning.get("issuer");
                String date = dateFormat.format(new Date(timestamp));
                sender.sendMessage("\u00a7e#" + (i + 1) + " \u00a77- \u00a7f" + date);
                sender.sendMessage("  \u00a77Reason: \u00a7f" + reason);
                sender.sendMessage("  \u00a77Warned by: \u00a7f" + issuer);
            }
        }
    }

    private void handleBan(CommandSender sender, String[] args) {
        String playerName = args[1];
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found or not online.");
            return;
        }
        UUID targetUUID = target.getUniqueId();
        ArrayList<String> reasons = new ArrayList<String>();
        reasons.add(reason);
        this.plugin.getWarnManager().banPlayer(targetUUID, reasons);
        StringBuilder banMessage = new StringBuilder();
        banMessage.append("\u00a74\u00a7l[BANNED]\n\n");
        banMessage.append("\u00a7cYou have been banned by an administrator.\n");
        banMessage.append("\u00a7eReason: \u00a7f").append(reason).append("\n\n");
        banMessage.append("\u00a77This ban is permanent.");
        target.kick((Component)Component.text((String)banMessage.toString()));
        sender.sendMessage("\u00a7c" + target.getName() + " has been banned.");
        sender.sendMessage("\u00a77Reason: \u00a7f" + reason);
    }

    private void handleUnban(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found or not online. Note: This command only works for online players.");
            return;
        }
        UUID targetUUID = target.getUniqueId();
        if (!this.plugin.getWarnManager().isBanned(targetUUID)) {
            sender.sendMessage("\u00a7c" + playerName + " is not banned.");
            return;
        }
        this.plugin.getWarnManager().unbanPlayer(targetUUID);
        sender.sendMessage("\u00a7a" + playerName + " has been unbanned.");
        sender.sendMessage("\u00a77Note: Their warnings have not been cleared. Use \u00a7e/protectcord clearwarnings " + playerName + " \u00a77to clear warnings.");
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== ProtectCord Commands ===");
        sender.sendMessage("\u00a7e/protectcord reload \u00a77- Reload configuration");
        sender.sendMessage("\u00a7e/protectcord whitelist add <player|uuid|ip> <value> \u00a77- Add to whitelist");
        sender.sendMessage("\u00a7e/protectcord whitelist remove <player|uuid|ip> <value> \u00a77- Remove from whitelist");
        sender.sendMessage("\u00a7e/protectcord list \u00a77- List whitelisted entries");
        sender.sendMessage("\u00a7e/protectcord check <player|ip> \u00a77- Check an IP address");
        sender.sendMessage("\u00a7e/protectcord kick <player> \u00a77- Kick player with IP analysis");
        sender.sendMessage("\u00a7e/protectcord warn <player> <reason> \u00a77- Warn a player");
        sender.sendMessage("\u00a7e/protectcord warnings <player> \u00a77- View player warnings");
        sender.sendMessage("\u00a7e/protectcord ban <player> <reason> \u00a77- Ban a player");
        sender.sendMessage("\u00a7e/protectcord unban <player> \u00a77- Unban a player");
        sender.sendMessage("\u00a7e/protectcord stats \u00a77- View API statistics");
        sender.sendMessage("\u00a7e/protectcord version \u00a77- View version information");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("protectcord.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("reload", "whitelist", "list", "check", "kick", "warn", "warnings", "ban", "unban", "stats", "version");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("add", "remove");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("player", "uuid", "ip");
        }
        return new ArrayList<String>();
    }
}

