/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.bungee.command;

import com.protectcord.bungee.ProtectCordPlugin;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class ProtectCordCommand
extends Command
implements TabExecutor {
    private final ProtectCordPlugin plugin;

    public ProtectCordCommand(ProtectCordPlugin plugin) {
        super("protectcord", "protectcord.admin", new String[]{"pc", "protect"});
        this.plugin = plugin;
    }

    public void execute(CommandSender sender, String[] args) {
        if (!sender.hasPermission("protectcord.admin")) {
            sender.sendMessage(ChatColor.RED + "You don't have permission to use this command.");
            return;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getWhitelistManager().reloadWhitelist();
                this.plugin.getWarnManager().reloadWarnings();
                sender.sendMessage(ChatColor.GREEN + "ProtectCord configuration reloaded!");
                break;
            }
            case "whitelist": {
                if (args.length < 3) {
                    sender.sendMessage(ChatColor.RED + "Usage: /protectcord whitelist <add|remove> <player|uuid|ip> <value>");
                    return;
                }
                this.handleWhitelist(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "check": {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /protectcord check <player|ip>");
                    return;
                }
                this.handleCheck(sender, args[1]);
                break;
            }
            case "stats": {
                this.handleStats(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            case "kick": {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /protectcord kick <player>");
                    return;
                }
                this.handleKick(sender, args[1]);
                break;
            }
            case "warn": {
                if (args.length < 3) {
                    sender.sendMessage(ChatColor.RED + "Usage: /protectcord warn <player> <reason>");
                    return;
                }
                this.handleWarn(sender, args);
                break;
            }
            case "warnings": {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /protectcord warnings <player>");
                    return;
                }
                this.handleWarnings(sender, args[1]);
                break;
            }
            case "ban": {
                if (args.length < 3) {
                    sender.sendMessage(ChatColor.RED + "Usage: /protectcord ban <player> <reason>");
                    return;
                }
                this.handleBan(sender, args);
                break;
            }
            case "unban": {
                if (args.length < 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /protectcord unban <player>");
                    return;
                }
                this.handleUnban(sender, args[1]);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
    }

    private void handleWhitelist(CommandSender sender, String[] args) {
        String action = args[1].toLowerCase();
        String type = args[2].toLowerCase();
        if (args.length < 4) {
            sender.sendMessage(ChatColor.RED + "Please specify a value.");
            return;
        }
        String value = args[3];
        block6 : switch (action) {
            case "add": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().addPlayer(value);
                        sender.sendMessage(ChatColor.GREEN + "Added player " + ChatColor.WHITE + value + ChatColor.GREEN + " to whitelist.");
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().addUUID(uuid);
                            sender.sendMessage(ChatColor.GREEN + "Added UUID " + ChatColor.WHITE + value + ChatColor.GREEN + " to whitelist.");
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage(ChatColor.RED + "Invalid UUID format.");
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().addIP(value);
                        sender.sendMessage(ChatColor.GREEN + "Added IP " + ChatColor.WHITE + value + ChatColor.GREEN + " to whitelist.");
                        break block6;
                    }
                }
                sender.sendMessage(ChatColor.RED + "Invalid type. Use: player, uuid, or ip");
                break;
            }
            case "remove": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().removePlayer(value);
                        sender.sendMessage(ChatColor.GREEN + "Removed player " + ChatColor.WHITE + value + ChatColor.GREEN + " from whitelist.");
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().removeUUID(uuid);
                            sender.sendMessage(ChatColor.GREEN + "Removed UUID " + ChatColor.WHITE + value + ChatColor.GREEN + " from whitelist.");
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage(ChatColor.RED + "Invalid UUID format.");
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().removeIP(value);
                        sender.sendMessage(ChatColor.GREEN + "Removed IP " + ChatColor.WHITE + value + ChatColor.GREEN + " from whitelist.");
                        break block6;
                    }
                }
                sender.sendMessage(ChatColor.RED + "Invalid type. Use: player, uuid, or ip");
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Invalid action. Use: add or remove");
            }
        }
    }

    private void handleList(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== ProtectCord Whitelist ===");
        List<String> players = this.plugin.getWhitelistManager().getWhitelistedPlayers();
        sender.sendMessage(ChatColor.YELLOW + "Whitelisted Players " + ChatColor.GRAY + "(" + players.size() + ")" + ChatColor.YELLOW + ":");
        if (players.isEmpty()) {
            sender.sendMessage("  " + ChatColor.GRAY + "None");
        } else {
            for (String string : players) {
                sender.sendMessage("  " + ChatColor.WHITE + "- " + string);
            }
        }
        List<String> uuids = this.plugin.getWhitelistManager().getWhitelistedUUIDs();
        sender.sendMessage(ChatColor.YELLOW + "Whitelisted UUIDs " + ChatColor.GRAY + "(" + uuids.size() + ")" + ChatColor.YELLOW + ":");
        if (uuids.isEmpty()) {
            sender.sendMessage("  " + ChatColor.GRAY + "None");
        } else {
            for (String uuid : uuids) {
                sender.sendMessage("  " + ChatColor.WHITE + "- " + uuid);
            }
        }
        List<String> list = this.plugin.getWhitelistManager().getWhitelistedIPs();
        sender.sendMessage(ChatColor.YELLOW + "Whitelisted IPs " + ChatColor.GRAY + "(" + list.size() + ")" + ChatColor.YELLOW + ":");
        if (list.isEmpty()) {
            sender.sendMessage("  " + ChatColor.GRAY + "None");
        } else {
            for (String ip : list) {
                sender.sendMessage("  " + ChatColor.WHITE + "- " + ip);
            }
        }
    }

    private void handleCheck(CommandSender sender, String target) {
        String ipToCheck;
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(target);
        if (player != null) {
            ipToCheck = player.getAddress().getAddress().getHostAddress();
            sender.sendMessage(ChatColor.YELLOW + "Checking IP for player " + ChatColor.WHITE + player.getName() + ChatColor.YELLOW + "...");
        } else {
            ipToCheck = target;
            sender.sendMessage(ChatColor.YELLOW + "Checking IP " + ChatColor.WHITE + target + ChatColor.YELLOW + "...");
        }
        this.plugin.getAPI().checkIP(ipToCheck).thenAccept(result -> {
            if (result == null) {
                sender.sendMessage(ChatColor.RED + "Failed to check IP. API error.");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== IP Check Results ===");
            sender.sendMessage(ChatColor.YELLOW + "IP Address: " + ChatColor.WHITE + result.getIpAddress());
            sender.sendMessage(ChatColor.YELLOW + "Risk Level: " + ChatColor.WHITE + result.getRiskLevel());
            sender.sendMessage(ChatColor.YELLOW + "Country: " + ChatColor.WHITE + result.getCountry());
            sender.sendMessage(ChatColor.YELLOW + "City: " + ChatColor.WHITE + result.getCity());
            sender.sendMessage(ChatColor.YELLOW + "Company: " + ChatColor.WHITE + result.getCompany());
            sender.sendMessage(ChatColor.YELLOW + "VPN: " + ChatColor.WHITE + (result.isVPN() ? "Yes" : "No"));
            sender.sendMessage(ChatColor.YELLOW + "Proxy: " + ChatColor.WHITE + (result.isProxy() ? "Yes" : "No"));
            sender.sendMessage(ChatColor.YELLOW + "Datacenter: " + ChatColor.WHITE + (result.isDatacenter() ? "Yes" : "No"));
            sender.sendMessage(ChatColor.YELLOW + "Bogon: " + ChatColor.WHITE + (result.isBogon() ? "Yes" : "No"));
            sender.sendMessage(ChatColor.YELLOW + "Mobile: " + ChatColor.WHITE + (result.isMobile() ? "Yes" : "No"));
        });
    }

    private void handleStats(CommandSender sender) {
        sender.sendMessage(ChatColor.YELLOW + "Loading API statistics...");
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats == null) {
                sender.sendMessage(ChatColor.RED + "Failed to fetch API statistics.");
                return;
            }
            sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== API Statistics (Global) ===");
            sender.sendMessage(ChatColor.YELLOW + "Plan: " + ChatColor.WHITE + (String)stats.get("plan"));
            if (stats.get("rate_limit") != null && !((String)stats.get("rate_limit")).isEmpty()) {
                sender.sendMessage(ChatColor.YELLOW + "Rate Limit: " + ChatColor.WHITE + (String)stats.get("rate_limit") + " req/min");
            }
            if (stats.containsKey("today_total_requests")) {
                sender.sendMessage("");
                sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== Today's Usage ===");
                sender.sendMessage(ChatColor.YELLOW + "Total Requests: " + ChatColor.WHITE + (String)stats.get("today_total_requests"));
                sender.sendMessage(ChatColor.YELLOW + "Cached Hits: " + ChatColor.WHITE + (String)stats.get("today_cached_hits"));
            }
            if (stats.containsKey("total_requests")) {
                sender.sendMessage("");
                sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== All-Time Usage ===");
                sender.sendMessage(ChatColor.YELLOW + "Total Requests: " + ChatColor.WHITE + (String)stats.get("total_requests"));
                sender.sendMessage(ChatColor.YELLOW + "Total Cached Hits: " + ChatColor.WHITE + (String)stats.get("total_cached_hits"));
            }
            sender.sendMessage("");
            sender.sendMessage(ChatColor.GRAY + "For personalized stats, visit:");
            sender.sendMessage(ChatColor.AQUA + "" + ChatColor.UNDERLINE + "https://protectcord.com");
            sender.sendMessage(ChatColor.GRAY + "Go to Dashboard > API Keys");
        });
    }

    private void handleVersion(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== ProtectCord Version Info ===");
        sender.sendMessage(ChatColor.YELLOW + "Plugin Version: " + ChatColor.WHITE + this.plugin.getDescription().getVersion());
        sender.sendMessage(ChatColor.YELLOW + "Platform: " + ChatColor.WHITE + "BungeeCord/Waterfall");
        sender.sendMessage(ChatColor.YELLOW + "Proxy Version: " + ChatColor.WHITE + this.plugin.getProxy().getVersion());
        sender.sendMessage(ChatColor.YELLOW + "Proxy Name: " + ChatColor.WHITE + this.plugin.getProxy().getName());
        sender.sendMessage(ChatColor.YELLOW + "Loading API version...");
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats != null && stats.containsKey("api_version")) {
                sender.sendMessage(ChatColor.YELLOW + "API Version: " + ChatColor.WHITE + (String)stats.get("api_version"));
            } else {
                sender.sendMessage(ChatColor.YELLOW + "API Version: " + ChatColor.RED + "Unavailable");
            }
        });
    }

    private void handleKick(CommandSender sender, String playerName) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Player not found or not online.");
            return;
        }
        String ipAddress = player.getAddress().getAddress().getHostAddress();
        sender.sendMessage(ChatColor.YELLOW + "Kicking " + ChatColor.WHITE + player.getName() + ChatColor.YELLOW + " and checking their IP...");
        ((CompletableFuture)this.plugin.getAPI().checkIP(ipAddress).thenAccept(result -> {
            if (result == null) {
                player.disconnect(TextComponent.fromLegacyText((String)(ChatColor.RED + "" + ChatColor.BOLD + "Kicked by Administrator\n" + ChatColor.GRAY + "Your connection was manually terminated.")));
                sender.sendMessage(ChatColor.GREEN + "Kicked " + ChatColor.WHITE + player.getName() + " " + ChatColor.GRAY + "(API check failed)");
                return;
            }
            StringBuilder kickMessage = new StringBuilder();
            kickMessage.append(ChatColor.RED).append(ChatColor.BOLD).append("Kicked by Administrator\n\n");
            kickMessage.append(ChatColor.GRAY).append("IP Analysis:\n");
            kickMessage.append(ChatColor.YELLOW).append("Risk Level: ").append(ChatColor.WHITE).append(result.getRiskLevel()).append("\n");
            kickMessage.append(ChatColor.YELLOW).append("Country: ").append(ChatColor.WHITE).append(result.getCountry()).append("\n");
            if (result.isVPN()) {
                kickMessage.append(ChatColor.RED).append("\u2718 VPN Detected\n");
            }
            if (result.isProxy()) {
                kickMessage.append(ChatColor.RED).append("\u2718 Proxy Detected\n");
            }
            if (result.isTor()) {
                kickMessage.append(ChatColor.RED).append("\u2718 Tor Detected\n");
            }
            if (result.isDatacenter()) {
                kickMessage.append(ChatColor.RED).append("\u2718 Datacenter IP\n");
            }
            player.disconnect(TextComponent.fromLegacyText((String)kickMessage.toString()));
            sender.sendMessage(ChatColor.GREEN + "" + ChatColor.BOLD + "Kicked " + ChatColor.WHITE + player.getName());
            sender.sendMessage(ChatColor.GRAY + "IP: " + ChatColor.WHITE + result.getIpAddress());
            sender.sendMessage(ChatColor.GRAY + "Risk: " + ChatColor.WHITE + result.getRiskLevel());
            sender.sendMessage(ChatColor.GRAY + "Country: " + ChatColor.WHITE + result.getCountry());
            sender.sendMessage(ChatColor.GRAY + "VPN: " + ChatColor.WHITE + (result.isVPN() ? ChatColor.RED + "Yes" : ChatColor.GREEN + "No"));
            sender.sendMessage(ChatColor.GRAY + "Proxy: " + ChatColor.WHITE + (result.isProxy() ? ChatColor.RED + "Yes" : ChatColor.GREEN + "No"));
            sender.sendMessage(ChatColor.GRAY + "Tor: " + ChatColor.WHITE + (result.isTor() ? ChatColor.RED + "Yes" : ChatColor.GREEN + "No"));
        })).exceptionally(ex -> {
            player.disconnect(TextComponent.fromLegacyText((String)(ChatColor.RED + "" + ChatColor.BOLD + "Kicked by Administrator\n" + ChatColor.GRAY + "Your connection was manually terminated.")));
            sender.sendMessage(ChatColor.GREEN + "Kicked " + ChatColor.WHITE + player.getName() + " " + ChatColor.GRAY + "(Error checking IP)");
            return null;
        });
    }

    private void handleWarn(CommandSender sender, String[] args) {
        String playerName = args[1];
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Player not found or not online.");
            return;
        }
        UUID playerUUID = player.getUniqueId();
        String issuer = sender instanceof ProxiedPlayer ? ((ProxiedPlayer)sender).getName() : "Console";
        this.plugin.getWarnManager().addWarning(playerUUID, reason, issuer);
        int warningCount = this.plugin.getWarnManager().getWarningCount(playerUUID);
        sender.sendMessage(ChatColor.GREEN + "Warned " + ChatColor.YELLOW + playerName + " " + ChatColor.GRAY + "(" + ChatColor.GOLD + warningCount + ChatColor.GRAY + "/" + ChatColor.RED + "3" + ChatColor.GRAY + ") " + ChatColor.GRAY + "- " + reason);
        if (warningCount == 1) {
            player.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.RED + "" + ChatColor.BOLD + "[WARNING 1/3]")));
            player.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.YELLOW + "You have been warned by " + issuer)));
            player.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.YELLOW + "Reason: " + ChatColor.WHITE + reason)));
            player.sendMessage(TextComponent.fromLegacyText((String)(ChatColor.GRAY + "You have " + ChatColor.GOLD + "2 " + ChatColor.GRAY + "warnings remaining before a ban.")));
        } else if (warningCount == 2) {
            String kickMessage = ChatColor.RED + "" + ChatColor.BOLD + "[WARNING 2/3]\n\n" + ChatColor.YELLOW + "You have been warned by " + issuer + "\n" + ChatColor.YELLOW + "Reason: " + ChatColor.WHITE + reason + "\n\n" + ChatColor.RED + "" + ChatColor.BOLD + "FINAL WARNING!\n" + ChatColor.GRAY + "One more warning will result in a " + ChatColor.DARK_RED + "permanent ban" + ChatColor.GRAY + ".";
            player.disconnect(TextComponent.fromLegacyText((String)kickMessage));
            sender.sendMessage(ChatColor.YELLOW + playerName + " has been kicked with a final warning.");
        } else if (warningCount >= 3) {
            List<String> reasons = this.plugin.getWarnManager().getWarningsList(playerUUID).stream().map(w -> (String)w.get("reason")).collect(Collectors.toList());
            this.plugin.getWarnManager().banPlayer(playerUUID, reasons);
            String banMessage = ChatColor.DARK_RED + "" + ChatColor.BOLD + "[PERMANENTLY BANNED]\n\n" + ChatColor.RED + "You have been banned for receiving 3 warnings.\n\n" + ChatColor.GRAY + "Reasons:\n" + reasons.stream().map(r -> ChatColor.GRAY + "- " + ChatColor.WHITE + r).collect(Collectors.joining("\n")) + "\n\n" + ChatColor.GRAY + "Appeal at: " + ChatColor.GREEN + "https://protectcord.com";
            player.disconnect(TextComponent.fromLegacyText((String)banMessage));
            sender.sendMessage(ChatColor.RED + playerName + " has been automatically banned for receiving 3 warnings.");
        }
    }

    private void handleWarnings(CommandSender sender, String playerName) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Player not found or not online.");
            return;
        }
        UUID playerUUID = player.getUniqueId();
        List<Map<String, Object>> warnings = this.plugin.getWarnManager().getWarningsList(playerUUID);
        boolean isBanned = this.plugin.getWarnManager().isBanned(playerUUID);
        sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== Warnings for " + playerName + " ===");
        sender.sendMessage(ChatColor.YELLOW + "Total Warnings: " + ChatColor.WHITE + warnings.size());
        sender.sendMessage(ChatColor.YELLOW + "Banned: " + (isBanned ? ChatColor.RED + "Yes" : ChatColor.GREEN + "No"));
        if (warnings.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + "No warnings on record.");
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < warnings.size(); ++i) {
                Map<String, Object> warning = warnings.get(i);
                long timestamp = ((Number)warning.get("timestamp")).longValue();
                String reason = (String)warning.get("reason");
                String issuer = (String)warning.get("issuer");
                String date = dateFormat.format(new Date(timestamp));
                sender.sendMessage(ChatColor.GRAY + "#" + (i + 1) + " " + ChatColor.WHITE + date);
                sender.sendMessage("  " + ChatColor.GRAY + "Reason: " + ChatColor.WHITE + reason);
                sender.sendMessage("  " + ChatColor.GRAY + "By: " + ChatColor.YELLOW + issuer);
            }
        }
    }

    private void handleBan(CommandSender sender, String[] args) {
        String playerName = args[1];
        String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Player not found or not online.");
            return;
        }
        UUID playerUUID = player.getUniqueId();
        ArrayList<String> reasons = new ArrayList<String>();
        reasons.add(reason);
        this.plugin.getWarnManager().banPlayer(playerUUID, reasons);
        String banMessage = ChatColor.DARK_RED + "" + ChatColor.BOLD + "[PERMANENTLY BANNED]\n\n" + ChatColor.RED + "You have been permanently banned.\n" + ChatColor.GRAY + "Reason: " + ChatColor.WHITE + reason + "\n\n" + ChatColor.GRAY + "Appeal at: " + ChatColor.GREEN + "https://protectcord.com";
        player.disconnect(TextComponent.fromLegacyText((String)banMessage));
        sender.sendMessage(ChatColor.GREEN + playerName + " has been permanently banned.");
        sender.sendMessage(ChatColor.GRAY + "Reason: " + reason);
    }

    private void handleUnban(CommandSender sender, String playerName) {
        ProxiedPlayer player = this.plugin.getProxy().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage(ChatColor.RED + "Player not found or not online.");
            return;
        }
        UUID playerUUID = player.getUniqueId();
        if (!this.plugin.getWarnManager().isBanned(playerUUID)) {
            sender.sendMessage(ChatColor.YELLOW + playerName + " is not banned.");
            return;
        }
        int ipCount = this.plugin.getWarnManager().getPlayerIPs(playerUUID).size();
        this.plugin.getWarnManager().unbanPlayerAndIPs(playerUUID);
        sender.sendMessage(ChatColor.GREEN + playerName + " has been unbanned.");
        if (ipCount > 0) {
            sender.sendMessage(ChatColor.GRAY + "Also unbanned " + ipCount + " associated IP address(es).");
        }
        sender.sendMessage(ChatColor.GRAY + "Note: Their warnings have not been cleared. Use " + ChatColor.YELLOW + "/protectcord clearwarnings " + playerName + ChatColor.GRAY + " to clear warnings.");
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "" + ChatColor.BOLD + "=== ProtectCord Commands ===");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord reload " + ChatColor.GRAY + "- Reload configuration");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord whitelist add <player|uuid|ip> <value> " + ChatColor.GRAY + "- Add to whitelist");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord whitelist remove <player|uuid|ip> <value> " + ChatColor.GRAY + "- Remove from whitelist");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord list " + ChatColor.GRAY + "- List whitelisted entries");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord check <player|ip> " + ChatColor.GRAY + "- Check an IP address");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord kick <player> " + ChatColor.GRAY + "- Kick player with IP analysis");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord warn <player> <reason> " + ChatColor.GRAY + "- Warn a player");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord warnings <player> " + ChatColor.GRAY + "- View player warnings");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord ban <player> <reason> " + ChatColor.GRAY + "- Ban a player");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord unban <player> " + ChatColor.GRAY + "- Unban a player");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord stats " + ChatColor.GRAY + "- View API statistics");
        sender.sendMessage(ChatColor.YELLOW + "/protectcord version " + ChatColor.GRAY + "- View version information");
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission("protectcord.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("reload", "whitelist", "list", "check", "kick", "warn", "warnings", "ban", "unban", "stats", "version").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("add", "remove").stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("player", "uuid", "ip").stream().filter(s -> s.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

