/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.paper.command;

import com.protectcord.paper.ProtectCordPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ProtectCordCommand
implements CommandExecutor,
TabCompleter {
    private final ProtectCordPlugin plugin;

    public ProtectCordCommand(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("protectcord.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getWhitelistManager().reloadWhitelist();
                sender.sendMessage("\u00a7aProtectCord configuration reloaded!");
                break;
            }
            case "whitelist": {
                if (args.length < 3) {
                    sender.sendMessage("\u00a7cUsage: /protectcord whitelist <add|remove> <player|uuid|ip> <value>");
                    return true;
                }
                this.handleWhitelist(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "check": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /protectcord check <player|ip>");
                    return true;
                }
                this.handleCheck(sender, args[1]);
                break;
            }
            case "stats": {
                this.handleStats(sender);
                break;
            }
            case "version": {
                this.handleVersion(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleWhitelist(CommandSender sender, String[] args) {
        String action = args[1].toLowerCase();
        String type = args[2].toLowerCase();
        if (args.length < 4) {
            sender.sendMessage("\u00a7cPlease specify a value.");
            return;
        }
        String value = args[3];
        block6 : switch (action) {
            case "add": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().addPlayer(value);
                        sender.sendMessage("\u00a7aAdded player \u00a7f" + value + " \u00a7ato whitelist.");
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().addUUID(uuid);
                            sender.sendMessage("\u00a7aAdded UUID \u00a7f" + value + " \u00a7ato whitelist.");
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage("\u00a7cInvalid UUID format.");
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().addIP(value);
                        sender.sendMessage("\u00a7aAdded IP \u00a7f" + value + " \u00a7ato whitelist.");
                        break block6;
                    }
                }
                sender.sendMessage("\u00a7cInvalid type. Use: player, uuid, or ip");
                break;
            }
            case "remove": {
                switch (type) {
                    case "player": {
                        this.plugin.getWhitelistManager().removePlayer(value);
                        sender.sendMessage("\u00a7aRemoved player \u00a7f" + value + " \u00a7afrom whitelist.");
                        break block6;
                    }
                    case "uuid": {
                        try {
                            UUID uuid = UUID.fromString(value);
                            this.plugin.getWhitelistManager().removeUUID(uuid);
                            sender.sendMessage("\u00a7aRemoved UUID \u00a7f" + value + " \u00a7afrom whitelist.");
                        }
                        catch (IllegalArgumentException e) {
                            sender.sendMessage("\u00a7cInvalid UUID format.");
                        }
                        break block6;
                    }
                    case "ip": {
                        this.plugin.getWhitelistManager().removeIP(value);
                        sender.sendMessage("\u00a7aRemoved IP \u00a7f" + value + " \u00a7afrom whitelist.");
                        break block6;
                    }
                }
                sender.sendMessage("\u00a7cInvalid type. Use: player, uuid, or ip");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cInvalid action. Use: add or remove");
            }
        }
    }

    private void handleList(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== ProtectCord Whitelist ===");
        List<String> players = this.plugin.getWhitelistManager().getWhitelistedPlayers();
        sender.sendMessage("\u00a7eWhitelisted Players \u00a77(" + players.size() + ")\u00a7e:");
        if (players.isEmpty()) {
            sender.sendMessage("  \u00a77None");
        } else {
            for (String string : players) {
                sender.sendMessage("  \u00a7f- " + string);
            }
        }
        List<String> uuids = this.plugin.getWhitelistManager().getWhitelistedUUIDs();
        sender.sendMessage("\u00a7eWhitelisted UUIDs \u00a77(" + uuids.size() + ")\u00a7e:");
        if (uuids.isEmpty()) {
            sender.sendMessage("  \u00a77None");
        } else {
            for (String uuid : uuids) {
                sender.sendMessage("  \u00a7f- " + uuid);
            }
        }
        List<String> list = this.plugin.getWhitelistManager().getWhitelistedIPs();
        sender.sendMessage("\u00a7eWhitelisted IPs \u00a77(" + list.size() + ")\u00a7e:");
        if (list.isEmpty()) {
            sender.sendMessage("  \u00a77None");
        } else {
            for (String ip : list) {
                sender.sendMessage("  \u00a7f- " + ip);
            }
        }
    }

    private void handleCheck(CommandSender sender, String target) {
        String ipToCheck;
        Player player = Bukkit.getPlayer((String)target);
        if (player != null) {
            ipToCheck = player.getAddress().getAddress().getHostAddress();
            sender.sendMessage("\u00a7eChecking IP for player \u00a7f" + player.getName() + "\u00a7e...");
        } else {
            ipToCheck = target;
            sender.sendMessage("\u00a7eChecking IP \u00a7f" + target + "\u00a7e...");
        }
        this.plugin.getAPI().checkIP(ipToCheck).thenAccept(result -> {
            if (result == null) {
                sender.sendMessage("\u00a7cFailed to check IP. API error.");
                return;
            }
            sender.sendMessage("\u00a76\u00a7l=== IP Check Results ===");
            sender.sendMessage("\u00a7eIP Address: \u00a7f" + result.getIpAddress());
            sender.sendMessage("\u00a7eRisk Level: \u00a7f" + result.getRiskLevel());
            sender.sendMessage("\u00a7eCountry: \u00a7f" + result.getCountry());
            sender.sendMessage("\u00a7eCity: \u00a7f" + result.getCity());
            sender.sendMessage("\u00a7eCompany: \u00a7f" + result.getCompany());
            sender.sendMessage("\u00a7eVPN: \u00a7f" + (result.isVPN() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eProxy: \u00a7f" + (result.isProxy() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eDatacenter: \u00a7f" + (result.isDatacenter() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eBogon: \u00a7f" + (result.isBogon() ? "Yes" : "No"));
            sender.sendMessage("\u00a7eMobile: \u00a7f" + (result.isMobile() ? "Yes" : "No"));
        });
    }

    private void handleStats(CommandSender sender) {
        sender.sendMessage("\u00a7eLoading API statistics...");
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats == null) {
                sender.sendMessage("\u00a7cFailed to fetch API statistics.");
                return;
            }
            sender.sendMessage("\u00a76\u00a7l=== API Statistics (Global) ===");
            sender.sendMessage("\u00a7ePlan: \u00a7f" + (String)stats.get("plan"));
            if (stats.get("rate_limit") != null && !((String)stats.get("rate_limit")).isEmpty()) {
                sender.sendMessage("\u00a7eRate Limit: \u00a7f" + (String)stats.get("rate_limit") + " req/min");
            }
            if (stats.containsKey("today_total_requests")) {
                sender.sendMessage("");
                sender.sendMessage("\u00a76\u00a7l=== Today's Usage ===");
                sender.sendMessage("\u00a7eTotal Requests: \u00a7f" + (String)stats.get("today_total_requests"));
                sender.sendMessage("\u00a7eCached Hits: \u00a7f" + (String)stats.get("today_cached_hits"));
            }
            if (stats.containsKey("total_requests")) {
                sender.sendMessage("");
                sender.sendMessage("\u00a76\u00a7l=== All-Time Usage ===");
                sender.sendMessage("\u00a7eTotal Requests: \u00a7f" + (String)stats.get("total_requests"));
                sender.sendMessage("\u00a7eTotal Cached Hits: \u00a7f" + (String)stats.get("total_cached_hits"));
            }
            sender.sendMessage("");
            sender.sendMessage("\u00a77For personalized stats, visit:");
            sender.sendMessage("\u00a7b\u00a7nhttps://protectcord.com");
            sender.sendMessage("\u00a77Go to Dashboard > API Keys");
        });
    }

    private void handleVersion(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== ProtectCord Version Info ===");
        sender.sendMessage("\u00a7ePlugin Version: \u00a7f" + this.plugin.getDescription().getVersion());
        sender.sendMessage("\u00a7ePlatform: \u00a7fPaper/PaperSpigot");
        sender.sendMessage("\u00a7eServer Version: \u00a7f" + Bukkit.getVersion());
        sender.sendMessage("\u00a7eMinecraft Version: \u00a7f" + Bukkit.getBukkitVersion());
        sender.sendMessage("\u00a7eLoading API version...");
        this.plugin.getAPI().getStatistics().thenAccept(stats -> {
            if (stats != null && stats.containsKey("api_version")) {
                sender.sendMessage("\u00a7eAPI Version: \u00a7f" + (String)stats.get("api_version"));
            } else {
                sender.sendMessage("\u00a7eAPI Version: \u00a7cUnavailable");
            }
        });
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== ProtectCord Commands ===");
        sender.sendMessage("\u00a7e/protectcord reload \u00a77- Reload configuration");
        sender.sendMessage("\u00a7e/protectcord whitelist add <player|uuid|ip> <value> \u00a77- Add to whitelist");
        sender.sendMessage("\u00a7e/protectcord whitelist remove <player|uuid|ip> <value> \u00a77- Remove from whitelist");
        sender.sendMessage("\u00a7e/protectcord list \u00a77- List whitelisted entries");
        sender.sendMessage("\u00a7e/protectcord check <player|ip> \u00a77- Check an IP address");
        sender.sendMessage("\u00a7e/protectcord stats \u00a77- View API statistics");
        sender.sendMessage("\u00a7e/protectcord version \u00a77- View version information");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("protectcord.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("reload", "whitelist", "list", "check", "stats", "version");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("add", "remove");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("whitelist")) {
            return Arrays.asList("player", "uuid", "ip");
        }
        return new ArrayList<String>();
    }
}

