/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.protectcord.forge.api.ProtectCordAPI;
import com.protectcord.forge.bstats.charts.SimplePie;
import com.protectcord.forge.command.ProtectCordCommand;
import com.protectcord.forge.config.ConfigManager;
import com.protectcord.forge.listener.PlayerConnectionListener;
import com.protectcord.forge.metrics.Metrics;
import com.protectcord.forge.warn.WarnManager;
import com.protectcord.forge.webhook.WebhookManager;
import com.protectcord.forge.whitelist.WhitelistManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod(value="protectcord")
public class ProtectCordMod {
    public static final String MOD_ID = "protectcord";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ProtectCordMod instance;
    private ConfigManager configManager;
    private ProtectCordAPI api;
    private WhitelistManager whitelistManager;
    private WarnManager warnManager;
    private WebhookManager webhookManager;
    private Metrics metrics;
    private ScheduledExecutorService updateScheduler;

    public ProtectCordMod() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.configManager = new ConfigManager();
        this.configManager.loadConfig();
        LOGGER.info("==========================================");
        LOGGER.info("");
        LOGGER.info("ProtectCord v1.0.6 by ProtectCord");
        LOGGER.info("Platform: Forge | MC: 1.20.1");
        LOGGER.info("https://protectcord.com");
        LOGGER.info("");
        LOGGER.info("==========================================");
        String apiKey = this.configManager.getApiKey();
        if (apiKey == null || apiKey.isEmpty() || apiKey.equals("YOUR_API_KEY_HERE")) {
            LOGGER.error("========================================");
            LOGGER.error("");
            LOGGER.error("API KEY NOT CONFIGURED!");
            LOGGER.error("Please follow these steps:");
            LOGGER.error("1. Go to https://protectcord.com");
            LOGGER.error("2. Navigate to Dashboard > API Keys");
            LOGGER.error("3. Generate a new API key");
            LOGGER.error("4. Add the key to config/protectcord.toml");
            LOGGER.error("5. Restart the server");
            LOGGER.error("");
            LOGGER.error("========================================");
            return;
        }
        this.api = new ProtectCordAPI(apiKey);
        this.whitelistManager = new WhitelistManager(this);
        this.warnManager = new WarnManager(this);
        this.webhookManager = new WebhookManager(this);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerConnectionListener(this));
        int pluginId = 24623;
        this.metrics = new Metrics(pluginId);
        this.metrics.addCustomChart(new SimplePie("platform", () -> "Forge"));
        this.metrics.addCustomChart(new SimplePie("minecraft_version", () -> "1.20.1"));
        LOGGER.info("ProtectCord has been enabled successfully!");
        this.updateScheduler = Executors.newSingleThreadScheduledExecutor();
        this.updateScheduler.scheduleAtFixedRate(() -> LOGGER.info("Checking for ProtectCord updates..."), 1L, 1L, TimeUnit.HOURS);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ProtectCordCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LOGGER.info("ProtectCord commands registered!");
    }

    public void shutdown() {
        if (this.updateScheduler != null) {
            this.updateScheduler.shutdown();
        }
        if (this.api != null) {
            this.api.shutdown();
        }
        LOGGER.info("ProtectCord has been disabled.");
    }

    public static ProtectCordMod getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ProtectCordAPI getAPI() {
        return this.api;
    }

    public WhitelistManager getWhitelistManager() {
        return this.whitelistManager;
    }

    public WarnManager getWarnManager() {
        return this.warnManager;
    }

    public WebhookManager getWebhookManager() {
        return this.webhookManager;
    }

    public Logger getLogger() {
        return LOGGER;
    }
}

