/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge.api;

import com.google.gson.JsonObject;

public class IPCheckResult {
    private final String ipAddress;
    private final String riskLevel;
    private final boolean isBogon;
    private final boolean isMobile;
    private final boolean isSatellite;
    private final boolean isCrawler;
    private final boolean isDatacenter;
    private final boolean isTor;
    private final boolean isProxy;
    private final boolean isVPN;
    private final boolean isAbuser;
    private final boolean isWhitelisted;
    private final boolean isBlacklisted;
    private final String country;
    private final String countryCode;
    private final String city;
    private final String company;
    private final String companyRiskScore;

    public IPCheckResult(String ipAddress, String riskLevel, boolean isBogon, boolean isMobile, boolean isSatellite, boolean isCrawler, boolean isDatacenter, boolean isTor, boolean isProxy, boolean isVPN, boolean isAbuser, boolean isWhitelisted, boolean isBlacklisted, String country, String countryCode, String city, String company, String companyRiskScore) {
        this.ipAddress = ipAddress;
        this.riskLevel = riskLevel;
        this.isBogon = isBogon;
        this.isMobile = isMobile;
        this.isSatellite = isSatellite;
        this.isCrawler = isCrawler;
        this.isDatacenter = isDatacenter;
        this.isTor = isTor;
        this.isProxy = isProxy;
        this.isVPN = isVPN;
        this.isAbuser = isAbuser;
        this.isWhitelisted = isWhitelisted;
        this.isBlacklisted = isBlacklisted;
        this.country = country;
        this.countryCode = countryCode;
        this.city = city;
        this.company = company;
        this.companyRiskScore = companyRiskScore;
    }

    public static IPCheckResult fromJson(JsonObject json) {
        String ipAddress = json.has("ip") ? json.get("ip").getAsString() : "Unknown";
        boolean isBogon = json.has("is_bogon") && json.get("is_bogon").getAsBoolean();
        boolean isMobile = json.has("is_mobile") && json.get("is_mobile").getAsBoolean();
        boolean isSatellite = json.has("is_satellite") && json.get("is_satellite").getAsBoolean();
        boolean isCrawler = json.has("is_crawler") && json.get("is_crawler").getAsBoolean();
        boolean isDatacenter = json.has("is_datacenter") && json.get("is_datacenter").getAsBoolean();
        boolean isTor = json.has("is_tor") && json.get("is_tor").getAsBoolean();
        boolean isProxy = json.has("is_proxy") && json.get("is_proxy").getAsBoolean();
        boolean isVPN = json.has("is_vpn") && json.get("is_vpn").getAsBoolean();
        boolean isAbuser = json.has("is_abuser") && json.get("is_abuser").getAsBoolean();
        boolean isWhitelisted = json.has("is_whitelisted") && json.get("is_whitelisted").getAsBoolean();
        boolean isBlacklisted = json.has("is_blacklisted") && json.get("is_blacklisted").getAsBoolean();
        String riskLevel = "LOW";
        if (isBlacklisted || isTor) {
            riskLevel = "CRITICAL";
        } else if (isAbuser || isVPN && isProxy) {
            riskLevel = "HIGH";
        } else if (isVPN || isProxy) {
            riskLevel = "MEDIUM";
        } else if (isBogon) {
            riskLevel = "UNKNOWN";
        }
        String country = "Unknown";
        String countryCode = "Unknown";
        String city = "Unknown";
        if (json.has("location")) {
            JsonObject location = json.getAsJsonObject("location");
            country = location.has("country") ? location.get("country").getAsString() : "Unknown";
            countryCode = location.has("country_code") ? location.get("country_code").getAsString() : "Unknown";
            city = location.has("city") ? location.get("city").getAsString() : "Unknown";
        }
        String company = "Unknown";
        String companyRiskScore = "Unknown";
        if (json.has("company")) {
            JsonObject companyObj = json.getAsJsonObject("company");
            company = companyObj.has("name") ? companyObj.get("name").getAsString() : "Unknown";
            companyRiskScore = companyObj.has("risk_score") ? companyObj.get("risk_score").getAsString() : "Unknown";
        }
        return new IPCheckResult(ipAddress, riskLevel, isBogon, isMobile, isSatellite, isCrawler, isDatacenter, isTor, isProxy, isVPN, isAbuser, isWhitelisted, isBlacklisted, country, countryCode, city, company, companyRiskScore);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getRiskLevel() {
        return this.riskLevel;
    }

    public boolean isBogon() {
        return this.isBogon;
    }

    public boolean isMobile() {
        return this.isMobile;
    }

    public boolean isSatellite() {
        return this.isSatellite;
    }

    public boolean isCrawler() {
        return this.isCrawler;
    }

    public boolean isDatacenter() {
        return this.isDatacenter;
    }

    public boolean isTor() {
        return this.isTor;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public boolean isVPN() {
        return this.isVPN;
    }

    public boolean isAbuser() {
        return this.isAbuser;
    }

    public boolean isWhitelisted() {
        return this.isWhitelisted;
    }

    public boolean isBlacklisted() {
        return this.isBlacklisted;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCompany() {
        return this.company;
    }

    public String getCompanyRiskScore() {
        return this.companyRiskScore;
    }

    public boolean isDangerous() {
        return this.riskLevel.equals("HIGH") || this.riskLevel.equals("CRITICAL");
    }
}

