/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.spigot.listener;

import com.protectcord.spigot.ProtectCordPlugin;
import com.protectcord.spigot.api.IPCheckResult;
import java.net.InetAddress;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

public class PlayerConnectionListener
implements Listener {
    private final ProtectCordPlugin plugin;

    public PlayerConnectionListener(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        String playerName = event.getName();
        String uuid = event.getUniqueId().toString();
        InetAddress address = event.getAddress();
        String ipAddress = address.getHostAddress();
        if (this.plugin.getWarnManager().isBanned(event.getUniqueId())) {
            List<String> banReasons = this.plugin.getWarnManager().getBanReasons(event.getUniqueId());
            StringBuilder banMessage = new StringBuilder();
            banMessage.append("\u00a74\u00a7l[BANNED]\n\n");
            banMessage.append("\u00a7cYou are banned from this server.\n\n");
            if (!banReasons.isEmpty()) {
                banMessage.append("\u00a7e\u00a7lReasons:\n");
                for (int i = 0; i < banReasons.size(); ++i) {
                    banMessage.append("\u00a77").append(i + 1).append(". \u00a7f").append(banReasons.get(i)).append("\n");
                }
            }
            banMessage.append("\n\u00a77This ban is permanent.");
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, banMessage.toString());
            this.plugin.getLogger().info("Banned player " + playerName + " attempted to join.");
            return;
        }
        if (this.plugin.getWarnManager().isIPBanned(ipAddress)) {
            List<String> banReasons = this.plugin.getWarnManager().getIPBanReasons(ipAddress);
            StringBuilder banMessage = new StringBuilder();
            banMessage.append("\u00a74\u00a7l[IP BANNED]\n\n");
            banMessage.append("\u00a7cYour IP address is banned from this server.\n\n");
            if (!banReasons.isEmpty()) {
                banMessage.append("\u00a7e\u00a7lReasons:\n");
                for (int i = 0; i < banReasons.size(); ++i) {
                    banMessage.append("\u00a77").append(i + 1).append(". \u00a7f").append(banReasons.get(i)).append("\n");
                }
            }
            banMessage.append("\n\u00a77This ban is permanent.");
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, banMessage.toString());
            this.plugin.getLogger().info("IP banned player " + playerName + " (" + ipAddress + ") attempted to join.");
            return;
        }
        if (!this.plugin.getConfigManager().isCheckEnabled()) {
            return;
        }
        if (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress()) {
            this.plugin.getLogger().info("Player " + playerName + " bypassed IP check (local/private IP: " + ipAddress + ")");
            this.plugin.getWarnManager().logPlayerIP(event.getUniqueId(), ipAddress);
            return;
        }
        if (this.plugin.getWhitelistManager().isWhitelisted(playerName, event.getUniqueId(), ipAddress)) {
            this.plugin.getLogger().info("Player " + playerName + " bypassed IP check (whitelisted)");
            this.plugin.getWarnManager().logPlayerIP(event.getUniqueId(), ipAddress);
            this.plugin.getWebhookManager().sendWhitelistedWebhook(playerName, uuid, ipAddress);
            return;
        }
        try {
            IPCheckResult result = this.plugin.getAPI().checkIP(ipAddress).get();
            if (result == null) {
                String errorMessage = this.plugin.getConfigManager().getMessage("api-error");
                this.plugin.getLogger().warning("Failed to check IP for " + playerName + " (" + ipAddress + ")");
                this.plugin.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, "API returned null result");
                return;
            }
            boolean shouldBlock = false;
            String reason = "";
            if (this.plugin.getConfigManager().isGeoBlockingEnabled()) {
                String countryCode = result.getCountryCode();
                String mode = this.plugin.getConfigManager().getGeoBlockingMode();
                List<String> countries = this.plugin.getConfigManager().getGeoBlockingCountries();
                if (mode.equalsIgnoreCase("blacklist") && countries.contains(countryCode)) {
                    shouldBlock = true;
                    reason = "Country blocked (" + result.getCountry() + ")";
                } else if (mode.equalsIgnoreCase("whitelist") && !countries.contains(countryCode)) {
                    shouldBlock = true;
                    reason = "Country not whitelisted (" + result.getCountry() + ")";
                }
            }
            if (!shouldBlock && result.isBogon() && this.plugin.getConfigManager().shouldBlockBogon()) {
                shouldBlock = true;
                reason = "Bogon IP address";
            } else if (!shouldBlock && result.isTor() && this.plugin.getConfigManager().shouldBlockTor()) {
                shouldBlock = true;
                reason = "Tor exit node detected";
            } else if (!shouldBlock && result.isVPN() && this.plugin.getConfigManager().shouldBlockVPN()) {
                shouldBlock = true;
                reason = "VPN detected";
            } else if (!shouldBlock && result.isProxy() && this.plugin.getConfigManager().shouldBlockProxy()) {
                shouldBlock = true;
                reason = "Proxy detected";
            } else if (!shouldBlock && result.isDatacenter() && this.plugin.getConfigManager().shouldBlockDatacenter()) {
                shouldBlock = true;
                reason = "Datacenter IP";
            }
            if (!shouldBlock && this.plugin.getConfigManager().isRiskLevelBlockingEnabled()) {
                String blockedRiskLevel = this.plugin.getConfigManager().getBlockedRiskLevel();
                if (blockedRiskLevel.equals("HIGH") && (result.getRiskLevel().equals("HIGH") || result.getRiskLevel().equals("CRITICAL"))) {
                    shouldBlock = true;
                    reason = "High risk IP (" + result.getRiskLevel() + ")";
                } else if (blockedRiskLevel.equals("MEDIUM") && !result.getRiskLevel().equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                    shouldBlock = true;
                    reason = "Medium+ risk IP (" + result.getRiskLevel() + ")";
                } else if (blockedRiskLevel.equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                    shouldBlock = true;
                    reason = "Risk detected (" + result.getRiskLevel() + ")";
                }
            }
            if (shouldBlock) {
                String kickMessage = this.plugin.getConfigManager().getMessage("connection-denied").replace("{reason}", reason).replace("{risk}", result.getRiskLevel());
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, kickMessage);
                this.plugin.getLogger().warning("Blocked " + playerName + " (" + ipAddress + ") - " + reason);
                this.plugin.getWebhookManager().sendDeniedWebhook(playerName, uuid, ipAddress, result);
            } else {
                this.plugin.getLogger().info("Allowed " + playerName + " (" + ipAddress + ") - Risk: " + result.getRiskLevel());
                this.plugin.getWarnManager().logPlayerIP(event.getUniqueId(), ipAddress);
                this.plugin.getWebhookManager().sendAcceptedWebhook(playerName, uuid, ipAddress, result);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error checking IP for " + playerName + ": " + e.getMessage());
            this.plugin.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, e.getMessage());
        }
    }
}

