/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.spigot;

import com.protectcord.spigot.api.ProtectCordAPI;
import com.protectcord.spigot.bstats.bukkit.Metrics;
import com.protectcord.spigot.command.ProtectCordCommand;
import com.protectcord.spigot.config.ConfigManager;
import com.protectcord.spigot.listener.PlayerConnectionListener;
import com.protectcord.spigot.update.UpdateChecker;
import com.protectcord.spigot.warn.WarnManager;
import com.protectcord.spigot.webhook.WebhookManager;
import com.protectcord.spigot.whitelist.WhitelistManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ProtectCordPlugin
extends JavaPlugin {
    private static ProtectCordPlugin instance;
    private ConfigManager configManager;
    private ProtectCordAPI api;
    private WhitelistManager whitelistManager;
    private WarnManager warnManager;
    private WebhookManager webhookManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.getLogger().info("==========================================");
        this.getLogger().info("ProtectCord v1.0.8 by ProtectCord");
        this.getLogger().info("Platform: Spigot | MC: 1.8.8 - 1.21+");
        this.getLogger().info("https://protectcord.com");
        this.getLogger().info("==========================================");
        String apiKey = this.configManager.getApiKey();
        if (apiKey == null || apiKey.isEmpty() || apiKey.equals("YOUR_API_KEY_HERE")) {
            this.getLogger().severe("========================================");
            this.getLogger().severe("API KEY NOT CONFIGURED!");
            this.getLogger().severe("Please follow these steps:");
            this.getLogger().severe("1. Go to https://protectcord.com");
            this.getLogger().severe("2. Navigate to Dashboard > API Keys");
            this.getLogger().severe("3. Generate a new API key");
            this.getLogger().severe("4. Add the key to config.yml");
            this.getLogger().severe("5. Restart the server");
            this.getLogger().severe("========================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.api = new ProtectCordAPI(apiKey, this.configManager.getConnectTimeout(), this.configManager.getReadTimeout());
        this.whitelistManager = new WhitelistManager(this);
        this.warnManager = new WarnManager(this);
        this.webhookManager = new WebhookManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectionListener(this), (Plugin)this);
        this.getCommand("protectcord").setExecutor((CommandExecutor)new ProtectCordCommand(this));
        int pluginId = 24623;
        Metrics metrics = new Metrics(this, pluginId);
        this.getLogger().info("ProtectCord has been enabled successfully!");
        UpdateChecker updateChecker = new UpdateChecker((Plugin)this);
        updateChecker.checkForUpdates().thenAccept(updateInfo -> {
            if (updateInfo != null) {
                updateChecker.notifyUpdate((UpdateChecker.UpdateInfo)updateInfo);
            }
        });
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> updateChecker.checkForUpdates().thenAccept(updateInfo -> {
            if (updateInfo != null) {
                updateChecker.notifyUpdate((UpdateChecker.UpdateInfo)updateInfo);
            }
        }), 72000L, 72000L);
    }

    public void onDisable() {
        if (this.api != null) {
            this.api.shutdown();
        }
        this.getLogger().info("ProtectCord has been disabled.");
    }

    public static ProtectCordPlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ProtectCordAPI getAPI() {
        return this.api;
    }

    public WhitelistManager getWhitelistManager() {
        return this.whitelistManager;
    }

    public WarnManager getWarnManager() {
        return this.warnManager;
    }

    public WebhookManager getWebhookManager() {
        return this.webhookManager;
    }
}

