/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.spigot.warn;

import com.protectcord.spigot.ProtectCordPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class WarnManager {
    private final ProtectCordPlugin plugin;
    private File warningsFile;
    private FileConfiguration warningsConfig;

    public WarnManager(ProtectCordPlugin plugin) {
        this.plugin = plugin;
        this.loadWarnings();
    }

    private void loadWarnings() {
        this.warningsFile = new File(this.plugin.getDataFolder(), "warnings.yml");
        if (!this.warningsFile.exists()) {
            try {
                this.warningsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create warnings.yml: " + e.getMessage());
            }
        }
        this.warningsConfig = YamlConfiguration.loadConfiguration((File)this.warningsFile);
        if (!this.warningsConfig.contains("players")) {
            this.warningsConfig.createSection("players");
            this.saveWarnings();
        }
    }

    public void saveWarnings() {
        try {
            this.warningsConfig.save(this.warningsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save warnings.yml: " + e.getMessage());
        }
    }

    public void reloadWarnings() {
        this.warningsConfig = YamlConfiguration.loadConfiguration((File)this.warningsFile);
    }

    public void addWarning(UUID playerUUID, String reason, String issuer) {
        String path = "players." + playerUUID.toString();
        List<Map<String, Object>> warnings = this.getWarningsList(playerUUID);
        HashMap<String, Object> warning = new HashMap<String, Object>();
        warning.put("timestamp", System.currentTimeMillis());
        warning.put("reason", reason);
        warning.put("issuer", issuer);
        warnings.add(warning);
        this.warningsConfig.set(path + ".warnings", warnings);
        this.saveWarnings();
    }

    public List<Map<String, Object>> getWarningsList(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".warnings";
        List warnings = this.warningsConfig.getList(path);
        return warnings != null ? warnings : new ArrayList();
    }

    public int getWarningCount(UUID playerUUID) {
        return this.getWarningsList(playerUUID).size();
    }

    public boolean isBanned(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.banned";
        return this.warningsConfig.getBoolean(path, false);
    }

    public void banPlayer(UUID playerUUID, List<String> reasons) {
        String path = "players." + playerUUID.toString() + ".ban";
        this.warningsConfig.set(path + ".banned", (Object)true);
        this.warningsConfig.set(path + ".timestamp", (Object)System.currentTimeMillis());
        this.warningsConfig.set(path + ".reasons", reasons);
        List<String> playerIPs = this.getPlayerIPs(playerUUID);
        for (String ip : playerIPs) {
            this.banIP(ip, playerUUID.toString(), reasons);
        }
        this.saveWarnings();
    }

    public void unbanPlayer(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban";
        this.warningsConfig.set(path + ".banned", (Object)false);
        this.saveWarnings();
    }

    public List<String> getBanReasons(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.reasons";
        return this.warningsConfig.getStringList(path);
    }

    public void clearWarnings(UUID playerUUID) {
        String path = "players." + playerUUID.toString();
        this.warningsConfig.set(path, null);
        this.saveWarnings();
    }

    public Map<String, Object> getPlayerData(UUID playerUUID) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("warnings", this.getWarningsList(playerUUID));
        data.put("warningCount", this.getWarningCount(playerUUID));
        data.put("banned", this.isBanned(playerUUID));
        data.put("banReasons", this.getBanReasons(playerUUID));
        return data;
    }

    public void logPlayerIP(UUID playerUUID, String ipAddress) {
        String path = "players." + playerUUID.toString() + ".ip-history";
        List ipHistory = this.warningsConfig.getStringList(path);
        if (!ipHistory.contains(ipAddress)) {
            ipHistory.add(ipAddress);
            this.warningsConfig.set(path, (Object)ipHistory);
            this.saveWarnings();
        }
    }

    public List<String> getPlayerIPs(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ip-history";
        return this.warningsConfig.getStringList(path);
    }

    public void banIP(String ipAddress, String associatedUUID, List<String> reasons) {
        String path = "banned-ips." + ipAddress.replace(".", "_");
        this.warningsConfig.set(path + ".banned", (Object)true);
        this.warningsConfig.set(path + ".timestamp", (Object)System.currentTimeMillis());
        this.warningsConfig.set(path + ".associated-uuid", (Object)associatedUUID);
        this.warningsConfig.set(path + ".reasons", reasons);
        this.saveWarnings();
    }

    public boolean isIPBanned(String ipAddress) {
        String path = "banned-ips." + ipAddress.replace(".", "_") + ".banned";
        return this.warningsConfig.getBoolean(path, false);
    }

    public List<String> getIPBanReasons(String ipAddress) {
        String path = "banned-ips." + ipAddress.replace(".", "_") + ".reasons";
        return this.warningsConfig.getStringList(path);
    }

    public void unbanIP(String ipAddress) {
        String path = "banned-ips." + ipAddress.replace(".", "_") + ".banned";
        this.warningsConfig.set(path, (Object)false);
        this.saveWarnings();
    }

    public void unbanPlayerAndIPs(UUID playerUUID) {
        this.unbanPlayer(playerUUID);
        List<String> playerIPs = this.getPlayerIPs(playerUUID);
        for (String ip : playerIPs) {
            this.unbanIP(ip);
        }
        this.saveWarnings();
    }
}

