/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.folia;

import com.protectcord.folia.api.ProtectCordAPI;
import com.protectcord.folia.bstats.bukkit.Metrics;
import com.protectcord.folia.command.ProtectCordCommand;
import com.protectcord.folia.config.ConfigManager;
import com.protectcord.folia.listener.PlayerConnectionListener;
import com.protectcord.folia.update.UpdateChecker;
import com.protectcord.folia.warn.WarnManager;
import com.protectcord.folia.webhook.WebhookManager;
import com.protectcord.folia.whitelist.WhitelistManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ProtectCordPlugin
extends JavaPlugin {
    private static ProtectCordPlugin instance;
    private ConfigManager configManager;
    private ProtectCordAPI api;
    private WhitelistManager whitelistManager;
    private WarnManager warnManager;
    private WebhookManager webhookManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.getLogger().info("==========================================");
        this.getLogger().info("ProtectCord v1.0.6 by ProtectCord");
        this.getLogger().info("Platform: Folia | MC: 1.8.8 - 1.21+");
        this.getLogger().info("https://protectcord.com");
        this.getLogger().info("==========================================");
        String apiKey = this.configManager.getApiKey();
        if (apiKey == null || apiKey.isEmpty() || apiKey.equals("YOUR_API_KEY_HERE")) {
            this.getLogger().severe("========================================");
            this.getLogger().severe("API KEY NOT CONFIGURED!");
            this.getLogger().severe("Please follow these steps:");
            this.getLogger().severe("1. Go to https://protectcord.com");
            this.getLogger().severe("2. Navigate to Dashboard > API Keys");
            this.getLogger().severe("3. Generate a new API key");
            this.getLogger().severe("4. Add the key to config.yml");
            this.getLogger().severe("5. Restart the server");
            this.getLogger().severe("========================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.api = new ProtectCordAPI(apiKey);
        this.whitelistManager = new WhitelistManager(this);
        this.warnManager = new WarnManager(this);
        this.webhookManager = new WebhookManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectionListener(this), (Plugin)this);
        this.getCommand("protectcord").setExecutor((CommandExecutor)new ProtectCordCommand(this));
        int pluginId = 24623;
        Metrics metrics = new Metrics(this, pluginId);
        UpdateChecker updateChecker = new UpdateChecker((Plugin)this);
        updateChecker.checkForUpdates().thenAccept(updateInfo -> {
            if (updateInfo != null) {
                updateChecker.notifyUpdate((UpdateChecker.UpdateInfo)updateInfo);
            }
        });
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> updateChecker.checkForUpdates().thenAccept(updateInfo -> {
            if (updateInfo != null) {
                updateChecker.notifyUpdate((UpdateChecker.UpdateInfo)updateInfo);
            }
        }), 72000L, 72000L);
        this.getLogger().info("ProtectCord has been enabled successfully!");
    }

    public void onDisable() {
        if (this.api != null) {
            this.api.shutdown();
        }
        this.getLogger().info("ProtectCord has been disabled.");
    }

    public static ProtectCordPlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ProtectCordAPI getAPI() {
        return this.api;
    }

    public WhitelistManager getWhitelistManager() {
        return this.whitelistManager;
    }

    public WarnManager getWarnManager() {
        return this.warnManager;
    }

    public WebhookManager getWebhookManager() {
        return this.webhookManager;
    }
}

