/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge.warn;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.protectcord.forge.ProtectCordMod;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;

public class WarnManager {
    private final ProtectCordMod mod;
    private CommentedFileConfig warningsConfig;
    private Path warningsPath;
    private CommentedFileConfig ipTrackingConfig;
    private Path ipTrackingPath;
    private CommentedFileConfig ipBansConfig;
    private Path ipBansPath;

    public WarnManager(ProtectCordMod mod) {
        this.mod = mod;
        this.loadWarnings();
        this.loadIPTracking();
        this.loadIPBans();
    }

    private void loadWarnings() {
        this.warningsPath = FMLPaths.CONFIGDIR.get().resolve("protectcord-warnings.toml");
        this.warningsConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.warningsPath).sync().autosave().build();
        this.warningsConfig.load();
        if (!this.warningsConfig.contains("players")) {
            HashMap emptyMap = new HashMap();
            this.warningsConfig.set("players", emptyMap);
            this.warningsConfig.save();
        }
    }

    private void loadIPTracking() {
        this.ipTrackingPath = FMLPaths.CONFIGDIR.get().resolve("protectcord-ip-tracking.toml");
        this.ipTrackingConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.ipTrackingPath).sync().autosave().build();
        this.ipTrackingConfig.load();
        if (!this.ipTrackingConfig.contains("players")) {
            HashMap emptyMap = new HashMap();
            this.ipTrackingConfig.set("players", emptyMap);
            this.ipTrackingConfig.save();
        }
    }

    private void loadIPBans() {
        this.ipBansPath = FMLPaths.CONFIGDIR.get().resolve("protectcord-ip-bans.toml");
        this.ipBansConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.ipBansPath).sync().autosave().build();
        this.ipBansConfig.load();
        if (!this.ipBansConfig.contains("ips")) {
            HashMap emptyMap = new HashMap();
            this.ipBansConfig.set("ips", emptyMap);
            this.ipBansConfig.save();
        }
    }

    public void saveWarnings() {
        this.warningsConfig.save();
    }

    public void reloadWarnings() {
        this.warningsConfig.load();
        this.ipTrackingConfig.load();
        this.ipBansConfig.load();
    }

    public void addWarning(UUID playerUUID, String reason, String issuer) {
        String path = "players." + playerUUID.toString();
        List<Map<String, Object>> warnings = this.getWarningsList(playerUUID);
        HashMap<String, Object> warning = new HashMap<String, Object>();
        warning.put("timestamp", System.currentTimeMillis());
        warning.put("reason", reason);
        warning.put("issuer", issuer);
        warnings.add(warning);
        this.warningsConfig.set(path + ".warnings", warnings);
        this.saveWarnings();
    }

    public List<Map<String, Object>> getWarningsList(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".warnings";
        Object warningsObj = this.warningsConfig.get(path);
        if (warningsObj instanceof List) {
            return (List)warningsObj;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public int getWarningCount(UUID playerUUID) {
        return this.getWarningsList(playerUUID).size();
    }

    public boolean isBanned(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.banned";
        Object banned = this.warningsConfig.get(path);
        return banned instanceof Boolean && (Boolean)banned != false;
    }

    public void banPlayer(UUID playerUUID, List<String> reasons) {
        String path = "players." + playerUUID.toString() + ".ban";
        HashMap<String, Object> banData = new HashMap<String, Object>();
        banData.put("banned", true);
        banData.put("timestamp", System.currentTimeMillis());
        banData.put("reasons", reasons);
        this.warningsConfig.set(path, banData);
        this.saveWarnings();
        List<String> playerIPs = this.getPlayerIPs(playerUUID);
        for (String ip : playerIPs) {
            this.banIP(ip, playerUUID.toString(), reasons);
        }
    }

    public void unbanPlayer(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.banned";
        this.warningsConfig.set(path, (Object)false);
        this.saveWarnings();
    }

    public List<String> getBanReasons(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.reasons";
        Object reasons = this.warningsConfig.get(path);
        if (reasons instanceof List) {
            return (List)reasons;
        }
        return new ArrayList<String>();
    }

    public void clearWarnings(UUID playerUUID) {
        String path = "players." + playerUUID.toString();
        this.warningsConfig.remove(path);
        this.saveWarnings();
    }

    public Map<String, Object> getPlayerData(UUID playerUUID) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("warnings", this.getWarningsList(playerUUID));
        data.put("warningCount", this.getWarningCount(playerUUID));
        data.put("banned", this.isBanned(playerUUID));
        data.put("banReasons", this.getBanReasons(playerUUID));
        return data;
    }

    public void logPlayerIP(UUID playerUUID, String ipAddress) {
        String path = "players." + playerUUID.toString() + ".ips";
        ArrayList<String> ips = (ArrayList<String>)this.ipTrackingConfig.get(path);
        if (ips == null) {
            ips = new ArrayList<String>();
        }
        if (!ips.contains(ipAddress)) {
            ips.add(ipAddress);
            this.ipTrackingConfig.set(path, ips);
            String timestampPath = "players." + playerUUID.toString() + ".last_seen";
            this.ipTrackingConfig.set(timestampPath, (Object)System.currentTimeMillis());
            this.ipTrackingConfig.save();
        }
    }

    public List<String> getPlayerIPs(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ips";
        Object ipsObj = this.ipTrackingConfig.get(path);
        if (ipsObj instanceof List) {
            return (List)ipsObj;
        }
        return new ArrayList<String>();
    }

    public void banIP(String ipAddress, String associatedUUID, List<String> reasons) {
        String path = "ips." + ipAddress.replace(".", "_");
        HashMap<String, Object> banData = new HashMap<String, Object>();
        banData.put("banned", true);
        banData.put("timestamp", System.currentTimeMillis());
        banData.put("associatedUUID", associatedUUID);
        banData.put("reasons", reasons);
        this.ipBansConfig.set(path, banData);
        this.ipBansConfig.save();
    }

    public boolean isIPBanned(String ipAddress) {
        String path = "ips." + ipAddress.replace(".", "_") + ".banned";
        Object banned = this.ipBansConfig.get(path);
        return banned instanceof Boolean && (Boolean)banned != false;
    }

    public List<String> getIPBanReasons(String ipAddress) {
        String path = "ips." + ipAddress.replace(".", "_") + ".reasons";
        Object reasons = this.ipBansConfig.get(path);
        if (reasons instanceof List) {
            return (List)reasons;
        }
        return new ArrayList<String>();
    }

    public String getIPBanAssociatedUUID(String ipAddress) {
        String path = "ips." + ipAddress.replace(".", "_") + ".associatedUUID";
        Object uuid = this.ipBansConfig.get(path);
        if (uuid instanceof String) {
            return (String)uuid;
        }
        return null;
    }

    public void unbanIP(String ipAddress) {
        String path = "ips." + ipAddress.replace(".", "_");
        this.ipBansConfig.remove(path);
        this.ipBansConfig.save();
    }

    public int unbanPlayerAndIPs(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.banned";
        this.warningsConfig.set(path, (Object)false);
        this.saveWarnings();
        List<String> playerIPs = this.getPlayerIPs(playerUUID);
        for (String ip : playerIPs) {
            this.unbanIP(ip);
        }
        return playerIPs.size();
    }
}

