/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.protectcord.forge.ProtectCordMod;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ProtectCordCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"protectcord").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(context -> ProtectCordCommand.executeReload((CommandContext<CommandSourceStack>)context)))).then(Commands.m_82127_((String)"stats").executes(context -> ProtectCordCommand.executeStats((CommandContext<CommandSourceStack>)context)))).then(Commands.m_82127_((String)"version").executes(context -> ProtectCordCommand.executeVersion((CommandContext<CommandSourceStack>)context)))).then(Commands.m_82127_((String)"list").executes(context -> ProtectCordCommand.executeList((CommandContext<CommandSourceStack>)context)))).then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"target", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeCheck((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"target")))))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeKick((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"warn").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ProtectCordCommand.executeWarn((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"reason"))))))).then(Commands.m_82127_((String)"warnings").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeWarnings((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"ban").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ProtectCordCommand.executeBan((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"reason"))))))).then(Commands.m_82127_((String)"unban").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeUnban((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"whitelist").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeWhitelistAdd((CommandContext<CommandSourceStack>)context, "player", StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"uuid").then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeWhitelistAdd((CommandContext<CommandSourceStack>)context, "uuid", StringArgumentType.getString((CommandContext)context, (String)"uuid")))))).then(Commands.m_82127_((String)"ip").then(Commands.m_82129_((String)"ip", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeWhitelistAdd((CommandContext<CommandSourceStack>)context, "ip", StringArgumentType.getString((CommandContext)context, (String)"ip"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeWhitelistRemove((CommandContext<CommandSourceStack>)context, "player", StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"uuid").then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeWhitelistRemove((CommandContext<CommandSourceStack>)context, "uuid", StringArgumentType.getString((CommandContext)context, (String)"uuid")))))).then(Commands.m_82127_((String)"ip").then(Commands.m_82129_((String)"ip", (ArgumentType)StringArgumentType.string()).executes(context -> ProtectCordCommand.executeWhitelistRemove((CommandContext<CommandSourceStack>)context, "ip", StringArgumentType.getString((CommandContext)context, (String)"ip")))))))).executes(context -> ProtectCordCommand.executeHelp((CommandContext<CommandSourceStack>)context)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pc").requires(source -> source.m_6761_(2))).redirect((CommandNode)dispatcher.register(Commands.m_82127_((String)"protectcord"))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"protect").requires(source -> source.m_6761_(2))).redirect((CommandNode)dispatcher.register(Commands.m_82127_((String)"protectcord"))));
    }

    private static int executeReload(CommandContext<CommandSourceStack> context) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        mod.getConfigManager().reloadConfig();
        mod.getWhitelistManager().reloadWhitelist();
        mod.getWarnManager().reloadWarnings();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aProtectCord configuration reloaded!"), true);
        return 1;
    }

    private static int executeHelp(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== ProtectCord Commands ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord reload \u00a77- Reload configuration"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord whitelist add <player|uuid|ip> <value> \u00a77- Add to whitelist"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord whitelist remove <player|uuid|ip> <value> \u00a77- Remove from whitelist"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord list \u00a77- List whitelisted entries"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord check <player|ip> \u00a77- Check an IP address"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord kick <player> \u00a77- Kick player with IP analysis"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord warn <player> <reason> \u00a77- Warn a player"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord warnings <player> \u00a77- View player warnings"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord ban <player> <reason> \u00a77- Ban a player"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord unban <player> \u00a77- Unban a player"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord stats \u00a77- View API statistics"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7e/protectcord version \u00a77- View version information"), false);
        return 1;
    }

    private static int executeList(CommandContext<CommandSourceStack> context) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== ProtectCord Whitelist ==="), false);
        List<String> players = mod.getWhitelistManager().getWhitelistedPlayers();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eWhitelisted Players \u00a77(" + players.size() + ")\u00a7e:")), false);
        if (players.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"  \u00a77None"), false);
        } else {
            for (String string : players) {
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a7f- " + string)), false);
            }
        }
        List<String> uuids = mod.getWhitelistManager().getWhitelistedUUIDs();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eWhitelisted UUIDs \u00a77(" + uuids.size() + ")\u00a7e:")), false);
        if (uuids.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"  \u00a77None"), false);
        } else {
            for (String uuid : uuids) {
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a7f- " + uuid)), false);
            }
        }
        List<String> list = mod.getWhitelistManager().getWhitelistedIPs();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eWhitelisted IPs \u00a77(" + ips.size() + ")\u00a7e:")), false);
        if (list.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"  \u00a77None"), false);
        } else {
            for (String ip : list) {
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a7f- " + ip)), false);
            }
        }
        return 1;
    }

    private static int executeCheck(CommandContext<CommandSourceStack> context, String target) {
        String ipToCheck;
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = null;
        try {
            player = source.m_81377_().m_6846_().m_11255_(target);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (player != null) {
            ipToCheck = player.f_8906_.f_9742_.m_129523_().toString().split(":")[0].replace("/", "");
            ServerPlayer finalPlayer = player;
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eChecking IP for player \u00a7f" + finalPlayer.m_7755_().getString() + "\u00a7e...")), false);
        } else {
            ipToCheck = target;
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eChecking IP \u00a7f" + target + "\u00a7e...")), false);
        }
        mod.getAPI().checkIP(ipToCheck).thenAccept(result -> {
            if (result == null) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7cFailed to check IP. API error."), false);
                return;
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== IP Check Results ==="), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eIP Address: \u00a7f" + result.getIpAddress())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eRisk Level: \u00a7f" + result.getRiskLevel())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eCountry: \u00a7f" + result.getCountry())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eCity: \u00a7f" + result.getCity())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eCompany: \u00a7f" + result.getCompany())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eVPN: \u00a7f" + (result.isVPN() ? "Yes" : "No"))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eProxy: \u00a7f" + (result.isProxy() ? "Yes" : "No"))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eDatacenter: \u00a7f" + (result.isDatacenter() ? "Yes" : "No"))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eBogon: \u00a7f" + (result.isBogon() ? "Yes" : "No"))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTor: \u00a7f" + (result.isTor() ? "Yes" : "No"))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7eMobile: \u00a7f" + (result.isMobile() ? "Yes" : "No"))), false);
        });
        return 1;
    }

    private static int executeStats(CommandContext<CommandSourceStack> context) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eLoading API statistics..."), false);
        mod.getAPI().getStatistics().thenAccept(stats -> {
            if (stats == null) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7cFailed to fetch API statistics."), false);
                return;
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== API Statistics (Global) ==="), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7ePlan: \u00a7f" + (String)stats.get("plan"))), false);
            if (stats.get("rate_limit") != null && !((String)stats.get("rate_limit")).isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7eRate Limit: \u00a7f" + (String)stats.get("rate_limit") + " req/min")), false);
            }
            if (stats.containsKey("today_total_requests")) {
                source.m_288197_(() -> Component.m_237113_((String)""), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== Today's Usage ==="), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTotal Requests: \u00a7f" + (String)stats.get("today_total_requests"))), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7eCached Hits: \u00a7f" + (String)stats.get("today_cached_hits"))), false);
            }
            if (stats.containsKey("total_requests")) {
                source.m_288197_(() -> Component.m_237113_((String)""), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== All-Time Usage ==="), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTotal Requests: \u00a7f" + (String)stats.get("total_requests"))), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTotal Cached Hits: \u00a7f" + (String)stats.get("total_cached_hits"))), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)""), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77For personalized stats, visit:"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7b\u00a7nhttps://protectcord.com"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77Go to Dashboard > API Keys"), false);
        });
        return 1;
    }

    private static int executeVersion(CommandContext<CommandSourceStack> context) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76\u00a7l=== ProtectCord Version Info ==="), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eMod Version: \u00a7f1.0.5-dev"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7ePlatform: \u00a7fForge"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eMinecraft Version: \u00a7f1.20.1"), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7eLoading API version..."), false);
        mod.getAPI().getStatistics().thenAccept(stats -> {
            if (stats != null && stats.containsKey("api_version")) {
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7eAPI Version: \u00a7f" + (String)stats.get("api_version"))), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7eAPI Version: \u00a7cUnavailable"), false);
            }
        });
        return 1;
    }

    private static int executeKick(CommandContext<CommandSourceStack> context, String playerName) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = null;
        try {
            player = source.m_81377_().m_6846_().m_11255_(playerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (player == null) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7cPlayer not found or not online."), false);
            return 0;
        }
        String ipAddress = player.f_8906_.f_9742_.m_129523_().toString().split(":")[0].replace("/", "");
        ServerPlayer finalPlayer = player;
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eKicking \u00a7f" + finalPlayer.m_7755_().getString() + " \u00a7eand checking their IP...")), false);
        ((CompletableFuture)mod.getAPI().checkIP(ipAddress).thenAccept(result -> {
            if (result == null) {
                finalPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"\u00a7c\u00a7lKicked by Administrator\n\u00a77Your connection was manually terminated."));
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7aKicked \u00a7f" + finalPlayer.m_7755_().getString() + " \u00a77(API check failed)")), false);
                return;
            }
            StringBuilder kickMessage = new StringBuilder();
            kickMessage.append("\u00a7c\u00a7lKicked by Administrator\n\n");
            kickMessage.append("\u00a77IP Analysis:\n");
            kickMessage.append("\u00a7eRisk Level: \u00a7f").append(result.getRiskLevel()).append("\n");
            kickMessage.append("\u00a7eCountry: \u00a7f").append(result.getCountry()).append("\n");
            if (result.isVPN()) {
                kickMessage.append("\u00a7c\u2718 VPN Detected\n");
            }
            if (result.isProxy()) {
                kickMessage.append("\u00a7c\u2718 Proxy Detected\n");
            }
            if (result.isTor()) {
                kickMessage.append("\u00a7c\u2718 Tor Detected\n");
            }
            if (result.isDatacenter()) {
                kickMessage.append("\u00a7c\u2718 Datacenter IP\n");
            }
            finalPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)kickMessage.toString()));
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7a\u00a7lKicked \u00a7f" + finalPlayer.m_7755_().getString())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77IP: \u00a7f" + result.getIpAddress())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Risk: \u00a7f" + result.getRiskLevel())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Country: \u00a7f" + result.getCountry())), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77VPN: \u00a7f" + (result.isVPN() ? "\u00a7cYes" : "\u00a7aNo"))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Proxy: \u00a7f" + (result.isProxy() ? "\u00a7cYes" : "\u00a7aNo"))), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77Tor: \u00a7f" + (result.isTor() ? "\u00a7cYes" : "\u00a7aNo"))), false);
        })).exceptionally(ex -> {
            finalPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"\u00a7c\u00a7lKicked by Administrator\n\u00a77Your connection was manually terminated."));
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7aKicked \u00a7f" + finalPlayer.m_7755_().getString() + " \u00a77(Error checking IP)")), false);
            return null;
        });
        return 1;
    }

    private static int executeWhitelistAdd(CommandContext<CommandSourceStack> context, String type, String value) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        switch (type) {
            case "player": {
                mod.getWhitelistManager().addPlayer(value);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7aAdded player \u00a7f" + value + " \u00a7ato whitelist.")), true);
                break;
            }
            case "uuid": {
                try {
                    UUID uuid = UUID.fromString(value);
                    mod.getWhitelistManager().addUUID(uuid);
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a7aAdded UUID \u00a7f" + value + " \u00a7ato whitelist.")), true);
                }
                catch (IllegalArgumentException e) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7cInvalid UUID format."), false);
                }
                break;
            }
            case "ip": {
                mod.getWhitelistManager().addIP(value);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7aAdded IP \u00a7f" + value + " \u00a7ato whitelist.")), true);
            }
        }
        return 1;
    }

    private static int executeWhitelistRemove(CommandContext<CommandSourceStack> context, String type, String value) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        switch (type) {
            case "player": {
                mod.getWhitelistManager().removePlayer(value);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7aRemoved player \u00a7f" + value + " \u00a7afrom whitelist.")), true);
                break;
            }
            case "uuid": {
                try {
                    UUID uuid = UUID.fromString(value);
                    mod.getWhitelistManager().removeUUID(uuid);
                    source.m_288197_(() -> Component.m_237113_((String)("\u00a7aRemoved UUID \u00a7f" + value + " \u00a7afrom whitelist.")), true);
                }
                catch (IllegalArgumentException e) {
                    source.m_288197_(() -> Component.m_237113_((String)"\u00a7cInvalid UUID format."), false);
                }
                break;
            }
            case "ip": {
                mod.getWhitelistManager().removeIP(value);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7aRemoved IP \u00a7f" + value + " \u00a7afrom whitelist.")), true);
            }
        }
        return 1;
    }

    private static int executeWarn(CommandContext<CommandSourceStack> context, String playerName, String reason) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer target = null;
        try {
            target = source.m_81377_().m_6846_().m_11255_(playerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (target == null) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7cPlayer not found or not online."), false);
            return 0;
        }
        UUID targetUUID = target.m_20148_();
        String issuer = source.m_81368_();
        mod.getWarnManager().addWarning(targetUUID, reason, issuer);
        int warningCount = mod.getWarnManager().getWarningCount(targetUUID);
        ServerPlayer finalTarget = target;
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7aWarned \u00a7f" + finalTarget.m_7755_().getString() + " \u00a7afor: \u00a7f" + reason)), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Warning count: \u00a7f" + warningCount + "/3")), false);
        if (warningCount == 1) {
            target.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u00a7l[WARNING]"));
            target.m_213846_((Component)Component.m_237113_((String)("\u00a7eYou have been warned by " + issuer)));
            target.m_213846_((Component)Component.m_237113_((String)("\u00a7eReason: \u00a7f" + reason)));
            target.m_213846_((Component)Component.m_237113_((String)"\u00a7cPlease behave or further action will be taken."));
            target.m_213846_((Component)Component.m_237113_((String)"\u00a77Warning: 1/3"));
        } else if (warningCount == 2) {
            StringBuilder kickMessage = new StringBuilder();
            kickMessage.append("\u00a7c\u00a7l[FINAL WARNING - KICKED]\n\n");
            kickMessage.append("\u00a7eYou have been kicked by ").append(issuer).append("\n");
            kickMessage.append("\u00a7eReason: \u00a7f").append(reason).append("\n\n");
            kickMessage.append("\u00a7c\u00a7lYou have ONE more chance!\n");
            kickMessage.append("\u00a7cOne more warning and you will be \u00a74\u00a7lPERMANENTLY BANNED\u00a7c!\n\n");
            kickMessage.append("\u00a77Warnings: 2/3");
            target.f_8906_.m_9942_((Component)Component.m_237113_((String)kickMessage.toString()));
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7e" + finalTarget.m_7755_().getString() + " has been kicked (2nd warning)")), false);
        } else if (warningCount >= 3) {
            List<Map<String, Object>> warnings = mod.getWarnManager().getWarningsList(targetUUID);
            List<String> reasons = warnings.stream().map(w -> (String)w.get("reason")).collect(Collectors.toList());
            mod.getWarnManager().banPlayer(targetUUID, reasons);
            StringBuilder banMessage = new StringBuilder();
            banMessage.append("\u00a74\u00a7l[PERMANENTLY BANNED]\n\n");
            banMessage.append("\u00a7cYou have been banned for receiving 3 warnings.\n\n");
            banMessage.append("\u00a7e\u00a7lYour warnings:\n");
            for (int i = 0; i < warnings.size(); ++i) {
                Map<String, Object> warning = warnings.get(i);
                banMessage.append("\u00a77").append(i + 1).append(". \u00a7f").append(warning.get("reason")).append("\n");
            }
            banMessage.append("\n\u00a77This ban is permanent and cannot be appealed automatically.");
            target.f_8906_.m_9942_((Component)Component.m_237113_((String)banMessage.toString()));
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7c\u00a7l" + finalTarget.m_7755_().getString() + " has been BANNED (3rd warning - automatic ban)")), false);
        }
        return 1;
    }

    private static int executeWarnings(CommandContext<CommandSourceStack> context, String playerName) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer target = null;
        try {
            target = source.m_81377_().m_6846_().m_11255_(playerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (target == null) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7cPlayer not found or not online. Note: This command only works for online players."), false);
            return 0;
        }
        UUID targetUUID = target.m_20148_();
        List<Map<String, Object>> warnings = mod.getWarnManager().getWarningsList(targetUUID);
        boolean isBanned = mod.getWarnManager().isBanned(targetUUID);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a76\u00a7l=== Warnings for " + playerName + " ===")), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eTotal Warnings: \u00a7f" + warnings.size())), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7eBanned: \u00a7f" + (isBanned ? "\u00a7cYes" : "\u00a7aNo"))), false);
        if (warnings.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77No warnings found."), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)""), false);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            int i = 0;
            while (i < warnings.size()) {
                Map<String, Object> warning = warnings.get(i);
                long timestamp = ((Number)warning.get("timestamp")).longValue();
                String reason = (String)warning.get("reason");
                String issuer = (String)warning.get("issuer");
                String date = dateFormat.format(new Date(timestamp));
                int index = i++;
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7e#" + (index + 1) + " \u00a77- \u00a7f" + date)), false);
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a77Reason: \u00a7f" + reason)), false);
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a77Warned by: \u00a7f" + issuer)), false);
            }
        }
        return 1;
    }

    private static int executeBan(CommandContext<CommandSourceStack> context, String playerName, String reason) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer target = null;
        try {
            target = source.m_81377_().m_6846_().m_11255_(playerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (target == null) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7cPlayer not found or not online."), false);
            return 0;
        }
        UUID targetUUID = target.m_20148_();
        ArrayList<String> reasons = new ArrayList<String>();
        reasons.add(reason);
        mod.getWarnManager().banPlayer(targetUUID, reasons);
        StringBuilder banMessage = new StringBuilder();
        banMessage.append("\u00a74\u00a7l[BANNED]\n\n");
        banMessage.append("\u00a7cYou have been banned by an administrator.\n");
        banMessage.append("\u00a7eReason: \u00a7f").append(reason).append("\n\n");
        banMessage.append("\u00a77This ban is permanent.");
        ServerPlayer finalTarget = target;
        target.f_8906_.m_9942_((Component)Component.m_237113_((String)banMessage.toString()));
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7c" + finalTarget.m_7755_().getString() + " has been banned.")), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Reason: \u00a7f" + reason)), false);
        return 1;
    }

    private static int executeUnban(CommandContext<CommandSourceStack> context, String playerName) {
        ProtectCordMod mod = ProtectCordMod.getInstance();
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer target = null;
        try {
            target = source.m_81377_().m_6846_().m_11255_(playerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (target == null) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7cPlayer not found or not online. Note: This command only works for online players."), false);
            return 0;
        }
        UUID targetUUID = target.m_20148_();
        if (!mod.getWarnManager().isBanned(targetUUID)) {
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7c" + playerName + " is not banned.")), false);
            return 0;
        }
        mod.getWarnManager().unbanPlayer(targetUUID);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7a" + playerName + " has been unbanned.")), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Note: Their warnings have not been cleared. Use \u00a7e/protectcord clearwarnings " + playerName + " \u00a77to clear warnings.")), false);
        return 1;
    }
}

