/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge.listener;

import com.mojang.authlib.GameProfile;
import com.protectcord.forge.ProtectCordMod;
import com.protectcord.forge.api.IPCheckResult;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerConnectionListener {
    private final ProtectCordMod mod;

    public PlayerConnectionListener(ProtectCordMod mod) {
        this.mod = mod;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        GameProfile profile = player.m_36316_();
        String playerName = profile.getName();
        String uuid = profile.getId().toString();
        if (this.mod.getWarnManager().isBanned(profile.getId())) {
            List<String> banReasons = this.mod.getWarnManager().getBanReasons(profile.getId());
            StringBuilder banMessage = new StringBuilder();
            banMessage.append("\u00a74\u00a7l[BANNED]\n\n");
            banMessage.append("\u00a7cYou are banned from this server.\n\n");
            if (!banReasons.isEmpty()) {
                banMessage.append("\u00a7e\u00a7lReasons:\n");
                for (int i = 0; i < banReasons.size(); ++i) {
                    banMessage.append("\u00a77").append(i + 1).append(". \u00a7f").append(banReasons.get(i)).append("\n");
                }
            }
            banMessage.append("\n\u00a77This ban is permanent.");
            player.f_8906_.m_9942_((Component)Component.m_237113_((String)banMessage.toString()));
            this.mod.getLogger().info("Banned player " + playerName + " attempted to join.");
            return;
        }
        if (!this.mod.getConfigManager().isCheckEnabled()) {
            return;
        }
        SocketAddress socketAddress = player.f_8906_.f_9742_.m_129523_();
        if (!(socketAddress instanceof InetSocketAddress)) {
            return;
        }
        InetSocketAddress inetAddress = (InetSocketAddress)socketAddress;
        InetAddress address = inetAddress.getAddress();
        String ipAddress = address.getHostAddress();
        if (address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress()) {
            this.mod.getLogger().info("Player " + playerName + " bypassed IP check (local/private IP: " + ipAddress + ")");
            return;
        }
        if (this.mod.getWhitelistManager().isWhitelisted(playerName, profile.getId(), ipAddress)) {
            this.mod.getLogger().info("Player " + playerName + " bypassed IP check (whitelisted)");
            this.mod.getWebhookManager().sendWhitelistedWebhook(playerName, uuid, ipAddress);
            return;
        }
        ((CompletableFuture)this.mod.getAPI().checkIP(ipAddress).thenAccept(result -> {
            if (result == null) {
                String errorMessage = this.mod.getConfigManager().getMessage("api-error");
                this.mod.getLogger().warn("Failed to check IP for " + playerName + " (" + ipAddress + ")");
                this.mod.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, "API returned null result");
                return;
            }
            boolean shouldBlock = false;
            Object reason = "";
            if (this.mod.getConfigManager().isGeoBlockingEnabled()) {
                String countryCode = result.getCountryCode();
                String mode = this.mod.getConfigManager().getGeoBlockingMode();
                List<String> countries = this.mod.getConfigManager().getGeoBlockingCountries();
                if (mode.equalsIgnoreCase("blacklist") && countries.contains(countryCode)) {
                    shouldBlock = true;
                    reason = "Country blocked (" + result.getCountry() + ")";
                } else if (mode.equalsIgnoreCase("whitelist") && !countries.contains(countryCode)) {
                    shouldBlock = true;
                    reason = "Country not whitelisted (" + result.getCountry() + ")";
                }
            }
            if (!shouldBlock && result.isBogon() && this.mod.getConfigManager().shouldBlockBogon()) {
                shouldBlock = true;
                reason = "Bogon IP address";
            } else if (!shouldBlock && result.isTor() && this.mod.getConfigManager().shouldBlockTor()) {
                shouldBlock = true;
                reason = "Tor exit node detected";
            } else if (!shouldBlock && result.isVPN() && this.mod.getConfigManager().shouldBlockVPN()) {
                shouldBlock = true;
                reason = "VPN detected";
            } else if (!shouldBlock && result.isProxy() && this.mod.getConfigManager().shouldBlockProxy()) {
                shouldBlock = true;
                reason = "Proxy detected";
            } else if (!shouldBlock && result.isDatacenter() && this.mod.getConfigManager().shouldBlockDatacenter()) {
                shouldBlock = true;
                reason = "Datacenter IP";
            }
            if (!shouldBlock && this.mod.getConfigManager().isRiskLevelBlockingEnabled()) {
                String blockedRiskLevel = this.mod.getConfigManager().getBlockedRiskLevel();
                if (blockedRiskLevel.equals("HIGH") && (result.getRiskLevel().equals("HIGH") || result.getRiskLevel().equals("CRITICAL"))) {
                    shouldBlock = true;
                    reason = "High risk IP (" + result.getRiskLevel() + ")";
                } else if (blockedRiskLevel.equals("MEDIUM") && !result.getRiskLevel().equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                    shouldBlock = true;
                    reason = "Medium+ risk IP (" + result.getRiskLevel() + ")";
                } else if (blockedRiskLevel.equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                    shouldBlock = true;
                    reason = "Risk detected (" + result.getRiskLevel() + ")";
                }
            }
            if (shouldBlock) {
                String kickMessage = this.mod.getConfigManager().getMessage("connection-denied").replace("{reason}", (CharSequence)reason).replace("{risk}", result.getRiskLevel());
                player.f_8906_.m_9942_((Component)Component.m_237113_((String)kickMessage));
                this.mod.getLogger().warn("Blocked " + playerName + " (" + ipAddress + ") - " + (String)reason);
                this.mod.getWebhookManager().sendDeniedWebhook(playerName, uuid, ipAddress, (IPCheckResult)result);
            } else {
                this.mod.getLogger().info("Allowed " + playerName + " (" + ipAddress + ") - Risk: " + result.getRiskLevel());
                this.mod.getWebhookManager().sendAcceptedWebhook(playerName, uuid, ipAddress, (IPCheckResult)result);
            }
        })).exceptionally(e -> {
            this.mod.getLogger().error("Error checking IP for " + playerName + ": " + e.getMessage());
            this.mod.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, e.getMessage());
            return null;
        });
    }
}

