/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge.warn;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.protectcord.forge.ProtectCordMod;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;

public class WarnManager {
    private final ProtectCordMod mod;
    private CommentedFileConfig warningsConfig;
    private Path warningsPath;

    public WarnManager(ProtectCordMod mod) {
        this.mod = mod;
        this.loadWarnings();
    }

    private void loadWarnings() {
        this.warningsPath = FMLPaths.CONFIGDIR.get().resolve("protectcord-warnings.toml");
        this.warningsConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.warningsPath).sync().autosave().build();
        this.warningsConfig.load();
        if (!this.warningsConfig.contains("players")) {
            HashMap emptyMap = new HashMap();
            this.warningsConfig.set("players", emptyMap);
            this.warningsConfig.save();
        }
    }

    public void saveWarnings() {
        this.warningsConfig.save();
    }

    public void reloadWarnings() {
        this.warningsConfig.load();
    }

    public void addWarning(UUID playerUUID, String reason, String issuer) {
        String path = "players." + playerUUID.toString();
        List<Map<String, Object>> warnings = this.getWarningsList(playerUUID);
        HashMap<String, Object> warning = new HashMap<String, Object>();
        warning.put("timestamp", System.currentTimeMillis());
        warning.put("reason", reason);
        warning.put("issuer", issuer);
        warnings.add(warning);
        this.warningsConfig.set(path + ".warnings", warnings);
        this.saveWarnings();
    }

    public List<Map<String, Object>> getWarningsList(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".warnings";
        Object warningsObj = this.warningsConfig.get(path);
        if (warningsObj instanceof List) {
            return (List)warningsObj;
        }
        return new ArrayList<Map<String, Object>>();
    }

    public int getWarningCount(UUID playerUUID) {
        return this.getWarningsList(playerUUID).size();
    }

    public boolean isBanned(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.banned";
        Object banned = this.warningsConfig.get(path);
        return banned instanceof Boolean && (Boolean)banned != false;
    }

    public void banPlayer(UUID playerUUID, List<String> reasons) {
        String path = "players." + playerUUID.toString() + ".ban";
        HashMap<String, Object> banData = new HashMap<String, Object>();
        banData.put("banned", true);
        banData.put("timestamp", System.currentTimeMillis());
        banData.put("reasons", reasons);
        this.warningsConfig.set(path, banData);
        this.saveWarnings();
    }

    public void unbanPlayer(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.banned";
        this.warningsConfig.set(path, (Object)false);
        this.saveWarnings();
    }

    public List<String> getBanReasons(UUID playerUUID) {
        String path = "players." + playerUUID.toString() + ".ban.reasons";
        Object reasons = this.warningsConfig.get(path);
        if (reasons instanceof List) {
            return (List)reasons;
        }
        return new ArrayList<String>();
    }

    public void clearWarnings(UUID playerUUID) {
        String path = "players." + playerUUID.toString();
        this.warningsConfig.remove(path);
        this.saveWarnings();
    }

    public Map<String, Object> getPlayerData(UUID playerUUID) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("warnings", this.getWarningsList(playerUUID));
        data.put("warningCount", this.getWarningCount(playerUUID));
        data.put("banned", this.isBanned(playerUUID));
        data.put("banReasons", this.getBanReasons(playerUUID));
        return data;
    }
}

