/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.forge.whitelist;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.protectcord.forge.ProtectCordMod;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraftforge.fml.loading.FMLPaths;

public class WhitelistManager {
    private final ProtectCordMod mod;
    private CommentedFileConfig whitelistConfig;
    private Path whitelistPath;

    public WhitelistManager(ProtectCordMod mod) {
        this.mod = mod;
        this.loadWhitelist();
    }

    private void loadWhitelist() {
        this.whitelistPath = FMLPaths.CONFIGDIR.get().resolve("protectcord-whitelist.toml");
        this.whitelistConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.whitelistPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        this.whitelistConfig.load();
        if (!this.whitelistConfig.contains("whitelisted-players")) {
            this.whitelistConfig.set("whitelisted-players", new ArrayList());
        }
        if (!this.whitelistConfig.contains("whitelisted-uuids")) {
            this.whitelistConfig.set("whitelisted-uuids", new ArrayList());
        }
        if (!this.whitelistConfig.contains("whitelisted-ips")) {
            this.whitelistConfig.set("whitelisted-ips", new ArrayList());
        }
        this.whitelistConfig.save();
    }

    public void reloadWhitelist() {
        if (this.whitelistConfig != null) {
            this.whitelistConfig.load();
        }
    }

    public boolean isWhitelisted(String playerName, UUID uuid, String ipAddress) {
        List whitelistedPlayers = (List)this.whitelistConfig.getOrElse("whitelisted-players", new ArrayList());
        List whitelistedUUIDs = (List)this.whitelistConfig.getOrElse("whitelisted-uuids", new ArrayList());
        List whitelistedIPs = (List)this.whitelistConfig.getOrElse("whitelisted-ips", new ArrayList());
        return whitelistedPlayers.contains(playerName.toLowerCase()) || whitelistedUUIDs.contains(uuid.toString()) || whitelistedIPs.contains(ipAddress);
    }

    public void addPlayer(String playerName) {
        List whitelistedPlayers = (List)this.whitelistConfig.getOrElse("whitelisted-players", new ArrayList());
        if (!whitelistedPlayers.contains(playerName.toLowerCase())) {
            whitelistedPlayers.add(playerName.toLowerCase());
            this.whitelistConfig.set("whitelisted-players", (Object)whitelistedPlayers);
            this.whitelistConfig.save();
        }
    }

    public void removePlayer(String playerName) {
        List whitelistedPlayers = (List)this.whitelistConfig.getOrElse("whitelisted-players", new ArrayList());
        whitelistedPlayers.remove(playerName.toLowerCase());
        this.whitelistConfig.set("whitelisted-players", (Object)whitelistedPlayers);
        this.whitelistConfig.save();
    }

    public void addUUID(UUID uuid) {
        List whitelistedUUIDs = (List)this.whitelistConfig.getOrElse("whitelisted-uuids", new ArrayList());
        if (!whitelistedUUIDs.contains(uuid.toString())) {
            whitelistedUUIDs.add(uuid.toString());
            this.whitelistConfig.set("whitelisted-uuids", (Object)whitelistedUUIDs);
            this.whitelistConfig.save();
        }
    }

    public void removeUUID(UUID uuid) {
        List whitelistedUUIDs = (List)this.whitelistConfig.getOrElse("whitelisted-uuids", new ArrayList());
        whitelistedUUIDs.remove(uuid.toString());
        this.whitelistConfig.set("whitelisted-uuids", (Object)whitelistedUUIDs);
        this.whitelistConfig.save();
    }

    public void addIP(String ipAddress) {
        List whitelistedIPs = (List)this.whitelistConfig.getOrElse("whitelisted-ips", new ArrayList());
        if (!whitelistedIPs.contains(ipAddress)) {
            whitelistedIPs.add(ipAddress);
            this.whitelistConfig.set("whitelisted-ips", (Object)whitelistedIPs);
            this.whitelistConfig.save();
        }
    }

    public void removeIP(String ipAddress) {
        List whitelistedIPs = (List)this.whitelistConfig.getOrElse("whitelisted-ips", new ArrayList());
        whitelistedIPs.remove(ipAddress);
        this.whitelistConfig.set("whitelisted-ips", (Object)whitelistedIPs);
        this.whitelistConfig.save();
    }

    public List<String> getWhitelistedPlayers() {
        return (List)this.whitelistConfig.getOrElse("whitelisted-players", new ArrayList());
    }

    public List<String> getWhitelistedUUIDs() {
        return (List)this.whitelistConfig.getOrElse("whitelisted-uuids", new ArrayList());
    }

    public List<String> getWhitelistedIPs() {
        return (List)this.whitelistConfig.getOrElse("whitelisted-ips", new ArrayList());
    }
}

