/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.velocity;

import com.google.inject.Inject;
import com.protectcord.velocity.api.ProtectCordAPI;
import com.protectcord.velocity.bstats.velocity.Metrics;
import com.protectcord.velocity.command.ProtectCordCommand;
import com.protectcord.velocity.config.ConfigManager;
import com.protectcord.velocity.listener.PlayerConnectionListener;
import com.protectcord.velocity.update.UpdateChecker;
import com.protectcord.velocity.webhook.WebhookManager;
import com.protectcord.velocity.whitelist.WhitelistManager;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import org.slf4j.Logger;

@Plugin(id="protectcord", name="ProtectCord", version="1.0.2", description="IP Protection plugin for Velocity proxies", authors={"ProtectCord"})
public class ProtectCordPlugin {
    private static ProtectCordPlugin instance;
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private ConfigManager configManager;
    private ProtectCordAPI api;
    private WhitelistManager whitelistManager;
    private WebhookManager webhookManager;

    @Inject
    public ProtectCordPlugin(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
        instance = this;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.logger.info("==========================================");
        this.logger.info("ProtectCord v1.0.2 by ProtectCord");
        this.logger.info("Platform: Velocity | MC: 1.8.8 - 1.21+");
        this.logger.info("https://protectcord.com");
        this.logger.info("==========================================");
        String apiKey = this.configManager.getApiKey();
        if (apiKey == null || apiKey.isEmpty() || apiKey.equals("YOUR_API_KEY_HERE")) {
            this.logger.error("========================================");
            this.logger.error("API KEY NOT CONFIGURED!");
            this.logger.error("Please follow these steps:");
            this.logger.error("1. Go to https://protectcord.com");
            this.logger.error("2. Navigate to Dashboard > API Keys");
            this.logger.error("3. Generate a new API key");
            this.logger.error("4. Add the key to config.toml");
            this.logger.error("5. Restart the proxy");
            this.logger.error("========================================");
            return;
        }
        this.api = new ProtectCordAPI(apiKey);
        this.whitelistManager = new WhitelistManager(this);
        this.webhookManager = new WebhookManager(this);
        this.server.getEventManager().register((Object)this, (Object)new PlayerConnectionListener(this));
        this.server.getCommandManager().register("protectcord", (Command)new ProtectCordCommand(this), new String[]{"pc", "protect"});
        int pluginId = 24623;
        Metrics metrics = this.metricsFactory.make(this, pluginId);
        UpdateChecker updateChecker = new UpdateChecker(this.logger);
        updateChecker.checkForUpdates().thenAccept(updateInfo -> {
            if (updateInfo != null) {
                updateChecker.notifyUpdate((UpdateChecker.UpdateInfo)updateInfo);
            }
        });
        this.logger.info("ProtectCord has been enabled successfully!");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.api != null) {
            this.api.shutdown();
        }
        this.logger.info("ProtectCord has been disabled.");
    }

    public static ProtectCordPlugin getInstance() {
        return instance;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ProtectCordAPI getAPI() {
        return this.api;
    }

    public WhitelistManager getWhitelistManager() {
        return this.whitelistManager;
    }

    public WebhookManager getWebhookManager() {
        return this.webhookManager;
    }

    public String getPluginVersion() {
        return "1.0.2";
    }
}

