/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.velocity.listener;

import com.protectcord.velocity.ProtectCordPlugin;
import com.protectcord.velocity.api.IPCheckResult;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class PlayerConnectionListener {
    private final ProtectCordPlugin plugin;

    public PlayerConnectionListener(ProtectCordPlugin plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onPreLogin(PreLoginEvent event) {
        if (!this.plugin.getConfigManager().isCheckEnabled()) {
            return;
        }
        String playerName = event.getUsername();
        String uuid = event.getUniqueId() != null ? event.getUniqueId().toString() : "unknown";
        InetSocketAddress address = event.getConnection().getRemoteAddress();
        InetAddress inetAddress = address.getAddress();
        String ipAddress = inetAddress.getHostAddress();
        if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
            this.plugin.getLogger().info("Player " + playerName + " bypassed IP check (local/private IP: " + ipAddress + ")");
            return;
        }
        if (event.getUniqueId() != null && this.plugin.getWhitelistManager().isWhitelisted(playerName, event.getUniqueId(), ipAddress)) {
            this.plugin.getLogger().info("Player " + playerName + " bypassed IP check (whitelisted)");
            this.plugin.getWebhookManager().sendWhitelistedWebhook(playerName, uuid, ipAddress);
            return;
        }
        ((CompletableFuture)this.plugin.getAPI().checkIP(ipAddress).thenAccept(result -> {
            if (result == null) {
                this.plugin.getLogger().warn("Failed to check IP for " + playerName + " (" + ipAddress + ")");
                this.plugin.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, "API returned null result");
                return;
            }
            boolean shouldBlock = false;
            Object reason = "";
            if (this.plugin.getConfigManager().isGeoBlockingEnabled()) {
                String countryCode = result.getCountryCode();
                String mode = this.plugin.getConfigManager().getGeoBlockingMode();
                List<String> countries = this.plugin.getConfigManager().getGeoBlockingCountries();
                if (mode.equalsIgnoreCase("blacklist") && countries.contains(countryCode)) {
                    shouldBlock = true;
                    reason = "Country blocked (" + result.getCountry() + ")";
                } else if (mode.equalsIgnoreCase("whitelist") && !countries.contains(countryCode)) {
                    shouldBlock = true;
                    reason = "Country not whitelisted (" + result.getCountry() + ")";
                }
            }
            if (!shouldBlock && result.isBogon() && this.plugin.getConfigManager().shouldBlockBogon()) {
                shouldBlock = true;
                reason = "Bogon IP address";
            } else if (!shouldBlock && result.isTor() && this.plugin.getConfigManager().shouldBlockTor()) {
                shouldBlock = true;
                reason = "Tor exit node detected";
            } else if (!shouldBlock && result.isVPN() && this.plugin.getConfigManager().shouldBlockVPN()) {
                shouldBlock = true;
                reason = "VPN detected";
            } else if (!shouldBlock && result.isProxy() && this.plugin.getConfigManager().shouldBlockProxy()) {
                shouldBlock = true;
                reason = "Proxy detected";
            } else if (!shouldBlock && result.isDatacenter() && this.plugin.getConfigManager().shouldBlockDatacenter()) {
                shouldBlock = true;
                reason = "Datacenter IP";
            }
            if (!shouldBlock && this.plugin.getConfigManager().isRiskLevelBlockingEnabled()) {
                String blockedRiskLevel = this.plugin.getConfigManager().getBlockedRiskLevel();
                if (blockedRiskLevel.equals("HIGH") && (result.getRiskLevel().equals("HIGH") || result.getRiskLevel().equals("CRITICAL"))) {
                    shouldBlock = true;
                    reason = "High risk IP (" + result.getRiskLevel() + ")";
                } else if (blockedRiskLevel.equals("MEDIUM") && !result.getRiskLevel().equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                    shouldBlock = true;
                    reason = "Medium+ risk IP (" + result.getRiskLevel() + ")";
                } else if (blockedRiskLevel.equals("LOW") && !result.getRiskLevel().equals("UNKNOWN")) {
                    shouldBlock = true;
                    reason = "Risk detected (" + result.getRiskLevel() + ")";
                }
            }
            if (shouldBlock) {
                String kickMessage = this.plugin.getConfigManager().getMessage("connection-denied").replace("{reason}", (CharSequence)reason).replace("{risk}", result.getRiskLevel());
                TextComponent kickComponent = LegacyComponentSerializer.legacySection().deserialize(kickMessage);
                event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)kickComponent));
                this.plugin.getLogger().warn("Blocked " + playerName + " (" + ipAddress + ") - " + (String)reason);
                this.plugin.getWebhookManager().sendDeniedWebhook(playerName, uuid, ipAddress, (IPCheckResult)result);
            } else {
                this.plugin.getLogger().info("Allowed " + playerName + " (" + ipAddress + ") - Risk: " + result.getRiskLevel());
                this.plugin.getWebhookManager().sendAcceptedWebhook(playerName, uuid, ipAddress, (IPCheckResult)result);
            }
        })).exceptionally(throwable -> {
            this.plugin.getLogger().error("Error checking IP for " + playerName + ": " + throwable.getMessage());
            this.plugin.getWebhookManager().sendErrorWebhook(playerName, uuid, ipAddress, throwable.getMessage());
            return null;
        });
    }
}

