/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.velocity.update;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class UpdateChecker {
    private static final String UPDATE_URL = "https://api.protectcord.com/plugin-version";
    private static final String PLATFORM = "velocity";
    private final Logger logger;
    private final Gson gson;
    private final String currentVersion;

    public UpdateChecker(Logger logger, String currentVersion) {
        this.logger = logger;
        this.gson = new Gson();
        this.currentVersion = currentVersion;
    }

    public CompletableFuture<UpdateInfo> checkForUpdates() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URL(UPDATE_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                conn.setRequestProperty("User-Agent", "ProtectCord-Velocity/" + this.currentVersion);
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    JsonObject json = this.gson.fromJson(response.toString(), JsonObject.class);
                    JsonObject versions = json.getAsJsonObject("versions");
                    String latestVersion = versions.get(PLATFORM).getAsString();
                    String downloadUrl = json.get("download_url").getAsString();
                    String updateMessage = json.get("update_message").getAsString();
                    boolean updateAvailable = !latestVersion.equals(this.currentVersion);
                    return new UpdateInfo(latestVersion, this.currentVersion, updateAvailable, downloadUrl, updateMessage);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to check for updates: " + e.getMessage());
            }
            return null;
        });
    }

    public void notifyUpdate(UpdateInfo updateInfo) {
        if (updateInfo != null && updateInfo.isUpdateAvailable()) {
            this.logger.info("========================================");
            this.logger.info("ProtectCord Update Available!");
            this.logger.info("Current Version: " + updateInfo.getCurrentVersion());
            this.logger.info("Latest Version: " + updateInfo.getLatestVersion());
            this.logger.info("Download: " + updateInfo.getDownloadUrl());
            this.logger.info("========================================");
        }
    }

    public static class UpdateInfo {
        private final String latestVersion;
        private final String currentVersion;
        private final boolean updateAvailable;
        private final String downloadUrl;
        private final String updateMessage;

        public UpdateInfo(String latestVersion, String currentVersion, boolean updateAvailable, String downloadUrl, String updateMessage) {
            this.latestVersion = latestVersion;
            this.currentVersion = currentVersion;
            this.updateAvailable = updateAvailable;
            this.downloadUrl = downloadUrl;
            this.updateMessage = updateMessage;
        }

        public String getLatestVersion() {
            return this.latestVersion;
        }

        public String getCurrentVersion() {
            return this.currentVersion;
        }

        public boolean isUpdateAvailable() {
            return this.updateAvailable;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public String getUpdateMessage() {
            return this.updateMessage;
        }
    }
}

