/*
 * Decompiled with CFR 0.152.
 */
package com.protectcord.paper.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.protectcord.paper.api.IPCheckResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.Bukkit;

public class ProtectCordAPI {
    private static final String BASE_URL = "https://api.protectcord.com";
    private final String apiKey;
    private final ExecutorService executor;
    private final Gson gson;

    public ProtectCordAPI(String apiKey) {
        this.apiKey = apiKey;
        this.executor = Executors.newCachedThreadPool();
        this.gson = new Gson();
    }

    public CompletableFuture<IPCheckResult> checkIP(String ipAddress) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String urlString = "https://api.protectcord.com/checkip/" + ipAddress + "?key=" + this.apiKey;
                URL url = new URL(urlString);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    try {
                        JsonObject json = (JsonObject)this.gson.fromJson(response.toString(), JsonObject.class);
                        return IPCheckResult.fromJson(json);
                    }
                    catch (Exception parseError) {
                        Bukkit.getLogger().severe("Failed to parse API response: " + response.toString());
                        return null;
                    }
                }
                try (BufferedReader in = new BufferedReader(new InputStreamReader(responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream()));){
                    String line;
                    StringBuilder errorResponse = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        errorResponse.append(line);
                    }
                    Bukkit.getLogger().warning("ProtectCord API returned status " + responseCode + ": " + errorResponse.toString());
                }
                catch (Exception readError) {
                    Bukkit.getLogger().warning("ProtectCord API returned status code: " + responseCode);
                }
                return null;
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("Error checking IP with ProtectCord API: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }, this.executor);
    }

    public CompletableFuture<Map<String, String>> getStatistics() {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject json;
            String line;
            StringBuilder response;
            BufferedReader in;
            int responseCode;
            HttpURLConnection conn;
            URL url;
            HashMap<String, String> stats = new HashMap<String, String>();
            stats.put("plan", "Free");
            stats.put("rate_limit", "32");
            try {
                String statsUrl = "https://api.protectcord.com/stats";
                url = new URL(statsUrl);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    json = (JsonObject)this.gson.fromJson(response.toString(), JsonObject.class);
                    if (json.has("usage_today")) {
                        JsonObject usageToday = json.getAsJsonObject("usage_today");
                        if (usageToday.has("total_requests")) {
                            stats.put("today_total_requests", String.valueOf(usageToday.get("total_requests").getAsInt()));
                        }
                        if (usageToday.has("cached_hits")) {
                            stats.put("today_cached_hits", String.valueOf(usageToday.get("cached_hits").getAsInt()));
                        }
                    }
                    if (json.has("usage_all_time")) {
                        JsonObject usageAllTime = json.getAsJsonObject("usage_all_time");
                        if (usageAllTime.has("total_requests")) {
                            stats.put("total_requests", String.valueOf(usageAllTime.get("total_requests").getAsInt()));
                        }
                        if (usageAllTime.has("total_cached_hits")) {
                            stats.put("total_cached_hits", String.valueOf(usageAllTime.get("total_cached_hits").getAsInt()));
                        }
                    }
                }
            }
            catch (Exception statsUrl) {
                // empty catch block
            }
            try {
                String healthUrl = "https://api.protectcord.com/health";
                url = new URL(healthUrl);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    json = (JsonObject)this.gson.fromJson(response.toString(), JsonObject.class);
                    stats.put("api_status", json.has("status") ? json.get("status").getAsString() : "Unknown");
                    stats.put("api_version", json.has("version") ? json.get("version").getAsString() : "Unknown");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return stats.isEmpty() ? null : stats;
        }, this.executor);
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

