/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.arena;

import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.arena.GameBoundary;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/hideandseek/arena/Arena;", "", "name", "", "displayName", "world", "Lorg/bukkit/World;", "boundaries", "Lcom/hideandseek/arena/ArenaBoundaries;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/bukkit/World;Lcom/hideandseek/arena/ArenaBoundaries;)V", "getName", "()Ljava/lang/String;", "getDisplayName", "getWorld", "()Lorg/bukkit/World;", "getBoundaries", "()Lcom/hideandseek/arena/ArenaBoundaries;", "isInBounds", "", "location", "Lorg/bukkit/Location;", "getCircularBoundary", "Lcom/hideandseek/arena/GameBoundary;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "EasyHideAndSeek"})
public final class Arena {
    @NotNull
    private final String name;
    @NotNull
    private final String displayName;
    @NotNull
    private final World world;
    @NotNull
    private final ArenaBoundaries boundaries;

    public Arena(@NotNull String name, @NotNull String displayName, @NotNull World world, @NotNull ArenaBoundaries boundaries) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(boundaries, "boundaries");
        this.name = name;
        this.displayName = displayName;
        this.world = world;
        this.boundaries = boundaries;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final ArenaBoundaries getBoundaries() {
        return this.boundaries;
    }

    public final boolean isInBounds(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.boundaries.contains(location);
    }

    @NotNull
    public final GameBoundary getCircularBoundary() {
        Location center = this.boundaries.getCenter();
        int radius = (int)(this.boundaries.getSize() / (double)2);
        return new GameBoundary(center.getBlockX(), center.getBlockZ(), radius);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.displayName;
    }

    @NotNull
    public final World component3() {
        return this.world;
    }

    @NotNull
    public final ArenaBoundaries component4() {
        return this.boundaries;
    }

    @NotNull
    public final Arena copy(@NotNull String name, @NotNull String displayName, @NotNull World world, @NotNull ArenaBoundaries boundaries) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(boundaries, "boundaries");
        return new Arena(name, displayName, world, boundaries);
    }

    public static /* synthetic */ Arena copy$default(Arena arena, String string, String string2, World world, ArenaBoundaries arenaBoundaries, int n, Object object) {
        if ((n & 1) != 0) {
            string = arena.name;
        }
        if ((n & 2) != 0) {
            string2 = arena.displayName;
        }
        if ((n & 4) != 0) {
            world = arena.world;
        }
        if ((n & 8) != 0) {
            arenaBoundaries = arena.boundaries;
        }
        return arena.copy(string, string2, world, arenaBoundaries);
    }

    @NotNull
    public String toString() {
        return "Arena(name=" + this.name + ", displayName=" + this.displayName + ", world=" + this.world + ", boundaries=" + this.boundaries + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.displayName.hashCode();
        result = result * 31 + this.world.hashCode();
        result = result * 31 + this.boundaries.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Arena)) {
            return false;
        }
        Arena arena = (Arena)other;
        if (!Intrinsics.areEqual(this.name, arena.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.displayName, arena.displayName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.world, arena.world)) {
            return false;
        }
        return Intrinsics.areEqual(this.boundaries, arena.boundaries);
    }
}

