/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.arena;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/hideandseek/arena/ArenaBoundaries;", "", "pos1", "Lorg/bukkit/Location;", "pos2", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/Location;)V", "getPos1", "()Lorg/bukkit/Location;", "getPos2", "center", "getCenter", "size", "", "getSize", "()D", "contains", "", "location", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "EasyHideAndSeek"})
public final class ArenaBoundaries {
    @NotNull
    private final Location pos1;
    @NotNull
    private final Location pos2;

    public ArenaBoundaries(@NotNull Location pos1, @NotNull Location pos2) {
        Intrinsics.checkNotNullParameter(pos1, "pos1");
        Intrinsics.checkNotNullParameter(pos2, "pos2");
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    @NotNull
    public final Location getPos1() {
        return this.pos1;
    }

    @NotNull
    public final Location getPos2() {
        return this.pos2;
    }

    @NotNull
    public final Location getCenter() {
        return new Location(this.pos1.getWorld(), (this.pos1.getX() + this.pos2.getX()) / (double)2, (this.pos1.getY() + this.pos2.getY()) / (double)2, (this.pos1.getZ() + this.pos2.getZ()) / (double)2);
    }

    public final double getSize() {
        return this.pos1.distance(this.pos2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        if (!Intrinsics.areEqual(location.getWorld(), this.pos1.getWorld())) {
            return false;
        }
        double minX = Math.min(this.pos1.getX(), this.pos2.getX());
        double maxX = Math.max(this.pos1.getX(), this.pos2.getX());
        double minZ = Math.min(this.pos1.getZ(), this.pos2.getZ());
        double maxZ = Math.max(this.pos1.getZ(), this.pos2.getZ());
        double d = location.getX();
        if (!(minX <= d)) return false;
        if (!(d <= maxX)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = location.getZ();
        if (!(minZ <= d)) return false;
        if (!(d <= maxZ)) return false;
        return true;
    }

    @NotNull
    public final Location component1() {
        return this.pos1;
    }

    @NotNull
    public final Location component2() {
        return this.pos2;
    }

    @NotNull
    public final ArenaBoundaries copy(@NotNull Location pos1, @NotNull Location pos2) {
        Intrinsics.checkNotNullParameter(pos1, "pos1");
        Intrinsics.checkNotNullParameter(pos2, "pos2");
        return new ArenaBoundaries(pos1, pos2);
    }

    public static /* synthetic */ ArenaBoundaries copy$default(ArenaBoundaries arenaBoundaries, Location location, Location location2, int n, Object object) {
        if ((n & 1) != 0) {
            location = arenaBoundaries.pos1;
        }
        if ((n & 2) != 0) {
            location2 = arenaBoundaries.pos2;
        }
        return arenaBoundaries.copy(location, location2);
    }

    @NotNull
    public String toString() {
        return "ArenaBoundaries(pos1=" + this.pos1 + ", pos2=" + this.pos2 + ")";
    }

    public int hashCode() {
        int result = this.pos1.hashCode();
        result = result * 31 + this.pos2.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArenaBoundaries)) {
            return false;
        }
        ArenaBoundaries arenaBoundaries = (ArenaBoundaries)other;
        if (!Intrinsics.areEqual(this.pos1, arenaBoundaries.pos1)) {
            return false;
        }
        return Intrinsics.areEqual(this.pos2, arenaBoundaries.pos2);
    }
}

