/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaManager;
import com.hideandseek.arena.ArenaSetupSession;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.Regex;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J%\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J%\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018J%\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J=\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/hideandseek/commands/AdminCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "arenaManager", "Lcom/hideandseek/arena/ArenaManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/arena/ArenaManager;Lcom/hideandseek/game/GameManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "handleSetPos1", "", "handleSetPos2", "handleCreateGame", "(Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)V", "handleList", "handleDelete", "handleStart", "sendHelp", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nAdminCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminCommand.kt\ncom/hideandseek/commands/AdminCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1869#2,2:213\n774#2:215\n865#2,2:216\n774#2:218\n865#2,2:219\n*S KotlinDebug\n*F\n+ 1 AdminCommand.kt\ncom/hideandseek/commands/AdminCommand\n*L\n120#1:213,2\n203#1:215\n203#1:216,2\n205#1:218\n205#1:219,2\n*E\n"})
public final class AdminCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final ArenaManager arenaManager;
    @NotNull
    private final GameManager gameManager;

    public AdminCommand(@NotNull ArenaManager arenaManager, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(arenaManager, "arenaManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.arenaManager = arenaManager;
        this.gameManager = gameManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("hideandseek.admin")) {
            MessageUtil.INSTANCE.send(sender, "&cNo permission");
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "setpos1": {
                this.handleSetPos1(sender);
                break;
            }
            case "setpos2": {
                this.handleSetPos2(sender);
                break;
            }
            case "creategame": {
                this.handleCreateGame(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "delete": {
                this.handleDelete(sender, args);
                break;
            }
            case "start": {
                this.handleStart(sender, args);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private final void handleSetPos1(CommandSender sender) {
        if (!(sender instanceof Player)) {
            MessageUtil.INSTANCE.send(sender, "&cPlayer only");
            return;
        }
        Player player = (Player)sender;
        Location location = ((Player)sender).getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.arenaManager.setPos1(player, location);
        MessageUtil.INSTANCE.send(sender, "&aPos1 set: X=" + ((Player)sender).getLocation().getBlockX() + ", Y=" + ((Player)sender).getLocation().getBlockY() + ", Z=" + ((Player)sender).getLocation().getBlockZ());
    }

    private final void handleSetPos2(CommandSender sender) {
        block1: {
            if (!(sender instanceof Player)) {
                MessageUtil.INSTANCE.send(sender, "&cPlayer only");
                return;
            }
            ArenaSetupSession session = this.arenaManager.getSetupSession((Player)sender);
            Player player = (Player)sender;
            Location location = ((Player)sender).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.arenaManager.setPos2(player, location);
            MessageUtil.INSTANCE.send(sender, "&aPos2 set: X=" + ((Player)sender).getLocation().getBlockX() + ", Y=" + ((Player)sender).getLocation().getBlockY() + ", Z=" + ((Player)sender).getLocation().getBlockZ());
            ArenaSetupSession arenaSetupSession = session;
            if (arenaSetupSession == null || (arenaSetupSession = arenaSetupSession.getPos1()) == null) break block1;
            ArenaSetupSession pos1 = arenaSetupSession;
            boolean bl = false;
            double distance = pos1.distance(((Player)sender).getLocation());
            String string = "%.1f";
            Object[] objectArray = new Object[]{distance};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            MessageUtil.INSTANCE.send(sender, "&7Area size: " + string2 + " blocks (diagonal)");
        }
    }

    private final void handleCreateGame(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            MessageUtil.INSTANCE.send(sender, "&cPlayer only");
            return;
        }
        if (args.length < 2) {
            MessageUtil.INSTANCE.send(sender, "&cUsage: /hs admin creategame <name>");
            return;
        }
        String name = args[1];
        CharSequence charSequence = name;
        if (!new Regex("[a-zA-Z0-9_-]+").matches(charSequence)) {
            MessageUtil.INSTANCE.send(sender, "&cName can only contain alphanumeric characters, hyphens, and underscores");
            return;
        }
        try {
            Arena arena = ArenaManager.createArena$default(this.arenaManager, (Player)sender, name, null, 4, null);
            String[] stringArray = new String[4];
            stringArray[0] = "&aArena '" + name + "' created!";
            stringArray[1] = "&7- World: " + arena.getWorld().getName();
            String string = "%.1f";
            Object[] objectArray = new Object[]{arena.getBoundaries().getSize()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            stringArray[2] = "&7- Size: " + string2 + " blocks";
            stringArray[3] = "&7- Center: " + arena.getBoundaries().getCenter().getBlockX() + ", " + arena.getBoundaries().getCenter().getBlockY() + ", " + arena.getBoundaries().getCenter().getBlockZ();
            MessageUtil.INSTANCE.send(sender, stringArray);
        }
        catch (Exception e) {
            MessageUtil.INSTANCE.send(sender, "&c" + e.getMessage());
        }
    }

    private final void handleList(CommandSender sender) {
        Map<String, Arena> arenas = this.arenaManager.getAllArenas();
        if (arenas.isEmpty()) {
            MessageUtil.INSTANCE.send(sender, "&7No arenas configured. Use /hs admin creategame to create one.");
            return;
        }
        MessageUtil.INSTANCE.send(sender, "&e===[ Arenas ]===");
        Iterable $this$forEach$iv = arenas.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Arena arena = (Arena)element$iv;
            boolean bl = false;
            MessageUtil.INSTANCE.send(sender, "&a- " + arena.getName() + " &7(" + arena.getWorld().getName() + ")");
        }
        MessageUtil.INSTANCE.send(sender, "&7Total: " + arenas.size());
    }

    private final void handleDelete(CommandSender sender, String[] args) {
        if (args.length < 2) {
            MessageUtil.INSTANCE.send(sender, "&cUsage: /hs admin delete <name>");
            return;
        }
        String name = args[1];
        try {
            if (this.arenaManager.deleteArena(name)) {
                MessageUtil.INSTANCE.send(sender, "&aArena '" + name + "' deleted");
            } else {
                MessageUtil.INSTANCE.send(sender, "&cArena '" + name + "' not found");
            }
        }
        catch (Exception e) {
            MessageUtil.INSTANCE.send(sender, "&c" + e.getMessage());
        }
    }

    private final void handleStart(CommandSender sender, String[] args) {
        if (args.length < 2) {
            MessageUtil.INSTANCE.send(sender, "&cUsage: /hs admin start <arena-name>");
            return;
        }
        String arenaName = args[1];
        Arena arena = this.arenaManager.getArena(arenaName);
        if (arena == null) {
            MessageUtil.INSTANCE.send(sender, "&cArena '" + arenaName + "' not found. Use /hs admin list to see available arenas.");
            return;
        }
        if (this.gameManager.getActiveGame() != null) {
            MessageUtil.INSTANCE.send(sender, "&cGame already in progress");
            return;
        }
        int waitingCount = this.gameManager.getWaitingPlayers().size();
        if (waitingCount < 2) {
            MessageUtil.INSTANCE.send(sender, "&cMinimum 2 players required (current: " + waitingCount + ")");
            return;
        }
        Game game = this.gameManager.startGame(arena);
        if (game != null) {
            MessageUtil.INSTANCE.send(sender, "&aGame started on arena '" + arenaName + "'!");
            MessageUtil.INSTANCE.send(sender, "&7Players: " + waitingCount);
            MessageUtil.INSTANCE.send(sender, "&7Seekers: " + game.getSeekers().size() + ", Hiders: " + game.getHiders().size());
        } else {
            MessageUtil.INSTANCE.send(sender, "&cFailed to start game");
        }
    }

    private final void sendHelp(CommandSender sender) {
        String[] stringArray = new String[]{"&e===[ Hide and Seek Admin ]===", "&7/hs admin setpos1 &f- Set first corner", "&7/hs admin setpos2 &f- Set second corner", "&7/hs admin creategame <name> &f- Create arena", "&7/hs admin list &f- List arenas", "&7/hs admin delete <name> &f- Delete arena", "&7/hs admin start <arena> &f- Start game"};
        MessageUtil.INSTANCE.send(sender, stringArray);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("hideandseek.admin")) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object var5_5 = new String[]{"setpos1", "setpos2", "creategame", "list", "delete", "start"};
                var5_5 = CollectionsKt.listOf(var5_5);
                boolean $i$f$filter = false;
                void var7_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean $i$a$-filter-AdminCommand$onTabComplete$1 = false;
                    String v0 = args[0].toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v0, "toLowerCase(...)");
                    if (!StringsKt.startsWith$default(it, v0, false, 2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> {
                String v2 = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(v2, "toLowerCase(...)");
                String var5_6 = v2;
                if (Intrinsics.areEqual(var5_6, "delete") || Intrinsics.areEqual(var5_6, "start")) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.arenaManager.getArenaNames();
                    boolean $i$f$filter = false;
                    Iterable destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean $i$a$-filter-AdminCommand$onTabComplete$2 = false;
                        String v3 = args[1].toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v3, "toLowerCase(...)");
                        if (!StringsKt.startsWith$default(it, v3, false, 2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    yield (List)destination$iv$iv;
                }
                yield null;
            }
            default -> null;
        };
    }
}

