/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.shop.ShopManager;
import com.hideandseek.utils.MessageUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/hideandseek/commands/ShopCommand;", "Lorg/bukkit/command/CommandExecutor;", "shopManager", "Lcom/hideandseek/shop/ShopManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/shop/ShopManager;Lcom/hideandseek/game/GameManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "EasyHideAndSeek"})
public final class ShopCommand
implements CommandExecutor {
    @NotNull
    private final ShopManager shopManager;
    @NotNull
    private final GameManager gameManager;

    public ShopCommand(@NotNull ShopManager shopManager, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(shopManager, "shopManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.shopManager = shopManager;
        this.gameManager = gameManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(sender instanceof Player)) {
            MessageUtil.INSTANCE.send(sender, "&cOnly players can use this command");
            return true;
        }
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            MessageUtil.INSTANCE.send(sender, "&cNo active game");
            return true;
        }
        PlayerGameData playerData = game.getPlayers().get(((Player)sender).getUniqueId());
        if (playerData == null) {
            MessageUtil.INSTANCE.send(sender, "&cYou are not in this game");
            return true;
        }
        String playerRole = playerData.getRole().name();
        sender.sendMessage("\u00a7a[DEBUG ShopCommand] Player role: " + playerRole);
        sender.sendMessage("\u00a7a[DEBUG ShopCommand] PlayerData.role: " + playerData.getRole());
        this.shopManager.openMainMenu((Player)sender, playerRole);
        return true;
    }
}

