/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.GameResult;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.spectator.SpectatorManager;
import com.hideandseek.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J=\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/hideandseek/commands/SpectatorCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "spectatorManager", "Lcom/hideandseek/spectator/SpectatorManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/spectator/SpectatorManager;Lcom/hideandseek/game/GameManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "handleSpectatorOn", "", "player", "Lorg/bukkit/entity/Player;", "handleSpectatorOff", "joinGameAsHider", "game", "Lcom/hideandseek/game/Game;", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nSpectatorCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpectatorCommand.kt\ncom/hideandseek/commands/SpectatorCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n774#2:192\n865#2,2:193\n*S KotlinDebug\n*F\n+ 1 SpectatorCommand.kt\ncom/hideandseek/commands/SpectatorCommand\n*L\n186#1:192\n186#1:193,2\n*E\n"})
public final class SpectatorCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final SpectatorManager spectatorManager;
    @NotNull
    private final GameManager gameManager;

    public SpectatorCommand(@NotNull SpectatorManager spectatorManager, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(spectatorManager, "spectatorManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.spectatorManager = spectatorManager;
        this.gameManager = gameManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String mode;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players");
            return true;
        }
        if (!sender.hasPermission("hideandseek.spectate")) {
            MessageUtil.INSTANCE.send(sender, "&c\u3053\u306e\u30b3\u30de\u30f3\u30c9\u3092\u4f7f\u7528\u3059\u308b\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093");
            return true;
        }
        if (args.length == 0) {
            MessageUtil.INSTANCE.send(sender, "&c\u4f7f\u7528\u65b9\u6cd5: /hs spectator <on|off>");
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String string2 = mode = string;
        if (Intrinsics.areEqual(string2, "on")) {
            this.handleSpectatorOn((Player)sender);
        } else if (Intrinsics.areEqual(string2, "off")) {
            this.handleSpectatorOff((Player)sender);
        } else {
            MessageUtil.INSTANCE.send(sender, "&c\u4f7f\u7528\u65b9\u6cd5: /hs spectator <on|off>");
        }
        return true;
    }

    private final void handleSpectatorOn(Player player) {
        Game game;
        Game game2 = game = this.gameManager.getActiveGame();
        GamePhase currentPhase = game2 != null ? game2.getPhase() : null;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (this.spectatorManager.isSpectator(uUID)) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&e\u65e2\u306b\u89b3\u6226\u30e2\u30fc\u30c9\u3067\u3059");
            return;
        }
        GamePhase gamePhase = currentPhase;
        switch (gamePhase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[gamePhase.ordinal()]) {
            case -1: 
            case 1: 
            case 2: {
                this.spectatorManager.toggleSpectator(player, true);
                MessageUtil.INSTANCE.send((CommandSender)player, "&a\u89b3\u6226\u30e2\u30fc\u30c9\u3092\u6709\u52b9\u306b\u3057\u307e\u3057\u305f\u3002\u6b21\u306e\u30b2\u30fc\u30e0\u304b\u3089\u89b3\u6226\u8005\u3068\u3057\u3066\u53c2\u52a0\u3057\u307e\u3059");
                break;
            }
            case 3: {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30b2\u30fc\u30e0\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u6b21\u306e\u30b2\u30fc\u30e0\u3092\u304a\u5f85\u3061\u304f\u3060\u3055\u3044");
                break;
            }
            case 4: 
            case 5: {
                if (player.hasPermission("hideandseek.admin") || player.isOp()) {
                    List<UUID> remainingHiders;
                    this.spectatorManager.toggleSpectator(player, true);
                    this.spectatorManager.applySpectatorMode(player);
                    PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
                    boolean wasHider = (playerGameData != null ? playerGameData.getRole() : null) == PlayerRole.HIDER;
                    game.getPlayers().remove(player.getUniqueId());
                    MessageUtil.INSTANCE.send((CommandSender)player, "&a\u89b3\u6226\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048\u307e\u3057\u305f");
                    this.gameManager.broadcastToActiveGame("&7" + player.getName() + " \u304c\u89b3\u6226\u30e2\u30fc\u30c9\u306b\u306a\u308a\u307e\u3057\u305f");
                    if (!wasHider || !(remainingHiders = game.getHiders()).isEmpty()) break;
                    this.gameManager.endGame(GameResult.SEEKER_WIN);
                    break;
                }
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30b2\u30fc\u30e0\u4e2d\u306f\u89b3\u6226\u30e2\u30fc\u30c9\u306b\u5909\u66f4\u3067\u304d\u307e\u305b\u3093");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void handleSpectatorOff(Player player) {
        Game game;
        Game game2 = game = this.gameManager.getActiveGame();
        GamePhase currentPhase = game2 != null ? game2.getPhase() : null;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (!this.spectatorManager.isSpectator(uUID)) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&e\u65e2\u306b\u901a\u5e38\u30e2\u30fc\u30c9\u3067\u3059");
            return;
        }
        GamePhase gamePhase = currentPhase;
        switch (gamePhase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[gamePhase.ordinal()]) {
            case -1: 
            case 1: 
            case 2: {
                this.spectatorManager.toggleSpectator(player, false);
                MessageUtil.INSTANCE.send((CommandSender)player, "&a\u89b3\u6226\u30e2\u30fc\u30c9\u3092\u7121\u52b9\u306b\u3057\u307e\u3057\u305f\u3002\u6b21\u306e\u30b2\u30fc\u30e0\u304b\u3089\u901a\u5e38\u30d7\u30ec\u30a4\u30e4\u30fc\u3068\u3057\u3066\u53c2\u52a0\u3057\u307e\u3059");
                break;
            }
            case 3: {
                this.spectatorManager.toggleSpectator(player, false);
                MessageUtil.INSTANCE.send((CommandSender)player, "&a\u89b3\u6226\u30e2\u30fc\u30c9\u3092\u7121\u52b9\u306b\u3057\u307e\u3057\u305f\u3002\u6b21\u306e\u30b2\u30fc\u30e0\u304b\u3089\u901a\u5e38\u30d7\u30ec\u30a4\u30e4\u30fc\u3068\u3057\u3066\u53c2\u52a0\u3057\u307e\u3059");
                break;
            }
            case 4: 
            case 5: {
                if (game != null && this.joinGameAsHider(player, game)) {
                    this.spectatorManager.toggleSpectator(player, false);
                    this.spectatorManager.removeSpectatorMode(player);
                    MessageUtil.INSTANCE.send((CommandSender)player, "&a\u9003\u8d70\u8005\u3068\u3057\u3066\u53c2\u52a0\u3057\u307e\u3057\u305f");
                    break;
                }
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30b2\u30fc\u30e0\u3078\u306e\u53c2\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean joinGameAsHider(Player player, Game game) {
        if (game.getHiders().isEmpty() && !((Collection)game.getCaptured()).isEmpty()) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u5168\u3066\u306e\u9003\u8d70\u8005\u304c\u6355\u307e\u3063\u3066\u3044\u307e\u3059\u3002\u6b21\u306e\u30b2\u30fc\u30e0\u3092\u304a\u5f85\u3061\u304f\u3060\u3055\u3044");
            return false;
        }
        Map<UUID, PlayerGameData> map = game.getPlayers();
        UUID uUID = player.getUniqueId();
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        PlayerGameData playerGameData = new PlayerGameData(uUID2, PlayerRole.HIDER, false, 0, null, null, 0, 0, 248, null);
        map.put(uUID, playerGameData);
        Location spawnLocation = GameManager.getRandomSpawnLocation$default(this.gameManager, game.getArena(), null, 0, 6, null);
        player.teleport(spawnLocation);
        player.setGameMode(GameMode.ADVENTURE);
        this.gameManager.giveShopItemToPlayer(player);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 1) {
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{"on", "off"};
            Iterable $this$filter$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String string = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GamePhase.values().length];
            try {
                nArray[GamePhase.WAITING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.POST_GAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.ENDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.PREPARATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.SEEKING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

