/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.disguise;

import com.hideandseek.disguise.DisguiseData;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.utils.MessageUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\nJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\nJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/hideandseek/disguise/DisguiseManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/game/GameManager;)V", "disguises", "", "Ljava/util/UUID;", "Lcom/hideandseek/disguise/DisguiseData;", "blockLocations", "Lorg/bukkit/Location;", "disguise", "", "player", "Lorg/bukkit/entity/Player;", "blockType", "Lorg/bukkit/Material;", "undisguise", "reason", "", "undisguiseByLocation", "location", "isDisguised", "playerId", "getDisguiseLocation", "getDisguisedPlayerAt", "clearAllDisguises", "", "getActiveDisguises", "", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nDisguiseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisguiseManager.kt\ncom/hideandseek/disguise/DisguiseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1869#2,2:142\n*S KotlinDebug\n*F\n+ 1 DisguiseManager.kt\ncom/hideandseek/disguise/DisguiseManager\n*L\n128#1:142,2\n*E\n"})
public final class DisguiseManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final Map<UUID, DisguiseData> disguises;
    @NotNull
    private final Map<Location, UUID> blockLocations;

    public DisguiseManager(@NotNull Plugin plugin, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.plugin = plugin;
        this.gameManager = gameManager;
        this.disguises = new LinkedHashMap();
        this.blockLocations = new LinkedHashMap();
    }

    public final boolean disguise(@NotNull Player player, @NotNull Material blockType) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(blockType, "blockType");
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cNo active game");
            return false;
        }
        PlayerGameData playerData = game.getPlayers().get(player.getUniqueId());
        if (playerData == null) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cYou are not in this game");
            return false;
        }
        if (playerData.getRole() != PlayerRole.HIDER) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cOnly hiders can disguise");
            return false;
        }
        if (playerData.isCaptured()) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cYou have been captured");
            return false;
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (this.isDisguised(uUID)) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cYou are already disguised");
            return false;
        }
        Location location = player.getLocation().getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location footLocation = location;
        if (this.blockLocations.containsKey(footLocation)) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cSomeone is already disguised here");
            return false;
        }
        Block block = footLocation.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        BlockData blockData = block2.getBlockData().clone();
        Intrinsics.checkNotNullExpressionValue(blockData, "clone(...)");
        BlockData originalBlockData = blockData;
        block2.setType(blockType);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false));
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        DisguiseData disguiseData = new DisguiseData(uUID2, footLocation, blockType, originalBlockData, 0L, 16, null);
        this.disguises.put(player.getUniqueId(), disguiseData);
        this.blockLocations.put(footLocation, player.getUniqueId());
        MessageUtil.INSTANCE.send((CommandSender)player, "&aDisguised as " + blockType.name());
        return true;
    }

    /*
     * Exception decompiling
     */
    public final boolean undisguise(@NotNull Player player, @NotNull String reason) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl51 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl51 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ boolean undisguise$default(DisguiseManager disguiseManager, Player player, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "manual";
        }
        return disguiseManager.undisguise(player, string);
    }

    @Nullable
    public final Player undisguiseByLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        UUID uUID = this.blockLocations.get(location);
        if (uUID == null) {
            return null;
        }
        UUID playerId = uUID;
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return null;
        }
        Player player2 = player;
        this.undisguise(player2, "capture");
        return player2;
    }

    public final boolean isDisguised(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        return this.disguises.containsKey(playerId);
    }

    @Nullable
    public final Location getDisguiseLocation(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        DisguiseData disguiseData = this.disguises.get(playerId);
        return disguiseData != null ? disguiseData.getBlockLocation() : null;
    }

    @Nullable
    public final UUID getDisguisedPlayerAt(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.blockLocations.get(location);
    }

    public final void clearAllDisguises() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.disguises.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)playerId) == null) continue;
            boolean bl2 = false;
            this.undisguise(player, "game_end");
        }
        this.disguises.clear();
        this.blockLocations.clear();
    }

    @NotNull
    public final Map<UUID, DisguiseData> getActiveDisguises() {
        return MapsKt.toMap(this.disguises);
    }
}

