/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.game;

import com.hideandseek.arena.Arena;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.GameResult;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.game.WorldBorderBackup;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b!\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\r\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\n04J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\n04J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\n04J\u0006\u00107\u001a\u00020\rJ\u000e\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\rJ\u0010\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\rJ\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\t\u0010>\u001a\u00020\u0005H\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0003J\t\u0010A\u001a\u00020\rH\u00c6\u0003J\t\u0010B\u001a\u00020\rH\u00c6\u0003J\u000b\u0010C\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u0010\u0010D\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003\u00a2\u0006\u0002\u0010+J\t\u0010E\u001a\u00020\rH\u00c6\u0003J\u0010\u0010F\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003\u00a2\u0006\u0002\u0010+J\u0084\u0001\u0010G\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001\u00a2\u0006\u0002\u0010HJ\u0013\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010L\u001a\u00020\u0012H\u00d6\u0001J\t\u0010M\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\"\"\u0004\b$\u0010%R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\u0013\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\"\"\u0004\b0\u0010%R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010.\u001a\u0004\b1\u0010+\"\u0004\b2\u0010-\u00a8\u0006N"}, d2={"Lcom/hideandseek/game/Game;", "", "id", "", "arena", "Lcom/hideandseek/arena/Arena;", "phase", "Lcom/hideandseek/game/GamePhase;", "players", "", "Ljava/util/UUID;", "Lcom/hideandseek/game/PlayerGameData;", "startTime", "", "phaseStartTime", "worldBorderBackup", "Lcom/hideandseek/game/WorldBorderBackup;", "autoRestartTaskId", "", "autoRestartStartTime", "nightSkipTaskId", "<init>", "(Ljava/lang/String;Lcom/hideandseek/arena/Arena;Lcom/hideandseek/game/GamePhase;Ljava/util/Map;JJLcom/hideandseek/game/WorldBorderBackup;Ljava/lang/Integer;JLjava/lang/Integer;)V", "getId", "()Ljava/lang/String;", "getArena", "()Lcom/hideandseek/arena/Arena;", "getPhase", "()Lcom/hideandseek/game/GamePhase;", "setPhase", "(Lcom/hideandseek/game/GamePhase;)V", "getPlayers", "()Ljava/util/Map;", "getStartTime", "()J", "getPhaseStartTime", "setPhaseStartTime", "(J)V", "getWorldBorderBackup", "()Lcom/hideandseek/game/WorldBorderBackup;", "setWorldBorderBackup", "(Lcom/hideandseek/game/WorldBorderBackup;)V", "getAutoRestartTaskId", "()Ljava/lang/Integer;", "setAutoRestartTaskId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getAutoRestartStartTime", "setAutoRestartStartTime", "getNightSkipTaskId", "setNightSkipTaskId", "getSeekers", "", "getHiders", "getCaptured", "getElapsedTime", "getRemainingTime", "maxTime", "checkWinCondition", "Lcom/hideandseek/game/GameResult;", "seekTime", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(Ljava/lang/String;Lcom/hideandseek/arena/Arena;Lcom/hideandseek/game/GamePhase;Ljava/util/Map;JJLcom/hideandseek/game/WorldBorderBackup;Ljava/lang/Integer;JLjava/lang/Integer;)Lcom/hideandseek/game/Game;", "equals", "", "other", "hashCode", "toString", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nGame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Game.kt\ncom/hideandseek/game/Game\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,48:1\n536#2:49\n521#2,6:50\n536#2:56\n521#2,6:57\n536#2:63\n521#2,6:64\n*S KotlinDebug\n*F\n+ 1 Game.kt\ncom/hideandseek/game/Game\n*L\n19#1:49\n19#1:50,6\n23#1:56\n23#1:57,6\n27#1:63\n27#1:64,6\n*E\n"})
public final class Game {
    @NotNull
    private final String id;
    @NotNull
    private final Arena arena;
    @NotNull
    private GamePhase phase;
    @NotNull
    private final Map<UUID, PlayerGameData> players;
    private final long startTime;
    private long phaseStartTime;
    @Nullable
    private WorldBorderBackup worldBorderBackup;
    @Nullable
    private Integer autoRestartTaskId;
    private long autoRestartStartTime;
    @Nullable
    private Integer nightSkipTaskId;

    public Game(@NotNull String id, @NotNull Arena arena, @NotNull GamePhase phase, @NotNull Map<UUID, PlayerGameData> players, long startTime, long phaseStartTime, @Nullable WorldBorderBackup worldBorderBackup, @Nullable Integer autoRestartTaskId, long autoRestartStartTime, @Nullable Integer nightSkipTaskId) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        Intrinsics.checkNotNullParameter(players, "players");
        this.id = id;
        this.arena = arena;
        this.phase = phase;
        this.players = players;
        this.startTime = startTime;
        this.phaseStartTime = phaseStartTime;
        this.worldBorderBackup = worldBorderBackup;
        this.autoRestartTaskId = autoRestartTaskId;
        this.autoRestartStartTime = autoRestartStartTime;
        this.nightSkipTaskId = nightSkipTaskId;
    }

    public /* synthetic */ Game(String string, Arena arena, GamePhase gamePhase, Map map, long l, long l2, WorldBorderBackup worldBorderBackup, Integer n, long l3, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            string = string2;
        }
        if ((n3 & 0x40) != 0) {
            worldBorderBackup = null;
        }
        if ((n3 & 0x80) != 0) {
            n = null;
        }
        if ((n3 & 0x100) != 0) {
            l3 = 0L;
        }
        if ((n3 & 0x200) != 0) {
            n2 = null;
        }
        this(string, arena, gamePhase, map, l, l2, worldBorderBackup, n, l3, n2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Arena getArena() {
        return this.arena;
    }

    @NotNull
    public final GamePhase getPhase() {
        return this.phase;
    }

    public final void setPhase(@NotNull GamePhase gamePhase) {
        Intrinsics.checkNotNullParameter((Object)gamePhase, "<set-?>");
        this.phase = gamePhase;
    }

    @NotNull
    public final Map<UUID, PlayerGameData> getPlayers() {
        return this.players;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getPhaseStartTime() {
        return this.phaseStartTime;
    }

    public final void setPhaseStartTime(long l) {
        this.phaseStartTime = l;
    }

    @Nullable
    public final WorldBorderBackup getWorldBorderBackup() {
        return this.worldBorderBackup;
    }

    public final void setWorldBorderBackup(@Nullable WorldBorderBackup worldBorderBackup) {
        this.worldBorderBackup = worldBorderBackup;
    }

    @Nullable
    public final Integer getAutoRestartTaskId() {
        return this.autoRestartTaskId;
    }

    public final void setAutoRestartTaskId(@Nullable Integer n) {
        this.autoRestartTaskId = n;
    }

    public final long getAutoRestartStartTime() {
        return this.autoRestartStartTime;
    }

    public final void setAutoRestartStartTime(long l) {
        this.autoRestartStartTime = l;
    }

    @Nullable
    public final Integer getNightSkipTaskId() {
        return this.nightSkipTaskId;
    }

    public final void setNightSkipTaskId(@Nullable Integer n) {
        this.nightSkipTaskId = n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UUID> getSeekers() {
        void $this$filterTo$iv$iv;
        Map<UUID, PlayerGameData> $this$filter$iv = this.players;
        boolean $i$f$filter = false;
        Map<UUID, PlayerGameData> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((PlayerGameData)it.getValue()).getRole() == PlayerRole.SEEKER)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList(destination$iv$iv.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UUID> getHiders() {
        void $this$filterTo$iv$iv;
        Map<UUID, PlayerGameData> $this$filter$iv = this.players;
        boolean $i$f$filter = false;
        Map<UUID, PlayerGameData> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((PlayerGameData)it.getValue()).getRole() == PlayerRole.HIDER && !((PlayerGameData)it.getValue()).isCaptured())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList(destination$iv$iv.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UUID> getCaptured() {
        void $this$filterTo$iv$iv;
        Map<UUID, PlayerGameData> $this$filter$iv = this.players;
        boolean $i$f$filter = false;
        Map<UUID, PlayerGameData> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((PlayerGameData)it.getValue()).getRole() == PlayerRole.HIDER && ((PlayerGameData)it.getValue()).isCaptured())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList(destination$iv$iv.keySet());
    }

    public final long getElapsedTime() {
        return System.currentTimeMillis() - this.phaseStartTime;
    }

    public final long getRemainingTime(long maxTime) {
        return maxTime - this.getElapsedTime();
    }

    @Nullable
    public final GameResult checkWinCondition(long seekTime) {
        List<UUID> remainingHiders = this.getHiders();
        return remainingHiders.isEmpty() ? GameResult.SEEKER_WIN : (this.getRemainingTime(seekTime) <= 0L ? GameResult.HIDER_WIN : null);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final Arena component2() {
        return this.arena;
    }

    @NotNull
    public final GamePhase component3() {
        return this.phase;
    }

    @NotNull
    public final Map<UUID, PlayerGameData> component4() {
        return this.players;
    }

    public final long component5() {
        return this.startTime;
    }

    public final long component6() {
        return this.phaseStartTime;
    }

    @Nullable
    public final WorldBorderBackup component7() {
        return this.worldBorderBackup;
    }

    @Nullable
    public final Integer component8() {
        return this.autoRestartTaskId;
    }

    public final long component9() {
        return this.autoRestartStartTime;
    }

    @Nullable
    public final Integer component10() {
        return this.nightSkipTaskId;
    }

    @NotNull
    public final Game copy(@NotNull String id, @NotNull Arena arena, @NotNull GamePhase phase, @NotNull Map<UUID, PlayerGameData> players, long startTime, long phaseStartTime, @Nullable WorldBorderBackup worldBorderBackup, @Nullable Integer autoRestartTaskId, long autoRestartStartTime, @Nullable Integer nightSkipTaskId) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        Intrinsics.checkNotNullParameter(players, "players");
        return new Game(id, arena, phase, players, startTime, phaseStartTime, worldBorderBackup, autoRestartTaskId, autoRestartStartTime, nightSkipTaskId);
    }

    public static /* synthetic */ Game copy$default(Game game, String string, Arena arena, GamePhase gamePhase, Map map, long l, long l2, WorldBorderBackup worldBorderBackup, Integer n, long l3, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = game.id;
        }
        if ((n3 & 2) != 0) {
            arena = game.arena;
        }
        if ((n3 & 4) != 0) {
            gamePhase = game.phase;
        }
        if ((n3 & 8) != 0) {
            map = game.players;
        }
        if ((n3 & 0x10) != 0) {
            l = game.startTime;
        }
        if ((n3 & 0x20) != 0) {
            l2 = game.phaseStartTime;
        }
        if ((n3 & 0x40) != 0) {
            worldBorderBackup = game.worldBorderBackup;
        }
        if ((n3 & 0x80) != 0) {
            n = game.autoRestartTaskId;
        }
        if ((n3 & 0x100) != 0) {
            l3 = game.autoRestartStartTime;
        }
        if ((n3 & 0x200) != 0) {
            n2 = game.nightSkipTaskId;
        }
        return game.copy(string, arena, gamePhase, map, l, l2, worldBorderBackup, n, l3, n2);
    }

    @NotNull
    public String toString() {
        return "Game(id=" + this.id + ", arena=" + this.arena + ", phase=" + this.phase + ", players=" + this.players + ", startTime=" + this.startTime + ", phaseStartTime=" + this.phaseStartTime + ", worldBorderBackup=" + this.worldBorderBackup + ", autoRestartTaskId=" + this.autoRestartTaskId + ", autoRestartStartTime=" + this.autoRestartStartTime + ", nightSkipTaskId=" + this.nightSkipTaskId + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.arena.hashCode();
        result = result * 31 + this.phase.hashCode();
        result = result * 31 + ((Object)this.players).hashCode();
        result = result * 31 + Long.hashCode(this.startTime);
        result = result * 31 + Long.hashCode(this.phaseStartTime);
        result = result * 31 + (this.worldBorderBackup == null ? 0 : this.worldBorderBackup.hashCode());
        result = result * 31 + (this.autoRestartTaskId == null ? 0 : ((Object)this.autoRestartTaskId).hashCode());
        result = result * 31 + Long.hashCode(this.autoRestartStartTime);
        result = result * 31 + (this.nightSkipTaskId == null ? 0 : ((Object)this.nightSkipTaskId).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Game)) {
            return false;
        }
        Game game = (Game)other;
        if (!Intrinsics.areEqual(this.id, game.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.arena, game.arena)) {
            return false;
        }
        if (this.phase != game.phase) {
            return false;
        }
        if (!Intrinsics.areEqual(this.players, game.players)) {
            return false;
        }
        if (this.startTime != game.startTime) {
            return false;
        }
        if (this.phaseStartTime != game.phaseStartTime) {
            return false;
        }
        if (!Intrinsics.areEqual(this.worldBorderBackup, game.worldBorderBackup)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.autoRestartTaskId, game.autoRestartTaskId)) {
            return false;
        }
        if (this.autoRestartStartTime != game.autoRestartStartTime) {
            return false;
        }
        return Intrinsics.areEqual(this.nightSkipTaskId, game.nightSkipTaskId);
    }
}

